/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.tree;

import com.ca.symdump.Abend;
import com.ca.symdump.Activator;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.views.tree.DumpTreeContentProvider;
import com.ca.symdump.views.tree.DumpTreeDoubleClickListener;
import com.ca.symdump.views.tree.DumpTreeLabelProvider;
import com.ca.testingtools.common.TTException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DumpTreeView
extends ViewPart
implements ISaveablePart2 {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String CLOSE_ONE = "This will close the reports view and other information related to the open dump.";
    private static final String CLOSE_MANY = "This will close the reports view and other information related to all %d open dumps.";
    private static final String CLOSE_MESSAGE = "Are you sure you want to close this view?\n%s";
    private static final String CONFIRM_CLOSE = "Confirm Close";
    private static final String DESCRIPTION_TEXT = "CA SymDump Tree Viewer";
    public static final String ID = "com.ca.symdump.ui.views.treeview";
    public static final String CONTEXT_HELP_ID = "com.ca.symdump.help.dumptreeview";
    protected TreeViewer treeViewer;
    private ArrayList<Abend> abends = new ArrayList();
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private boolean dirty = false;

    public void createPartControl(Composite parent) {
        this.setTitleToolTip(DESCRIPTION_TEXT);
        this.treeViewer = new TreeViewer(parent, 68354);
        this.treeViewer.setContentProvider((IContentProvider)new DumpTreeContentProvider());
        DumpTreeLabelProvider labelProvider = new DumpTreeLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.treeViewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
        Control control = this.treeViewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new DumpTreeDoubleClickListener());
        this.treeViewer.setInput(null);
        menu.addMenuListener(new MenuListener(){
            private boolean buttonShown = true;

            public void menuShown(MenuEvent e) {
                if (this.buttonShown) {
                    Menu menu = (Menu)e.getSource();
                    HashMap<String, MenuItem> menuMap = new HashMap<String, MenuItem>();
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        if (menuMap.put(item.getText(), item) != null) {
                            item.dispose();
                        }
                        ++n2;
                    }
                    this.buttonShown = false;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    public void removeContent(Abend oldAbend) {
        if (oldAbend == null) {
            return;
        }
        if (this.abends.contains(oldAbend)) {
            this.abends.remove(oldAbend);
            oldAbend.closeDump(true);
            this.setInput();
        }
    }

    private void setInput() {
        ArrayList<DumpTreeNode> nodes = new ArrayList<DumpTreeNode>(this.abends.size());
        Iterator<Abend> it = this.abends.iterator();
        while (it.hasNext()) {
            Abend abend = it.next();
            DumpTreeNode node = null;
            if (!abend.isOpen()) continue;
            try {
                node = abend.getDumpTree(false);
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
            if (node == null) {
                it.remove();
                continue;
            }
            nodes.add(node);
        }
        this.treeViewer.setInput((Object)nodes.toArray(new DumpTreeNode[nodes.size()]));
        this.treeViewer.refresh(true);
        this.treeViewer.expandToLevel(2);
    }

    public synchronized void addContent(Abend newAbend) {
        if (newAbend == null) {
            return;
        }
        if (!this.abends.contains(newAbend)) {
            this.abends.add(newAbend);
            this.setInput();
        }
    }

    public void setFocus() {
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    private void close(boolean closing) {
        for (Abend abend : this.abends) {
            abend.closeDump(!closing);
        }
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            String id = viewRef.getId();
            if (id.equals("com.ca.symdump.ui.views.reportsview") || id.equals("com.ca.symdump.ui.views.cicstraceview")) {
                try {
                    page.hideView(viewRef);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        this.abends.clear();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        boolean closing = Activator.plugin.getWorkbench().isClosing();
        if (closing) {
            this.dirty = true;
        }
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        this.dirty = true;
        return true;
    }

    public int promptToSaveOnClose() {
        this.dirty = false;
        int count = this.abends.size();
        boolean closing = Activator.plugin.getWorkbench().isClosing();
        if (closing || count == 0) {
            this.close(closing);
            return 0;
        }
        String title = CONFIRM_CLOSE;
        String messageformat = CLOSE_MESSAGE;
        String message = count > 1 ? String.format(CLOSE_MANY, count) : CLOSE_ONE;
        boolean result = MessageDialog.openQuestion(null, (String)title, (String)(message = String.format(messageformat, message)));
        if (result) {
            this.close(closing);
            return 0;
        }
        return 2;
    }
}

