/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.IPacketMessage;
import com.ca.testingtools.common.IStatusMessage;
import com.ca.testingtools.common.Numbers;
import com.ca.testingtools.common.PacketMessage;
import com.ca.testingtools.common.TTException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class StatusMessage
extends PacketMessage
implements IPacketMessage,
IStatusMessage {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final String DELIMIT_STACK_TRACE = "<<-- STACK_TRACE -->>";
    protected static String linefeed = System.getProperty("line.separator");
    private static final String STATUS_FORMAT = "RequestorID:%1$d %2$s";
    private static final String STATUS_FORMAT_NOREQESTOR = "%2$s";
    public static final short BASE_REASON_CODE = 1000;
    public static final short SECURITY_FAIL = 1000;
    private static final String[] reasons = new String[]{"SECURITY_FAIL"};
    protected String extraText = "";
    protected ArrayList<String> messages = new ArrayList();
    protected int requestseqno = 0;
    private short reasonCode = 0;

    public StatusMessage() {
    }

    public StatusMessage(ByteBuffer buffer) throws Exception {
        this();
        this.extractMessage(buffer);
    }

    public StatusMessage(short status, String message) {
        this();
        this.setStatus(status);
        this.setMessage(message);
    }

    public StatusMessage(Throwable e) {
        this();
        this.setStatus((short)16);
        this.setMessages(e);
    }

    public void addMessage(String message) {
        this.addMessages(new String[]{message});
    }

    public void addMessages(String[] messages) {
        if (messages != null) {
            String item;
            for (String item2 : messages) {
                String[] lines;
                if (item2 == null) continue;
                item2 = item2.replace('\u0000', ' ');
                for (String line : lines = item2.split(linefeed)) {
                    this.messages.add(HexUtil.rightTrim(line));
                }
            }
            boolean found = false;
            for (int i = this.messages.size() - 1; i > 0 && ((item = this.messages.get(i)) == null || item.length() == 0); --i) {
                this.messages.set(1, null);
                found = true;
            }
            if (found) {
                Iterator<String> it = this.messages.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                }
            }
        }
    }

    public String getExtraText() {
        return this.extraText;
    }

    public String getMessage() {
        return this.getMessage(true);
    }

    public String getMessage(boolean trim) {
        StringBuilder text = new StringBuilder("");
        int deleteix = 0;
        for (String line : this.messages) {
            if (trim && line.length() == 0) continue;
            text.append(line);
            deleteix = text.length();
            text.append(linefeed);
        }
        text.setLength(deleteix);
        return text.toString();
    }

    public String getMessage(int messagenumber) {
        try {
            return this.messages.get(messagenumber);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String[] getMessages() {
        return this.messages.toArray(new String[this.messages.size()]);
    }

    public short getReasonCode() {
        return this.reasonCode;
    }

    public int getRequestseqno() {
        return this.requestseqno;
    }

    public short getStatus() {
        return this.getSubmessageID();
    }

    public void logStatus() {
        this.logStatus(null, null);
    }

    public void logStatus(Exception e) {
        this.logStatus(null, e);
    }

    public void logStatus(String string, Exception exception) {
        short status = this.getStatus();
        Level level = status < 4 ? Level.INFO : (status < 8 ? Level.WARNING : Level.SEVERE);
        if (string != null) {
            this.log.log(level, string);
        }
        this.log.log(level, "Status:{0} Message #: {1} {2}", new Object[]{(int)status, this.sequencenumber, this.getMessage()});
        if (exception != null && this.getStatus() > 7) {
            this.log.log(level, "", exception);
        }
    }

    public void setExtraText(String extraText) {
        this.extraText = extraText;
    }

    public void setMessage(String message) {
        this.setMessages(new String[]{message});
    }

    public void setMessages(String[] messages) {
        this.messages.clear();
        this.addMessages(messages);
    }

    public void setMessages(Throwable exception) {
        this.setMessages(new String[]{HexUtil.getErrorText(exception), DELIMIT_STACK_TRACE});
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        String stack = writer.toString();
        ArrayList<String> messages = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(stack));
        try {
            String line = reader.readLine();
            while (line != null) {
                messages.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.addMessages(messages.toArray(new String[messages.size()]));
    }

    public void setReasonCode(short reasonCode) {
        this.reasonCode = reasonCode < 1000 ? (short)0 : reasonCode;
    }

    public void setRequestseqno(int requestseqno) {
        this.requestseqno = requestseqno;
    }

    public void setStatus(short status) {
        try {
            this.setSubmessageID(status);
        }
        catch (TTException tTException) {
            // empty catch block
        }
    }

    protected short _defaultID() {
        return 18;
    }

    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.requestseqno = Numbers.getUShort(this.buffer.getShort());
        this.setReasonCode(this.buffer.getShort());
        int textlen = this.buffer.getInt();
        if (textlen > this.buffer.remaining()) {
            textlen = this.buffer.remaining();
        }
        byte[] text = new byte[textlen];
        this.buffer.get(text);
        try {
            String msgtext = new String(text, "IBM1047");
            this.setMessages(msgtext.split("\u0000"));
            textlen = this.buffer.remaining();
            if (textlen > 0) {
                text = new byte[textlen];
                this.buffer.get(text);
                this.extraText = new String(text, "IBM1047").replace('\u0000', ' ');
                this.extraText = HexUtil.rightTrim(this.extraText);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.log(Level.INFO, "", e);
        }
    }

    protected int _getMessageSize() {
        int length = 8 + this.extraText.length();
        if (this.messages != null) {
            for (String string : this.messages) {
                length += string.length() + 1;
            }
        }
        return length;
    }

    protected String _toString() {
        return String.format(this.requestseqno == 0 ? STATUS_FORMAT_NOREQESTOR : STATUS_FORMAT, this.requestseqno, this.messages.size() > 0 ? this.messages.get(0) : "No message");
    }

    protected void buildMessage() throws Exception {
        int length = 0;
        for (String string : this.messages) {
            length += string.length() + 1;
        }
        this.buffer.putShort(Numbers.putUShort(this.requestseqno));
        this.buffer.putShort(this.reasonCode);
        this.buffer.putInt(length);
        for (String string : this.messages) {
            this.buffer.put(string.getBytes("IBM1047"));
            this.buffer.put((byte)0);
        }
        if (this.extraText.length() != 0) {
            this.buffer.put(this.extraText.getBytes("IBM1047"));
        }
    }

    public String getReasonText() {
        int index = this.reasonCode - 1000;
        return index < reasons.length ? reasons[index] : "";
    }
}

