/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.ui.wizards.DatasetWizardPage;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ProtsymDatasetWizardPage
extends DatasetWizardPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final Color White = null;
    private Button makeNdvrSym;
    private Button refreshLEasm;
    private ProtsymDataset currNdvrsym = null;
    private boolean ndvrLeasm = false;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.testingtools.help.adddataset";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.testingtools.help.updatedataset";
    private final TT_TreeItem datasetParent;
    private ArrayList<String> names = new ArrayList();

    public ProtsymDatasetWizardPage(Dataset dataset, TT_TreeItem datasetParent, boolean newItem, String title) {
        super(dataset, datasetParent, newItem, title);
        TT_TreeItem[] siblings;
        Object node;
        this.setDescription("Specify Protsym Dataset Details");
        this.newdataset = newItem;
        this.datasetParent = datasetParent;
        if (datasetParent != null && (node = datasetParent.getAdapter(ProfileNode.class)) instanceof ProfileNode) {
            this.canHaveblankDSN = ((ProfileNode)node).callHaveDefaultChild();
        }
        if (this.newdataset || dataset == null) {
            siblings = (TT_TreeItem[])datasetParent.getChildren();
            this.newdataset = true;
        } else {
            siblings = dataset.getParent().getSiblings();
        }
        TT_TreeItem[] tT_TreeItemArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem item = tT_TreeItemArray[n2];
            String name = item.getName().trim();
            this.names.add(name);
            if (name.isEmpty()) {
                this.canHaveblankDSN = false;
            }
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite top = (Composite)this.getControl();
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        data.horizontalSpan = 2;
        this.makeNdvrSym = new Button(two_col, 32);
        this.makeNdvrSym.setSelection(false);
        this.makeNdvrSym.setText("Use as Dynamic Symbolic Support repository for CA SCM");
        this.makeNdvrSym.setLayoutData((Object)data);
        this.makeNdvrSym.addSelectionListener((SelectionListener)this);
        this.makeNdvrSym.setBackground(White);
        this.makeNdvrSym.setEnabled(!this.makeNdvrSym.getSelection());
        this.refreshLEasm = new Button(two_col, 32);
        this.refreshLEasm.setSelection(false);
        this.refreshLEasm.setText("Always refresh non-LE enabled Assembler symbolics from CA SCM");
        this.refreshLEasm.setEnabled(!this.refreshLEasm.getSelection());
        this.refreshLEasm.addSelectionListener((SelectionListener)this);
        ArrayList protsyms = this.datasetParent.getAllChildren(ProtsymDataset.class);
        if (protsyms.size() != 0) {
            int ix = 0;
            while (ix < protsyms.size()) {
                ITreeWrappedItem obj = ((TT_TreeItem)protsyms.get(ix)).getValue();
                if (((ProtsymDataset)obj).isNdvrsym()) {
                    this.currNdvrsym = (ProtsymDataset)obj;
                }
                if (((ProtsymDataset)obj).isRefreshleasm()) {
                    this.ndvrLeasm = true;
                }
                ++ix;
            }
        }
        if (this.currNdvrsym == null) {
            this.refreshLEasm.setEnabled(false);
        } else {
            this.refreshLEasm.setSelection(this.ndvrLeasm);
        }
        if (this.currNdvrsym != null && this.dataset != null) {
            if (this.currNdvrsym != this.dataset) {
                this.makeNdvrSym.setSelection(true);
                this.makeNdvrSym.setEnabled(false);
                this.refreshLEasm.setEnabled(false);
                this.makeNdvrSym.setText(String.format("%s is the Dynamic Symbolic Support repository", new Object[]{this.currNdvrsym}));
            } else {
                this.makeNdvrSym.setSelection(((ProtsymDataset)this.dataset).isNdvrsym());
            }
        } else if (this.currNdvrsym != null) {
            this.makeNdvrSym.setSelection(true);
            this.makeNdvrSym.setEnabled(false);
            this.refreshLEasm.setEnabled(false);
            this.makeNdvrSym.setText(String.format("%s is the Dynamic Symbolic Support repository", new Object[]{this.currNdvrsym}));
        }
        if (this.newdataset) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.adddataset");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.updatedataset");
        }
    }

    public boolean doFinish() {
        super.doFinish();
        if (this.makeNdvrSym.getSelection() && this.currNdvrsym == null) {
            ((ProtsymDataset)this.dataset).setNdvrsym(true);
        }
        if (!this.makeNdvrSym.getSelection() && this.currNdvrsym != null) {
            ((ProtsymDataset)this.dataset).setNdvrsym(false);
            ((ProtsymDataset)this.dataset).setRefreshleasm(false);
        }
        if (this.refreshLEasm.getSelection()) {
            ((ProtsymDataset)this.dataset).setRefreshleasm(true);
        } else {
            ((ProtsymDataset)this.dataset).setRefreshleasm(false);
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.makeNdvrSym.getSelection()) {
            this.refreshLEasm.setEnabled(true);
            if (this.dataset != null) {
                this.setMessage(String.format("%s will be used as the Dynamic Symbolic Support repository for this profile", this.dataset));
            } else {
                this.setMessage("This protsym file will be used as the Dynamic Symbolic Support repository for this profile");
            }
        } else if (this.makeNdvrSym.isEnabled() && this.currNdvrsym == this.dataset) {
            this.refreshLEasm.setSelection(false);
            this.refreshLEasm.setEnabled(false);
        }
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }
}

