/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.handlers;

import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.protsym.Outline;
import com.ca.testingtools.protsym.handlers.AddtoWatchHandler;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.logging.Level;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddListingtoWatchHandler
extends AddtoWatchHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String msg;
        Shell shell;
        boolean procede;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof TextSelection)) {
            return this.beep();
        }
        TextSelection selector = (TextSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof ListerEditor)) {
            return this.beep();
        }
        ListerEditor lister = (ListerEditor)editor;
        String test = selector.getText();
        if (test == null) {
            return this.beep();
        }
        if ((test = test.trim()).isEmpty()) {
            return this.beep();
        }
        Outline outline = lister.getOutline();
        TreeObject[] names = outline.getQualifiedObjects(test);
        Variable variable = null;
        int count = 0;
        if (names.length == 1 && names[0] instanceof Variable) {
            variable = (Variable)names[0];
            ++count;
        } else {
            int line = selector.getStartLine() + 1;
            int statement = outline.getStatementNumber(line);
            TreeObject[] treeObjectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                TreeObject obj = treeObjectArray[n2];
                if (obj instanceof Variable && ((Variable)obj).getStatementNumber() == statement) {
                    variable = (Variable)obj;
                    ++count;
                }
                ++n2;
            }
        }
        if (count != 1) {
            return this.beep();
        }
        if (lister.getMemoryManager() == null && !(procede = MessageDialog.openQuestion((Shell)(shell = HandlerUtil.getActiveShell((ExecutionEvent)event)), (String)"Add Variable to Watch view", (String)(msg = String.format("There is no Memory access for this program\nDo you still want to add it to Watch view?", new Object[0]))))) {
            return null;
        }
        try {
            variable = this.cloneIt(variable, lister);
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPage page = window.getActivePage();
            IViewPart viewPart = page.showView("com.ca.testingtools.ui.views.watchdataview");
            if (viewPart instanceof WatchData) {
                WatchData viewer = (WatchData)viewPart;
                viewer.addContent(new IWatchData[]{variable});
                page.activate((IWorkbenchPart)viewPart);
                page.bringToTop((IWorkbenchPart)viewPart);
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                page.activate(part);
                return null;
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (CloneNotSupportedException e) {
            this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
        }
        return this.beep();
    }

    private Object beep() {
        try {
            Display.getCurrent().beep();
        }
        catch (Exception exception) {}
        return null;
    }
}

