/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.handlers;

import com.ca.testingtools.common.Statement;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddtoWatchHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof TreeSelection)) {
            return null;
        }
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof ListerEditor)) {
            return null;
        }
        ListerEditor lister = (ListerEditor)editor;
        TreeSelection sel = (TreeSelection)selection;
        ArrayList<Variable> list = new ArrayList<Variable>(sel.size());
        for (Object obj : sel) {
            if (!(obj instanceof Variable)) continue;
            Variable variable = (Variable)obj;
            try {
                Variable clone = this.cloneIt(variable, lister);
                if (clone == null) continue;
                list.add(clone);
            }
            catch (CloneNotSupportedException e) {
                this.log.log(Level.SEVERE, e.getClass().getSimpleName(), e);
            }
        }
        if (list.size() > 0) {
            String msg;
            Shell shell;
            boolean procede;
            if (lister.getMemoryManager() == null && !(procede = MessageDialog.openQuestion((Shell)(shell = HandlerUtil.getActiveShell((ExecutionEvent)event)), (String)"Add Variable to Watch view", (String)(msg = String.format("There is no Memory access for this program\nDo you still want to add it to Watch view?", new Object[0]))))) {
                return null;
            }
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IViewPart viewPart = page.showView("com.ca.testingtools.ui.views.watchdataview");
                if (viewPart instanceof WatchData) {
                    WatchData viewer = (WatchData)viewPart;
                    viewer.addContent(list.toArray(new IWatchData[list.size()]));
                }
                page.activate((IWorkbenchPart)viewPart);
                page.bringToTop((IWorkbenchPart)viewPart);
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                page.activate(part);
            }
            catch (PartInitException e) {
                this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return null;
    }

    protected Variable cloneIt(Variable variable, ListerEditor lister) throws CloneNotSupportedException {
        int stopStatement = 0;
        Statement statement = lister.getPositionStatement();
        if (statement != null) {
            stopStatement = statement.getStatement();
        }
        Variable clone = variable.cloneforWatch(stopStatement, lister.getMemoryManager(), lister.getName());
        String value = lister.getPartProperty("node_key");
        clone.setAttribute("node_key", value);
        return clone;
    }
}

