/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.ui.lister;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.common.Statement;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.scanASM;
import com.ca.testingtools.common.scanCOBOL;
import com.ca.testingtools.common.scanPLI;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.ResourceProperty;
import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.protsym.Decorator;
import com.ca.testingtools.protsym.Outline;
import com.ca.testingtools.protsym.ProtsymFile;
import com.ca.testingtools.protsym.ui.lister.ListerDocumentProvider;
import com.ca.testingtools.protsym.ui.lister.asm.AsmPartitioner;
import com.ca.testingtools.protsym.ui.lister.asm.AsmScanner;
import com.ca.testingtools.protsym.ui.lister.asm.AsmSourceViewerConfiguration;
import com.ca.testingtools.protsym.ui.lister.cobol.CobolPartitioner;
import com.ca.testingtools.protsym.ui.lister.cobol.CobolScanner;
import com.ca.testingtools.protsym.ui.lister.cobol.CobolSourceViewerConfiguration;
import com.ca.testingtools.protsym.ui.lister.pli.PLIPartitioner;
import com.ca.testingtools.protsym.ui.lister.pli.PLIScanner;
import com.ca.testingtools.protsym.ui.lister.pli.PLISourceViewerConfiguration;
import com.ca.testingtools.protsym.views.outline.OutlinePage;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ListerEditor
extends TextEditor
implements IShowInSource,
IDocumentListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String sourceClass = ListerEditor.class.getName();
    private Logger log = Logger.getLogger(sourceClass);
    private int lang;
    private Image image;
    private IDocumentProvider provider = new ListerDocumentProvider();
    private IMemoryManager memoryManager = null;
    private IDocument document;
    private boolean protsym = false;
    private IResource resource;
    private IScanSource scansource;
    private Outline outline;
    private ResourceProperty store;
    private int laststatement = 0;
    private Statement positionStatement = null;
    private Annotation currentIP = null;
    private ProtsymFile protsymFile;
    private String toolTip;
    private String positionText;
    private String name;
    private static final String CONTEXT_HELP_ID = "com.ca.testingtools.help.editorlister";
    public static final String ID = "com.ca.testingtools.protsym.lister";

    public ListerEditor() {
        this.setDocumentProvider(this.provider);
        this.doGetSelection();
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.resource = (IResource)input.getAdapter(IFile.class);
        if (this.resource instanceof IFile) {
            super.init(site, input);
            try {
                this.protsymFile = ProtsymFile.getInstance(this.resource);
                this.protsym = true;
                this.store = this.protsymFile.getStore();
                this.document = this.provider.getDocument((Object)input);
                String DSN = this.store.getString("dsn");
                this.name = this.store.getString("name");
                String time = this.store.getString("time");
                this.toolTip = String.format("%s(%s) %s", DSN, this.name, time);
            }
            catch (TTException e) {
                this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
                throw new PartInitException(HexUtil.getErrorText((Throwable)e, (boolean)false), (Throwable)e);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.setHelpContextId(CONTEXT_HELP_ID);
        this.setupEditor();
        super.createPartControl(parent);
        if (this.document != null) {
            this.document.addDocumentListener((IDocumentListener)this);
        }
        ISourceViewer viewer = this.getSourceViewer();
        viewer.setEditable(false);
    }

    public SourceViewerConfiguration getSourceConfiguration() {
        return this.getSourceViewerConfiguration();
    }

    private void createCobolPartControl() {
        IScanSource sc = this.getScansource();
        if (!(sc instanceof scanCOBOL)) {
            sc = new scanCOBOL(this.store.getString("gt_m_cty"));
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new CobolSourceViewerConfiguration(this.getPreferenceStore(), (scanCOBOL)sc, this.outline));
        CobolScanner scanner = new CobolScanner(sc);
        CobolPartitioner partitioner = new CobolPartitioner(scanner);
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 docExt3 = (IDocumentExtension3)this.document;
            IDocumentPartitioner oldpart = docExt3.getDocumentPartitioner("__source_code_partitioning");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__source_code_partitioning", (IDocumentPartitioner)partitioner);
            oldpart = docExt3.getDocumentPartitioner("__dflt_position_category");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__dflt_position_category", (IDocumentPartitioner)partitioner);
        } else {
            IDocumentPartitioner oldpart = this.document.getDocumentPartitioner();
            if (oldpart != null) {
                oldpart.disconnect();
            }
        }
        partitioner.connect(this.document, false, this);
    }

    private void createAsmPartControl() {
        IScanSource sa = this.getScansource();
        if (!(sa instanceof scanASM)) {
            sa = new scanASM(this.store.getString("gt_m_aty"));
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AsmSourceViewerConfiguration(this.getPreferenceStore(), (scanASM)sa, this.outline));
        AsmScanner scanner = new AsmScanner(sa);
        AsmPartitioner partitioner = new AsmPartitioner(scanner);
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 docExt3 = (IDocumentExtension3)this.document;
            IDocumentPartitioner oldpart = docExt3.getDocumentPartitioner("__source_code_partitioning");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__source_code_partitioning", (IDocumentPartitioner)partitioner);
            oldpart = docExt3.getDocumentPartitioner("__dflt_position_category");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__dflt_position_category", (IDocumentPartitioner)partitioner);
        } else {
            IDocumentPartitioner oldpart = this.document.getDocumentPartitioner();
            if (oldpart != null) {
                oldpart.disconnect();
            }
        }
        partitioner.connect(this.document, false, this);
    }

    private void createPLIPartControl() {
        IScanSource pa = this.getScansource();
        if (!(pa instanceof scanPLI)) {
            pa = new scanPLI(this.store.getString("gt_m_aty"));
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new PLISourceViewerConfiguration(this.getPreferenceStore(), (scanPLI)pa, this.outline));
        PLIScanner scanner = new PLIScanner(pa);
        PLIPartitioner partitioner = new PLIPartitioner(scanner);
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 docExt3 = (IDocumentExtension3)this.document;
            IDocumentPartitioner oldpart = docExt3.getDocumentPartitioner("__source_code_partitioning");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__source_code_partitioning", (IDocumentPartitioner)partitioner);
            oldpart = docExt3.getDocumentPartitioner("__dflt_position_category");
            if (oldpart != null) {
                oldpart.disconnect();
            }
            docExt3.setDocumentPartitioner("__dflt_position_category", (IDocumentPartitioner)partitioner);
        } else {
            IDocumentPartitioner oldpart = this.document.getDocumentPartitioner();
            if (oldpart != null) {
                oldpart.disconnect();
            }
        }
        partitioner.connect(this.document, false, this);
    }

    protected void createActions() {
        super.createActions();
        this.setAction("ShiftRight", null);
        this.setAction("ShiftLeft", null);
        this.setAction("QuickDiff.Toggle", null);
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.Accessibility"};
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    public boolean isOverwriteModeEnabled() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        IEditorInput input;
        if (adapter.equals(IContentOutlinePage.class) && (input = this.getEditorInput()) instanceof IFileEditorInput && this.protsym) {
            try {
                OutlinePage page = new OutlinePage(this.provider, this);
                page.setInput(input);
                return page;
            }
            catch (TTException tTException) {}
        }
        return super.getAdapter(adapter);
    }

    public IOverviewRuler getOverviewRuler() {
        return super.getOverviewRuler();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public IScanSource getScansource() {
        return this.scansource;
    }

    public TreeObject getTree() {
        return this.outline == null ? null : this.outline.getTree();
    }

    public void positionCursoratStatement(int stmtNumber, String reason) {
        Integer lineNumber = this.outline.getStatementXref().get(stmtNumber);
        if (lineNumber != null) {
            try {
                IRegion region = this.document.getLineInformation(lineNumber - 1);
                final int offset = region.getOffset();
                final int length = region.getLength();
                final IAnnotationModel am = this.provider.getAnnotationModel((Object)this.getEditorInput());
                Position pos = null;
                if (am != null) {
                    pos = am.getPosition(this.currentIP);
                }
                final Annotation oldIP = pos != null ? this.currentIP : null;
                final Position position = new Position(offset, length);
                this.currentIP = new Annotation("com.ca.testingtools.lister.pointer", false, reason);
                Display display = Display.getDefault();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListerEditor.this.selectAndReveal(offset, length);
                            if (oldIP != null) {
                                am.removeAnnotation(oldIP);
                            }
                            if (am != null) {
                                am.addAnnotation(ListerEditor.this.currentIP, position);
                            }
                        }
                    });
                }
            }
            catch (BadLocationException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
    }

    public ShowInContext getShowInContext() {
        ShowInContext context = new ShowInContext((Object)this.protsymFile, null);
        return context;
    }

    protected void setTitleImage(Image titleImage) {
        if (this.resource != null && (this.image == null || this.image.isDisposed())) {
            this.image = new Decorator().decorateImage(titleImage, this.resource);
        }
        if (this.image != null) {
            super.setTitleImage(this.image);
        } else {
            super.setTitleImage(titleImage);
        }
    }

    public ResourceProperty getStore() {
        return this.store;
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("textDragAndDropEnabled", false);
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
        IWorkbenchPage page = this.getSite().getPage();
        IViewPart viewPart = page.findView("com.ca.testingtools.ui.views.watchdataview");
        if (viewPart instanceof WatchData && this.protsymFile != null) {
            WatchData view = (WatchData)viewPart;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, WatchData.watchID, (Object)this.protsymFile.hashCode(), null);
            view.propertyChange(event);
        }
    }

    private void setupEditor() {
        String name = this.resource.getName();
        this.image = null;
        if (this.protsymFile != null) {
            Decorator dec = new Decorator();
            name = dec.decorateText("", this.resource);
            this.image = dec.decorateImage(null, this.resource);
            this.lang = this.store.getHex("gt_m_lang");
            this.scansource = this.protsymFile.getScansource();
            this.laststatement = this.store.getInt("laststatement");
            if (this.laststatement == 0) {
                this.laststatement = this.store.getInt("records");
            }
            try {
                this.outline = Outline.getInstance(this.protsymFile);
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
            switch (this.lang) {
                case 32: {
                    this.createCobolPartControl();
                    break;
                }
                case 16: {
                    this.createAsmPartControl();
                    break;
                }
                case 128: {
                    this.createPLIPartControl();
                }
            }
        }
        this.setPartName(name);
        this.setTitleImage(this.image);
    }

    protected void handleEditorInputChanged() {
        this.setupEditor();
        super.handleEditorInputChanged();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.setupEditor();
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getTitleToolTip() {
        return this.toolTip;
    }

    public void PositionPoint(int offSet, String text) {
        Statement statement = this.outline.getStmtTree().hasOffset(offSet, null);
        if (statement != null) {
            this.positionText = text;
            this.positionStatement = statement;
        }
        this.positionStatement(this.positionStatement, null);
    }

    public void positionStatement(Statement statement, String text) {
        if (statement != null) {
            this.positionStatement(statement.getStatement(), text);
        }
    }

    public void positionStatement(int stmtNumber, String text) {
        String message = text == null ? this.positionText : text;
        Integer lineNumber = this.outline.getStatementXref().get(stmtNumber);
        if (lineNumber != null) {
            try {
                IRegion region = this.document.getLineInformation(lineNumber - 1);
                final int offset = region.getOffset();
                final int length = region.getLength();
                final IAnnotationModel am = this.provider.getAnnotationModel((Object)this.getEditorInput());
                Position pos = null;
                if (am != null) {
                    pos = am.getPosition(this.currentIP);
                }
                final Annotation oldIP = pos != null ? this.currentIP : null;
                final Position position = new Position(offset, length);
                this.currentIP = new Annotation("com.ca.testingtools.lister.pointer", false, message);
                Display display = Display.getDefault();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListerEditor.this.selectAndReveal(offset, length);
                            if (oldIP != null) {
                                am.removeAnnotation(oldIP);
                            }
                            if (am != null) {
                                am.addAnnotation(ListerEditor.this.currentIP, position);
                            }
                        }
                    });
                }
            }
            catch (BadLocationException e) {
                this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
    }

    public IWorkbenchPartSite getSite() {
        return super.getSite();
    }

    public IEditorInput getEditorInput() {
        return super.getEditorInput();
    }

    public IMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(IMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public Statement getPositionStatement() {
        return this.positionStatement;
    }

    public Outline getOutline() {
        return this.outline;
    }

    public String getName() {
        return this.name;
    }
}

