/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.ui.lister.cobol;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class CobolDoubleClickStrategy
implements ITextDoubleClickStrategy {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String sourceClass = CobolDoubleClickStrategy.class.getName();
    private Logger log = Logger.getLogger(sourceClass);
    private ITextViewer tviewer;
    private IDocument doc;
    private IRegion line;
    private int selection;
    private int start;
    private int end;

    public void doubleClicked(ITextViewer viewer) {
        this.tviewer = viewer;
        this.doc = this.tviewer.getDocument();
        this.selection = this.tviewer.getSelectedRange().x;
        try {
            this.line = this.doc.getLineInformationOfOffset(this.selection);
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        if (this.selection < 0) {
            return;
        }
        this.selectText();
    }

    protected boolean findText() {
        int position = this.selection;
        char dash = '-';
        try {
            char c;
            while (position >= 0) {
                c = this.doc.getChar(position);
                if (!Character.isLetterOrDigit(c) && c != dash) break;
                --position;
            }
            this.start = position;
            position = this.selection;
            int length = this.line.getOffset() + this.line.getLength();
            while (position < length) {
                c = this.doc.getChar(position);
                if (!Character.isLetterOrDigit(c) && c != dash) break;
                ++position;
            }
            this.end = position;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void selectText() {
        if (this.findText()) {
            if (this.start == this.end) {
                this.tviewer.setSelectedRange(this.start, 0);
            } else {
                this.tviewer.setSelectedRange(this.start + 1, this.end - this.start - 1);
            }
        }
    }
}

