/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.core.IConstants;
import com.ca.testingtools.core.ResourceProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MRUList {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String sourceClass = MRUList.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    private ScopedPreferenceStore store = null;
    private int max_MRU;
    private String name;
    private ArrayList<String> MRU_List;
    private static final String MRU_LIST = "MRUList";
    private ResourceProperty resourcestore = null;

    public MRUList(String MRU_Name) {
        String list;
        this.name = String.valueOf(MRU_Name) + ".";
        this.store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.testingtools");
        this.max_MRU = this.store.getInt(String.valueOf(this.name) + "MAX_MRU");
        if (this.max_MRU < 1) {
            this.max_MRU = this.store.getInt("MAX_MRU");
            this.store.setValue(String.valueOf(this.name) + "MAX_MRU", this.max_MRU);
        }
        if ((list = this.store.getString(String.valueOf(this.name) + MRU_LIST)).length() > 0) {
            String[] entries = list.split(";");
            this.MRU_List = new ArrayList(entries.length);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.length() > 0) {
                    this.MRU_List.add(item);
                }
                ++n2;
            }
        } else {
            int count = this.store.getInt(String.valueOf(this.name) + "mru_count");
            this.store.setToDefault(String.valueOf(this.name) + "mru_count");
            this.MRU_List = new ArrayList(count);
            int i = 0;
            while (i < count) {
                String key = String.format("%s%s%d", this.name, IConstants.MRU_ITEM, i);
                String item = this.store.getString(key);
                this.store.setToDefault(key);
                if (item.length() > 0) {
                    this.MRU_List.add(item);
                }
                ++i;
            }
            this.save();
        }
    }

    public MRUList(String MRU_Name, IResource resource) {
        String list;
        this.name = String.valueOf(MRU_Name) + ".";
        this.resourcestore = ResourceProperty.getInstance(resource);
        this.max_MRU = this.resourcestore.getInt(String.valueOf(this.name) + "MAX_MRU");
        if (this.max_MRU < 1) {
            this.max_MRU = this.resourcestore.getInt("MAX_MRU");
        }
        if ((list = this.resourcestore.getString(String.valueOf(this.name) + MRU_LIST)).length() > 0) {
            String[] entries = list.split(";");
            this.MRU_List = new ArrayList(entries.length);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.length() > 0) {
                    this.MRU_List.add(item);
                }
                ++n2;
            }
        } else {
            int count = this.resourcestore.getInt(String.valueOf(this.name) + "mru_count");
            this.resourcestore.setToDefault(String.valueOf(this.name) + "mru_count");
            this.MRU_List = new ArrayList(count);
            int i = 0;
            while (i < count) {
                String key = String.format("%s%s%d", this.name, IConstants.MRU_ITEM, i);
                String item = this.resourcestore.getString(key);
                this.resourcestore.setToDefault(key);
                if (item.length() > 0) {
                    this.MRU_List.add(item);
                }
                ++i;
            }
            this.save();
        }
    }

    private void remove(String name) {
        this.MRU_List.remove(name);
    }

    public String[] GetNames() {
        return this.MRU_List.toArray(new String[0]);
    }

    public void clear() {
        this.MRU_List.clear();
        this.save();
    }

    private void remove(int index) {
        this.MRU_List.remove(index);
    }

    private void reSize() {
        while (this.MRU_List.size() > this.max_MRU) {
            this.remove(this.MRU_List.size() - 1);
        }
    }

    public void add(String name) {
        this.remove(name);
        this.MRU_List.add(0, name);
        this.save();
    }

    private void save() {
        this.reSize();
        StringBuilder savelist = new StringBuilder();
        int i = 0;
        while (i < this.MRU_List.size()) {
            savelist.append(this.MRU_List.get(i));
            savelist.append(';');
            ++i;
        }
        this.store.putValue(String.valueOf(this.name) + MRU_LIST, savelist.toString());
        try {
            this.store.save();
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
        }
    }

    public String toString() {
        if (this.name == null || this.MRU_List == null) {
            return super.toString();
        }
        return String.format("%s %s", this.name, this.MRU_List.toString());
    }
}

