/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.handlers;

import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.core.ValidateCredentials;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;

public class SendContentHandler
extends AbstractHandler
implements IElementUpdater {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private HashMap<String, ArrayList<NodeChild>> targets;
    private ArrayList<Dataset> datasets = new ArrayList();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object result;
        Object item;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection.isEmpty()) {
            return null;
        }
        List elements = selection.toList();
        this.targets = new HashMap();
        this.datasets.clear();
        int size = elements.size();
        int index = 0;
        if (size == 1 && (item = elements.get(0)) instanceof TT_TreeItem && (result = ((TT_TreeItem)item).getAdapter(NodeChild.class)) != null) {
            ++index;
            this.buildTargets((TT_TreeItem)item, true);
        }
        while (index < size) {
            Object element = elements.get(index);
            this.buildTargets((TT_TreeItem)element, false);
            ++index;
        }
        TTServer server = ((TT_TreeItem)elements.get(0)).getServer();
        try {
            server.getLogonUser();
        }
        catch (TTException tTException) {
            return Status.CANCEL_STATUS;
        }
        ValidateCredentials validate = new ValidateCredentials(server, this.datasets.toArray(new Dataset[this.datasets.size()]));
        int result2 = validate.run(false);
        if (result2 != 0) {
            ArrayList<Element> errors = validate.getErrorElements();
            if (errors.size() == 0) {
                TT_ErrorDialog.openError(null, "Error attempting to validate datasets", validate.getErrorMessage());
            } else {
                for (Element element : errors) {
                    if (!element.getTagName().equals("DSN")) continue;
                    String dsn = element.getAttribute("name");
                    String message = String.format("Error %s %s\n%s", element.getAttribute("errorlevel"), element.getAttribute("msg"), dsn);
                    TT_ErrorDialog.openError(null, "Dataset Error", message, new Throwable("Dataset name mispelled\nDataset not defined\nDataset Deleted"));
                }
            }
            return null;
        }
        for (Map.Entry<String, ArrayList<NodeChild>> set : this.targets.entrySet()) {
            ShowViewJob job = new ShowViewJob(set.getKey(), set.getValue());
            job.schedule();
        }
        return null;
    }

    private void buildTargets(TT_TreeItem result, boolean force) {
        ArrayList<TT_TreeItem> nodeChildren = result.getAllChildren(NodeChild.class);
        for (TT_TreeItem item : nodeChildren) {
            List nodes;
            Element element;
            String view;
            TT_TreeItem profileNode;
            Dataset dataset;
            if (!force && !item.isChecked()) continue;
            NodeChild node = (NodeChild)item.getAdapter(NodeChild.class);
            if (node instanceof Dataset && !this.datasets.contains(dataset = (Dataset)node)) {
                this.datasets.add((Dataset)node);
            }
            if ((profileNode = item.getParent(ProfileNode.class)) == null || (view = (element = profileNode.getElement()).getAttribute("viewtarget")) == null) continue;
            if (!this.targets.containsKey(view)) {
                this.targets.put(view, new ArrayList());
            }
            if ((nodes = (List)this.targets.get(view)).contains(node)) continue;
            nodes.add(node);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    public class ShowViewJob
    extends UIJob {
        private String key;
        private ArrayList<NodeChild> value;

        public ShowViewJob(String name, ArrayList<NodeChild> value) {
            super(name);
            this.key = name;
            this.value = value;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IViewPart viewPart = page.showView(this.key);
                if (viewPart instanceof IProfileSetContent) {
                    IProfileSetContent viewer = (IProfileSetContent)viewPart;
                    viewer.setContent(this.value.toArray(new NodeChild[this.value.size()]), true);
                }
            }
            catch (PartInitException partInitException) {}
            return new Status(0, "com.ca.testingtools", 0, "done", null);
        }
    }
}

