/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.wizards;

import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.views.profile.ProfileView;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class ProfileWizardPage
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Profile profile;
    private TTServer server;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.testingtools.help.ProfileWizardPageNew";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.testingtools.help.ProfileWizardPageOld";
    private boolean newprofile = true;
    private Text name;
    private boolean changed = false;
    private ServerTreeModel model = ServerTreeModel.getInstance();
    private ArrayList<String> names = new ArrayList();

    public ProfileWizardPage(Profile profile, TTServer server, boolean newItem, String title) {
        super(profile == null ? "New Profile" : profile.getName(), title, null);
        this.setDescription("Specify Profile Details");
        this.newprofile = newItem;
        this.profile = newItem ? null : profile;
        this.server = server;
        TT_TreeItem[] siblings = this.newprofile || this.profile == null ? (TT_TreeItem[])server.getParent().getChildren() : profile.getParent().getSiblings();
        TT_TreeItem[] tT_TreeItemArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem item = tT_TreeItemArray[n2];
            this.names.add(item.getName());
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(two_col, 0);
        label.setText("Name");
        label.setAlignment(131072);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        label.setLayoutData((Object)data);
        this.name = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener((ModifyListener)this);
        if (this.newprofile) {
            this.name.setText("");
        } else {
            this.name.setText(this.profile.getName());
        }
        TextUtil.setWidth(this.name, 30);
        if (this.newprofile) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.ProfileWizardPageNew");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.ProfileWizardPageOld");
        }
        this.setControl((Control)top);
    }

    public void modifyText(ModifyEvent e) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        String profname = this.name.getText().trim();
        if (profname.length() == 0) {
            this.setErrorMessage("Missing Name");
            return false;
        }
        if (this.names.contains(profname)) {
            this.setErrorMessage("Duplicate name");
            return false;
        }
        this.setErrorMessage(null);
        return this.changed;
    }

    public boolean doFinish() {
        CheckboxTreeViewer viewer;
        Element profileElement = null;
        String profileName = this.name.getText().trim();
        if (this.newprofile) {
            TT_TreeItem treeItem = this.model.findObject(this.server);
            Element element = this.server.getElement();
            profileElement = this.model.addProfile(element, profileName);
            TT_TreeItem profileItem = this.model.insertProfile(treeItem, profileElement);
            this.profile = (Profile)profileItem.getValue();
        } else {
            this.profile.setName(profileName);
        }
        this.model.save();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        IWorkbenchPage page = window.getActivePage();
        IViewPart view = page.findView("com.ca.testingtools.ui.views.profileview");
        if (view instanceof ProfileView && (viewer = ((ProfileView)view).getViewer()) != null) {
            TT_TreeItem selection = this.model.findObject(this.profile);
            TT_TreeItem parent = selection.getParent();
            viewer.refresh((Object)parent, true);
            viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
        return true;
    }
}

