/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.IConditionalBreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ConditionalBreakpointMessage
extends BreakpointMessage
implements IConditionalBreakpointMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected short ID = 0;
    protected String leftOffset = "";
    protected int leftLenOvrd = 0;
    protected byte leftType = 0;
    protected int leftValueLen = 0;
    protected String leftVar = "";
    protected byte operator = 0;
    protected String rightOffset = "";
    protected int rightLenOvrd = 0;
    protected byte rightType = 0;
    protected int rightValueLen = 0;
    protected String rightVar = "";
    protected boolean dropMonitor = false;

    public ConditionalBreakpointMessage() {
        super(true);
    }

    @Override
    public String getLeftOffset() {
        return this.leftOffset;
    }

    @Override
    public int getLeftLenOvrd() {
        return this.leftLenOvrd;
    }

    @Override
    public byte getLeftType() {
        return this.leftType;
    }

    @Override
    public int getLeftValueLen() {
        return this.leftValueLen;
    }

    @Override
    public String getLeftVar() {
        return this.leftVar;
    }

    @Override
    public byte getOperator() {
        return this.operator;
    }

    @Override
    public String getRightOffset() {
        return this.rightOffset;
    }

    @Override
    public int getRightLenOvrd() {
        return this.rightLenOvrd;
    }

    @Override
    public byte getRightType() {
        return this.rightType;
    }

    @Override
    public int getRightValuelen() {
        return this.rightValueLen;
    }

    @Override
    public String getRightVar() {
        return this.rightVar.trim();
    }

    @Override
    public void setLeftOffset(Object leftOffset) {
        if (leftOffset == null) {
            return;
        }
        this.setLeftOffset(leftOffset.toString());
    }

    @Override
    public void setLeftOffset(String leftOffset) {
        this.leftOffset = leftOffset;
    }

    @Override
    public void setLeftLenOvrd(int leftLenOvrd) {
        this.leftLenOvrd = leftLenOvrd;
    }

    @Override
    public void setLeftLenOvrd(Object leftLenOvrd) {
        if (leftLenOvrd == null) {
            return;
        }
        if (leftLenOvrd instanceof Number) {
            this.setLeftLenOvrd(((Number)leftLenOvrd).intValue());
        } else {
            try {
                this.setLeftLenOvrd(Integer.parseInt(leftLenOvrd.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setLeftType(byte leftType) {
        this.leftType = leftType;
    }

    @Override
    public void setLeftType(Object leftType) {
        if (leftType == null) {
            return;
        }
        if (leftType instanceof Number) {
            this.setLeftType(((Number)leftType).byteValue());
        } else {
            try {
                this.setLeftType(Byte.parseByte(leftType.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setLeftValueLen(int leftValueLen) {
        this.leftValueLen = leftValueLen;
    }

    @Override
    public void setLeftValueLen(Object leftValueLen) {
        if (leftValueLen == null) {
            return;
        }
        if (leftValueLen instanceof Number) {
            this.setLeftValueLen(((Number)leftValueLen).intValue());
        } else {
            try {
                this.setLeftValueLen(Integer.parseInt(leftValueLen.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setLeftVar(Object leftVar) {
        if (leftVar == null) {
            return;
        }
        this.setLeftVar(leftVar.toString());
    }

    @Override
    public void setLeftVar(String leftVar) {
        this.leftVar = leftVar.trim();
    }

    @Override
    public void setOperator(byte operator) {
        this.operator = operator;
    }

    @Override
    public void setOperator(Object operator) {
        if (operator == null) {
            return;
        }
        if (operator instanceof Number) {
            this.setOperator(((Number)operator).byteValue());
        } else {
            try {
                this.setOperator(Byte.parseByte(operator.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setRightOffset(Object rightOffset) {
        if (rightOffset == null) {
            return;
        }
        this.setRightOffset(rightOffset.toString());
    }

    @Override
    public void setRightOffset(String rightOffset) {
        this.rightOffset = rightOffset;
    }

    @Override
    public void setRightLenOvrd(int rightLenOvrd) {
        this.rightLenOvrd = rightLenOvrd;
    }

    @Override
    public void setRightLenOvrd(Object rightLenOvrd) {
        if (rightLenOvrd == null) {
            return;
        }
        if (rightLenOvrd instanceof Number) {
            this.setRightLenOvrd(((Number)rightLenOvrd).intValue());
        } else {
            try {
                this.setRightLenOvrd(Integer.parseInt(rightLenOvrd.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setRightType(byte rightType) {
        this.rightType = rightType;
    }

    @Override
    public void setRightType(Object rightType) {
        if (rightType == null) {
            return;
        }
        if (rightType instanceof Number) {
            this.setRightType(((Number)rightType).byteValue());
        } else {
            try {
                this.setRightType(Byte.parseByte(rightType.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setRightValuelen(int rightValueLen) {
        this.rightValueLen = rightValueLen;
    }

    @Override
    public void setRightValuelen(Object rightValueLen) {
        if (rightValueLen == null) {
            return;
        }
        if (rightValueLen instanceof Number) {
            this.setRightValuelen(((Number)rightValueLen).intValue());
        } else {
            try {
                this.setRightValuelen(Integer.parseInt(rightValueLen.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setRightVar(Object rightVar) {
        if (rightVar == null) {
            return;
        }
        this.setRightVar(rightVar.toString());
    }

    @Override
    public void setRightVar(String rightVar) {
        this.rightVar = rightVar.trim();
    }

    @Override
    protected void buildSubBPMessage() throws ITException, UnsupportedEncodingException {
        if (this.isCICS) {
            this.buildCICSSubBPMessage();
        }
        this.buffer.putShort(Numbers.putUShort(this.skipcount));
        this.buffer.putInt(this.statement);
        this.buffer.put(this.flag1);
        this.buffer.putShort((short)this.leftVar.length());
        if (this.leftValueLen < 0) {
            this.leftValueLen = 0;
        }
        this.buffer.putInt(this.leftValueLen);
        if (this.leftType < 1) {
            Logger.loggit(new ITException("Invalid left side type"));
        }
        this.buffer.put(this.leftType);
        this.checkRightVar();
        this.buffer.putShort((short)this.rightVar.length());
        if (this.rightValueLen < 0) {
            this.rightValueLen = 0;
        }
        this.buffer.putInt(this.rightValueLen);
        this.buffer.put(this.rightType);
        this.buffer.put(this.operator);
        this.buffer.put((String.valueOf(this.leftVar) + this.rightVar).getBytes("IBM1047"));
    }

    @Override
    protected short _defaultID() {
        return 2;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        int NlenLeft = 0;
        int NlenRight = 0;
        try {
            this.getProgram(this.buffer);
            this.getAvailable(this.buffer);
            this.breakpointID = this.buffer.getLong();
            this.skipcount = Numbers.getUShort(this.buffer.getShort());
            this.statement = this.buffer.getInt();
            this.flag1 = this.buffer.get();
            NlenLeft = Numbers.getUShort(this.buffer.getShort());
            this.leftValueLen = this.buffer.getInt();
            this.leftType = this.buffer.get();
            this.leftOffset = "";
            NlenRight = Numbers.getUShort(this.buffer.getShort());
            this.rightValueLen = this.buffer.getInt();
            this.rightType = this.buffer.get();
            this.rightOffset = "";
            this.operator = this.buffer.get();
            byte[] bytes = new byte[NlenLeft];
            this.buffer.get(bytes);
            this.leftVar = new String(bytes, "IBM1047");
            bytes = new byte[NlenRight];
            this.buffer.get(bytes);
            this.rightVar = new String(bytes, "IBM1047");
        }
        catch (BufferUnderflowException e) {
            Logger.loggit(e);
            throw new ITException("Invalid message for BreakPoint message ", e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
            throw new ITException(e.getCause());
        }
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 2: 
            case 4: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException("Invalid Conditional breakpoint");
            }
        }
    }

    @Override
    protected String _toString() {
        return super._toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.leftOffset == null ? 0 : this.leftOffset.hashCode());
        result = 31 * result + this.leftValueLen;
        result = 31 * result + this.leftLenOvrd;
        result = 31 * result + (this.leftVar == null ? 0 : this.leftVar.hashCode());
        result = 31 * result + (this.rightOffset == null ? 0 : this.rightOffset.hashCode());
        result = 31 * result + this.rightValueLen;
        result = 31 * result + this.rightLenOvrd;
        result = 31 * result + (this.rightVar == null ? 0 : this.rightVar.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IConditionalBreakpointMessage)) {
            return false;
        }
        IConditionalBreakpointMessage other = (IConditionalBreakpointMessage)obj;
        if (this.getSubmessageID() == 4 && other.getSubmessageID() == 4) {
            other.setStatement(0);
            this.setStatement(0);
        }
        if (this.leftOffset == null ? other.getLeftOffset() != null : !this.leftOffset.equals(other.getLeftOffset())) {
            return false;
        }
        if (this.leftType != other.getLeftType()) {
            return false;
        }
        if (this.leftValueLen != other.getLeftValueLen()) {
            return false;
        }
        if (this.leftLenOvrd != other.getLeftLenOvrd()) {
            return false;
        }
        if (this.leftVar == null ? other.getLeftVar() != null : !this.leftVar.equals(other.getLeftVar())) {
            return false;
        }
        if (this.operator != other.getOperator()) {
            return false;
        }
        if (this.rightOffset == null ? other.getRightOffset() != null : !this.rightOffset.equals(other.getRightOffset())) {
            return false;
        }
        if (this.rightType != other.getRightType()) {
            return false;
        }
        if (this.rightValueLen != other.getRightValuelen()) {
            return false;
        }
        if (this.rightLenOvrd != other.getRightLenOvrd()) {
            return false;
        }
        if (this.rightVar == null ? other.getRightVar() != null : !this.rightVar.equals(other.getRightVar())) {
            return false;
        }
        if (this.dropMonitor != other.getDropMonitor()) {
            return false;
        }
        return super.equals(obj);
    }

    protected void checkRightVar() {
        String test = this.rightVar;
        boolean isLiteral = test.contains("'");
        if (isLiteral) {
            String[] types = new String[]{"C'", "X'", "P'", "H'", "F'"};
            int i = 0;
            while (i < types.length) {
                if (test.substring(0, 2).equals(types[i].substring(0, 2))) {
                    String[] split = test.split("'");
                    this.rightVar = split[1];
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    protected void fillOffsets(ByteBuffer buffer, String offset) {
        int count = 0;
        int fill = Integer.decode("0x0");
        byte[] workarea = new byte[20];
        ByteBuffer buf = ByteBuffer.wrap(workarea);
        while (count < 5) {
            buf.putInt(fill);
            ++count;
        }
        buffer.put(workarea);
    }

    protected void buildCICSSubBPMessage() {
        if (this.leftType == 1) {
            this.leftVar = "'" + this.leftVar + "'";
        }
        if (this.rightType == 1) {
            this.rightVar = "'" + this.rightVar + "'";
        }
        if (this.leftLenOvrd > 0) {
            this.leftValueLen = this.leftLenOvrd;
        }
        if (this.rightLenOvrd > 0) {
            this.rightValueLen = this.rightLenOvrd;
        }
        if (this.leftOffset != null && this.leftOffset.length() > 0) {
            this.leftVar = String.valueOf(this.leftVar) + this.leftOffset;
        }
        if (this.rightOffset != null && this.rightOffset.length() > 0) {
            this.rightVar = String.valueOf(this.rightVar) + this.rightOffset;
        }
        if (this.dropMonitor) {
            this.flag1 = (byte)2;
        }
    }

    @Override
    public boolean getDropMonitor() {
        return this.dropMonitor;
    }

    @Override
    public void setDropMonitor(boolean dropMonitor) {
        this.dropMonitor = dropMonitor;
    }

    @Override
    public void setDropMonitor(Object dropMonitor) {
        if (dropMonitor == null) {
            return;
        }
        if (dropMonitor instanceof Boolean) {
            this.setDropMonitor((Boolean)dropMonitor);
        } else {
            this.setDropMonitor(Boolean.parseBoolean(dropMonitor.toString()));
        }
    }

    @Override
    public void setSkipcount(int skipcount) {
    }
}

