/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class DataRequestMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final short CORECMD = 1;
    public static final short BASEOFF = 2;
    public static final short VARNAME = 3;
    public static final short CHANNEL = 4;
    public static final short STORAGE = 5;
    public static final short NEWCOPY = 6;
    protected String varname = "";
    protected String coreCmd = "";
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected int offset = 0;
    protected int dataLength = 0;
    protected int stmt = 0;

    public DataRequestMessage() {
    }

    public DataRequestMessage(short submessageID) throws ITException {
        this();
        this.setSubmessageID(submessageID);
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.putInt(this.dataLength);
        switch (this.submessageID) {
            case 1: {
                this.buffer.put(this.putProgram());
                this.buffer.putShort((short)this.coreCmd.length());
                this.buffer.put(this.coreCmd.getBytes("IBM1047"));
                break;
            }
            case 2: {
                this.buffer.put(this.address.toByteArray());
                this.buffer.putInt(this.offset);
                break;
            }
            case 3: {
                this.buffer.put(this.putProgram());
                this.buffer.putInt(this.stmt);
                this.buffer.putShort((short)this.varname.length());
                this.buffer.put(this.varname.getBytes("IBM1047"));
                break;
            }
            case 4: {
                this.buffer.put(this.putProgram());
                this.buffer.putShort((short)this.coreCmd.length());
                this.buffer.put(this.coreCmd.getBytes("IBM1047"));
                break;
            }
            case 5: {
                this.buffer.put(this.putProgram());
                this.buffer.putShort((short)this.coreCmd.length());
                this.buffer.put(this.coreCmd.getBytes("IBM1047"));
                break;
            }
            case 6: {
                this.buffer.put(this.putProgram());
                this.buffer.putShort((short)this.coreCmd.length());
                this.buffer.put(this.coreCmd.getBytes("IBM1047"));
                break;
            }
            default: {
                throw new ITException("Invalid data request type");
            }
        }
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] buf = new byte[8];
        this.dataLength = this.buffer.getInt();
        switch (this.submessageID) {
            case 1: {
                this.getProgram(newbuffer);
                int len = Numbers.getUShort(this.buffer.getShort());
                buf = new byte[len];
                this.buffer.get(buf);
                this.coreCmd = HexUtil.rightTrim(new String(buf, "IBM1047"));
                break;
            }
            case 2: {
                this.address = new MFAddress(this.buffer);
                this.offset = this.buffer.getInt();
                break;
            }
            case 3: {
                this.getProgram(newbuffer);
                this.stmt = this.buffer.getInt();
                int len = Numbers.getUShort(this.buffer.getShort());
                buf = new byte[len];
                this.buffer.get(buf);
                this.varname = HexUtil.rightTrim(new String(buf, "IBM1047"));
                break;
            }
            case 4: {
                this.getProgram(newbuffer);
                int len = Numbers.getUShort(this.buffer.getShort());
                buf = new byte[len];
                this.buffer.get(buf);
                this.coreCmd = HexUtil.rightTrim(new String(buf, "IBM1047"));
                break;
            }
            case 5: {
                this.getProgram(newbuffer);
                int len = Numbers.getUShort(this.buffer.getShort());
                buf = new byte[len];
                this.buffer.get(buf);
                this.coreCmd = HexUtil.rightTrim(new String(buf, "IBM1047"));
                break;
            }
            case 6: {
                this.getProgram(newbuffer);
                int len = Numbers.getUShort(this.buffer.getShort());
                buf = new byte[len];
                this.buffer.get(buf);
                this.coreCmd = HexUtil.rightTrim(new String(buf, "IBM1047"));
                break;
            }
            default: {
                throw new ITException(String.valueOf(this.getSubmessageID()) + " is not a data request SubmessageID");
            }
        }
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public void setOffset(int offSet) {
        this.offset = offSet;
    }

    public void setAlet(long aletval) {
        this.address.setAlet(aletval);
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void setStmt(int st) {
        this.stmt = st;
    }

    public void setCoreCmd(String cmd) {
        this.coreCmd = cmd;
    }

    public void setVarName(String var) {
        this.varname = var;
    }

    @Override
    protected short _defaultID() {
        return 6;
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException("Invalid core request type");
            }
        }
    }

    @Override
    protected int _getMessageSize() {
        return 500;
    }

    @Override
    protected String _toString() {
        return null;
    }
}

