/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.FileName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class FileNameExtended
extends FileName {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    byte trimAction = 0;
    private static final byte TRIM = 1;
    private static final byte ASA = 2;
    byte disposal = 0;
    private static final byte DELETE = 1;
    private InputStream inputstream;
    private OutputStream outputstream;
    private boolean inVariable;
    private boolean outVariable;
    short RecLength = 0;
    public static final short CR_RECORD = 0;
    public static final short STREAM = -1;
    private long filesize = 0L;

    public FileNameExtended(ByteBuffer buffer) {
        super(buffer);
        this.RecLength = buffer.getShort();
        this.trimAction = buffer.get();
        this.disposal = buffer.get();
        this.filesize = buffer.getLong();
    }

    public FileNameExtended(FileName filename) {
        super(filename.getFiletype(), filename.getDSN());
    }

    public FileNameExtended(Map<String, Object> map) {
        super(map);
        Object value = map.get("reclength");
        if (value instanceof Number) {
            this.setRecLength(((Number)value).shortValue());
        } else if (value instanceof String) {
            this.setRecLength(Short.parseShort((String)value));
        }
        value = map.get("asa");
        this.setASA(Boolean.parseBoolean((String)value));
        value = map.get("cr");
        this.setCR(Boolean.parseBoolean((String)value));
        value = map.get("stream");
        this.setStream(Boolean.parseBoolean((String)value));
        value = map.get("trim");
        this.setTrim(Boolean.parseBoolean((String)value));
        value = map.get("invariable");
        this.setInVariable(Boolean.parseBoolean((String)value));
        value = map.get("outvariable");
        this.setOutVariable(Boolean.parseBoolean((String)value));
    }

    @Override
    public ByteBuffer getBuffer() {
        ByteBuffer buff = ByteBuffer.allocate(this.getSize());
        buff.put(super.getBuffer());
        buff.putShort(this.RecLength);
        buff.put(this.trimAction);
        buff.put(this.disposal);
        buff.putLong(this.filesize);
        return (ByteBuffer)buff.position(0);
    }

    @Override
    public int getSize() {
        return super.getSize() + 12;
    }

    public boolean isDelete() {
        return (this.disposal & 1) != 0;
    }

    public void close() {
        if (this.inputstream != null) {
            try {
                this.inputstream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.outputstream != null) {
            try {
                this.outputstream.close();
            }
            catch (IOException iOException) {}
        }
        this.inputstream = null;
        this.outputstream = null;
    }

    public void setDelete(boolean delete) {
        this.disposal = delete ? (byte)(this.disposal | 1) : (byte)(this.disposal & 0xFFFFFFFE);
    }

    public short getRecLength() {
        return this.RecLength;
    }

    public void setRecLength(short recLength) {
        this.RecLength = recLength;
    }

    public byte getTrimAction() {
        return this.trimAction;
    }

    public void setTrimAction(byte trimAction) {
        this.trimAction = trimAction;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public InputStream getInputstream() {
        return this.inputstream;
    }

    public void setInputstream(InputStream inputstream) {
        this.inputstream = inputstream;
    }

    public OutputStream getOutputstream() {
        return this.outputstream;
    }

    public void setOutputstream(OutputStream outputstream) {
        this.outputstream = outputstream;
    }

    public boolean isInVariable() {
        return this.inVariable;
    }

    public void setInVariable(boolean inVariable) {
        this.inVariable = inVariable;
    }

    public boolean isOutVariable() {
        return this.outVariable;
    }

    public void setOutVariable(boolean outVariable) {
        this.outVariable = outVariable;
    }

    public boolean isTrim() {
        return (this.trimAction & 1) != 0;
    }

    public void setTrim(boolean trim) {
        this.trimAction = trim ? (byte)(this.trimAction | 1) : (byte)(this.trimAction & 0xFFFFFFFE);
    }

    public boolean isASA() {
        return (this.trimAction & 2) != 0;
    }

    public void setASA(boolean asa) {
        this.trimAction = asa ? (byte)(this.trimAction | 2) : (byte)(this.trimAction & 0xFFFFFFFD);
    }

    public boolean isCR() {
        return this.RecLength == 0;
    }

    public void setCR(boolean cr) {
        if (cr) {
            this.RecLength = 0;
        } else if (this.isCR()) {
            this.RecLength = (short)-1;
        }
    }

    public boolean isStream() {
        return this.RecLength == -1;
    }

    public void setStream(boolean stream) {
        if (stream) {
            this.RecLength = (short)-1;
        } else if (this.isStream()) {
            this.RecLength = 0;
        }
    }

    public void setRecLength(int recLength) {
        this.setRecLength((short)recLength);
    }

    @Override
    public Map<String, Object> getParms() {
        Map<String, Object> map = super.getParms();
        map.put("reclength", this.getRecLength());
        map.put("asa", this.isASA());
        map.put("cr", this.isCR());
        map.put("invariable", this.isInVariable());
        map.put("outvariable", this.isOutVariable());
        map.put("stream", this.isStream());
        map.put("trim", this.isTrim());
        return map;
    }
}

