/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class MonitorOptionsMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String FORMAT_1 = "%1$s %2$s";
    private static final String FORMAT_2 = "%1$s %2$s::%3$s";
    protected String parameter1 = "";
    protected String parameter2 = "";
    private static final String EMPTY = "";
    protected static final int AVAILABLE = 19;
    protected byte enabled = 0;
    public static final byte SETPC_ON = 0;
    public static final byte SETPC_OFF = 1;
    public static final short SETSPC_BYP = 1;
    public static final short SETSPC_CSA = 2;
    public static final short SETSPC_CWA = 3;
    public static final short SETSPC_LETADDR = 4;
    public static final short SETSPC_LETPROG = 5;
    public static final short SETSPC_PRO = 6;
    public static final short SETSPC_TON = 7;
    public static final short SETSPC_RPC = 8;
    public static final short SETSPC_RFC = 9;
    public static final short SETSPC_RTD = 10;
    public static final short SETSPC_RTS = 11;
    public static final short SETSPC_NUP = 12;
    public static final short SETSPC_RENT = 13;
    public static final short SETSPC_FOL = 14;
    public static final short SETSPC_MUS = 15;
    public static final short SETSPC_MXS = 16;
    public static final short SETSPC_MXR = 17;
    public static final short SETSPC_USH = 18;
    public static final short SETSPC_ICT = 19;
    public static final String[] names = new String[]{"Unknown Command", "BYP", "CSA", "CWA", "LETADDR", "LETPROG", "PRO", "TON", "RPC", "RFC", "RTD", "RTS", "NUP", "RENT", "FOL", "MUS", "MXS", "MXR", "USH", "ICT"};
    public static final byte SETSPC_PROG = 0;
    public static final byte SETSPC_TERM = 64;
    public static final byte SETSPC_TRAN = 32;

    public MonitorOptionsMessage() {
        this(true);
    }

    protected MonitorOptionsMessage(boolean useloadmodule) {
        super(useloadmodule);
    }

    @Override
    protected short _defaultID() {
        return 48;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        throw new ITException("Extract Monitor Option not implimented yet");
    }

    @Override
    protected int _getMessageSize() {
        return 200;
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException("Invalid Monitor Option");
            }
        }
    }

    @Override
    protected String _toString() {
        String name;
        try {
            name = (String)Array.get(names, this.submessageID);
        }
        catch (Exception exception) {
            name = names[0];
        }
        if (this.parameter2 == null || this.parameter2.length() == 0) {
            return String.format(FORMAT_1, name, this.parameter1, this.parameter2);
        }
        return String.format(FORMAT_2, name, this.parameter1, this.parameter2);
    }

    @Override
    protected void buildMessage() throws Exception {
        int parm1length = 0;
        int parm2length = 0;
        switch (this.filetype) {
            case TERMID: {
                this.buffer.put((byte)64);
                break;
            }
            case TRANID: {
                this.buffer.put((byte)32);
                break;
            }
            default: {
                this.buffer.put((byte)0);
            }
        }
        this.buffer.put(this.putProgram());
        this.buffer.put(this.enabled);
        this.buffer.put(this.putAvailable(19));
        this.buffer.put(new byte[7]);
        switch (this.getSubmessageID()) {
            case 1: {
                parm1length = 8;
                parm2length = 8;
                break;
            }
            case 2: 
            case 3: {
                parm1length = 4;
                parm2length = 3;
                break;
            }
            case 4: 
            case 6: {
                parm1length = 8;
                parm2length = 5;
                break;
            }
            case 5: 
            case 14: {
                parm1length = 8;
                parm2length = 0;
                break;
            }
            case 7: {
                parm1length = 8;
                parm2length = 0;
                break;
            }
            case 8: 
            case 9: {
                parm1length = 8;
                parm2length = 8;
                break;
            }
            case 10: {
                parm1length = 4;
                parm2length = 4;
                break;
            }
            case 11: {
                parm1length = 36;
                parm2length = 36;
                break;
            }
            case 15: {
                parm1length = 5;
                parm2length = 0;
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                parm1length = 7;
                parm2length = 0;
            }
        }
        if (parm1length > 0) {
            this.buffer.put(HexUtil.spaceFill(this.parameter1, parm1length).getBytes("IBM1047"));
        }
        if (parm2length > 0) {
            this.buffer.put(HexUtil.spaceFill(this.parameter2, parm2length).getBytes("IBM1047"));
        }
    }

    public String getParameter1() {
        return this.parameter1;
    }

    public void setParameter1(String parameter1) {
        this.parameter1 = parameter1;
    }

    public String getParameter2() {
        return this.parameter2;
    }

    public void setParameter2(String parameter2) {
        this.parameter2 = parameter2;
    }

    public boolean isEnabled() {
        return this.enabled == 0;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled ? (byte)0 : 1;
    }

    public boolean hasOID() {
        switch (this.submessageID) {
            case 14: {
                return !"ON".equalsIgnoreCase(this.parameter1);
            }
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return false;
            }
        }
        return true;
    }
}

