/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.ConditionalBreakpointMessage;
import com.ca.intertest.debug.RequestBreakpointMessage;
import com.ca.intertest.debug.UnconditionalBreakpointMessage;
import com.ca.intertest.debug.UnsetBreakpointMessage;
import com.ca.intertest.debug.VariableBreakpointMessage;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.IConditionalBreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.IUnconditionalBreakpointMessage;
import com.ca.intertest.tools.IVariableBreakpointMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public class BreakpointMessageFactory {
    String cacopyright = "Copyright \u00a9 2016 CA";

    private BreakpointMessageFactory() {
    }

    public static BreakpointMessage[] getInstance(Object object) throws Exception, ITException {
        if (object instanceof BreakpointMarker) {
            return BreakpointMessageFactory.doBreakpointMarker((BreakpointMarker)object);
        }
        return new BreakpointMessage[]{BreakpointMessageFactory.doIMarker(object)};
    }

    private static BreakpointMessage doIMarker(Object object) throws Exception, ITException {
        Object obj;
        Object message = null;
        IMarker marker = null;
        if (object instanceof IMarker) {
            marker = (IMarker)object;
        } else if (object instanceof IAdaptable && (obj = ((IAdaptable)object).getAdapter(IMarker.class)) instanceof IMarker) {
            marker = (IMarker)obj;
        }
        if (marker == null || !marker.exists()) {
            throw new ITException(Messages.BreakpointMessageFactory_0);
        }
        String name = marker.getType();
        if (name.equals("com.ca.intertest.breakpoint.rbp")) {
            message = new RequestBreakpointMessage(marker);
        } else if (marker.isSubtypeOf("com.ca.intertest.breakpoint")) {
            if (name.equals("com.ca.intertest.breakpoint.watch")) {
                message = new VariableBreakpointMessage(marker);
            } else if (name.equals("com.ca.intertest.breakpoint.conditional")) {
                message = new ConditionalBreakpointMessage(marker);
            } else if (name.equals("com.ca.intertest.breakpoint.unconditional")) {
                message = new UnconditionalBreakpointMessage(marker);
            }
        }
        if (message == null) {
            throw new ITException(Messages.BreakpointMessageFactory_1);
        }
        message.setObject(object);
        return message;
    }

    private static BreakpointMessage[] doBreakpointMarker(BreakpointMarker marker) throws Exception, ITException {
        ArrayList<BreakpointMessage> messages = new ArrayList<BreakpointMessage>(1);
        if (marker.isSubtypeOf("com.ca.intertest.breakpoint")) {
            boolean enabled = marker.getAttribute("BREAKPOINT_ENABLED", true);
            if (enabled) {
                messages.add(BreakpointMessageFactory.getSetBPMessage(marker));
            } else {
                BreakpointMessage[] breakpointMessageArray = BreakpointMessageFactory.getUnsetBPMessage(marker);
                int n = breakpointMessageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BreakpointMessage item = breakpointMessageArray[n2];
                    messages.add(item);
                    ++n2;
                }
            }
        } else if (marker.isSubtypeOf("com.ca.intertest.monitor")) {
            boolean enabled = marker.getAttribute("BREAKPOINT_ENABLED", true);
            if (enabled) {
                messages.add(BreakpointMessageFactory.getSetBPMessage(marker));
            } else {
                BreakpointMessage[] breakpointMessageArray = BreakpointMessageFactory.getUnsetBPMessage(marker);
                int n = breakpointMessageArray.length;
                int n3 = 0;
                while (n3 < n) {
                    BreakpointMessage item = breakpointMessageArray[n3];
                    messages.add(item);
                    ++n3;
                }
            }
        } else {
            throw new ITException(Messages.BreakpointMessageFactory_3);
        }
        return messages.toArray(new BreakpointMessage[messages.size()]);
    }

    public static void setAttributes(BreakpointMessage message, IMarker marker) {
        try {
            Map attributes = marker.getAttributes();
            IResource res = marker.getResource();
            String progid = decorator.getShortName(res);
            attributes.put("programid", progid);
            BreakpointMessageFactory.setAttributes(message, attributes);
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    public static void setAttributes(BreakpointMessage message, Map<String, Object> attributes) {
        Object enabled;
        if (message.getBreakpointID() == 0L) {
            message.setBreakpointID(attributes.get("BREAKPOINT_ID"));
        }
        if ((enabled = attributes.get("BREAKPOINT_ENABLED")) == null) {
            enabled = Boolean.TRUE;
        }
        message.setEnabled(enabled);
        message.setStatement(attributes.get("stmtNumber"));
        message.setProgram(attributes.get("programid"));
        message.setStopAfter(attributes.get("stop_after"));
        message.setSkipcount(attributes.get("skip_count"));
        message.setIsCICS(attributes.get("CICS"));
        switch (message.getMessageID()) {
            case 1: 
            case 33: {
                Integer subType = (Integer)attributes.get("sub_type");
                try {
                    message.setSubmessageID((Object)subType);
                }
                catch (ITException e1) {
                    Logger.loggit(e1);
                }
                message.setStopAfter(attributes.get("stop_after"));
                switch (subType) {
                    case 3: {
                        attributes.put("label", ((IUnconditionalBreakpointMessage)message).getParagraph());
                        break;
                    }
                    case 1: {
                        message.setStatement(attributes.get("stmtNumber"));
                    }
                }
                break;
            }
            case 2: 
            case 34: {
                IConditionalBreakpointMessage msg = (IConditionalBreakpointMessage)message;
                try {
                    msg.setSubmessageID(attributes.get("sub_type"));
                }
                catch (ITException e) {
                    Logger.loggit(e);
                }
                msg.setLeftVar(attributes.get("left_variable"));
                msg.setLeftValueLen(attributes.get("left_value_len"));
                msg.setLeftType(attributes.get("left_type"));
                msg.setLeftOffset(attributes.get("left_offset"));
                msg.setLeftLenOvrd(attributes.get("left_length_override"));
                msg.setOperator(attributes.get("operator"));
                msg.setRightVar(attributes.get("right_variable"));
                msg.setRightValuelen(attributes.get("right_value_len"));
                msg.setRightType(attributes.get("right_type"));
                msg.setRightOffset(attributes.get("right_offset"));
                msg.setRightLenOvrd(attributes.get("right_length_override"));
                msg.setDropMonitor(attributes.get("drop_monitoring"));
                break;
            }
            case 3: 
            case 35: {
                IVariableBreakpointMessage varmsg = (IVariableBreakpointMessage)message;
                varmsg.setLeftVar(attributes.get("left_variable"));
                varmsg.setLeftValueLen(attributes.get("left_value_len"));
                varmsg.setLeftType(attributes.get("left_type"));
                varmsg.setLeftOffset(attributes.get("left_offset"));
                varmsg.setLeftLenOvrd(attributes.get("left_length_override"));
                varmsg.setDropMonitor(attributes.get("drop_monitoring"));
                break;
            }
            case 4: 
            case 36: {
                Assert.isLegal((boolean)false, (String)Messages.BreakpointMessageFactory_5);
                break;
            }
            case 5: {
                attributes.put("sub_type", 2);
                attributes.put("stop_after", false);
                message.setStopAfter(false);
            }
        }
    }

    public static Map<String, Object> getAttributes(IBreakpointMessage message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("programid", message.getProgram());
        switch (message.getMessageID()) {
            case 1: 
            case 33: {
                switch (message.getSubmessageID()) {
                    case 3: {
                        map.put("label", ((IUnconditionalBreakpointMessage)message).getParagraph());
                        break;
                    }
                    case 1: {
                        map.put("stmtNumber", null);
                    }
                }
                break;
            }
            case 2: 
            case 34: {
                IConditionalBreakpointMessage cbpmessage = (IConditionalBreakpointMessage)message;
                map.put("left_variable", cbpmessage.getLeftVar());
                map.put("left_value_len", new Integer(cbpmessage.getLeftValueLen()));
                map.put("left_type", new Byte(cbpmessage.getLeftType()));
                map.put("left_offset", cbpmessage.getLeftOffset());
                map.put("left_length_override", cbpmessage.getLeftLenOvrd());
                map.put("operator", new Byte(cbpmessage.getOperator()));
                map.put("right_variable", cbpmessage.getRightVar());
                map.put("right_value_len", new Integer(cbpmessage.getRightValuelen()));
                map.put("right_type", new Byte(cbpmessage.getRightType()));
                map.put("right_offset", cbpmessage.getRightOffset());
                map.put("right_length_override", cbpmessage.getRightLenOvrd());
                map.put("drop_monitoring", cbpmessage.getDropMonitor());
                break;
            }
            case 3: 
            case 35: {
                IVariableBreakpointMessage varmsg = (IVariableBreakpointMessage)message;
                map.put("left_variable", varmsg.getLeftVar());
                map.put("left_value_len", new Integer(varmsg.getLeftValueLen()));
                map.put("left_type", new Byte(varmsg.getLeftType()));
                map.put("left_offset", varmsg.getLeftOffset());
                map.put("left_length_override", varmsg.getLeftLenOvrd());
                map.put("drop_monitoring", varmsg.getDropMonitor());
                break;
            }
            case 4: 
            case 36: {
                Assert.isLegal((boolean)false, (String)Messages.BreakpointMessageFactory_6);
                break;
            }
        }
        map.put("sub_type", Integer.valueOf(message.getSubmessageID()));
        map.put("stop_after", message.getStopAfter());
        map.put("CICS", message.isCICS());
        if (message.getBreakpointID() != 0L) {
            map.put("BREAKPOINT_ID", new Long(message.getBreakpointID()));
        }
        map.put("BREAKPOINT_ENABLED", message.isEnabled());
        if (message.getStatement() > 0) {
            map.put("stmtNumber", new Integer(message.getStatement()));
        }
        return map;
    }

    private static BreakpointMessage getSetBPMessage(BreakpointMarker marker) {
        Object bpMessage = null;
        try {
            String mrkrType = marker.getType();
            if (marker != null) {
                if (mrkrType.equals("com.ca.intertest.breakpoint.rbp")) {
                    bpMessage = new RequestBreakpointMessage(marker.getMarker());
                } else if (mrkrType.equals("com.ca.intertest.breakpoint.watch")) {
                    bpMessage = new VariableBreakpointMessage(marker);
                } else if (mrkrType.equals("com.ca.intertest.breakpoint.conditional")) {
                    bpMessage = new ConditionalBreakpointMessage(marker);
                    bpMessage.setSubmessageID(marker.getAttribute("sub_type"));
                } else {
                    bpMessage = new UnconditionalBreakpointMessage(marker);
                    bpMessage.setSubmessageID(marker.getAttribute("sub_type"));
                }
            }
            bpMessage.setObject(marker);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return bpMessage;
    }

    public static BreakpointMessage[] getUnsetBPMessage(BreakpointMarker marker) {
        Object bpMessage = null;
        try {
            String mrkrType = marker.getType();
            if (mrkrType.equals("com.ca.intertest.breakpoint.rbp")) {
                bpMessage = new RequestBreakpointMessage(marker.getMarker());
                bpMessage.setEnabled(false);
                return new BreakpointMessage[]{bpMessage};
            }
            bpMessage = new UnsetBreakpointMessage(marker);
            Integer subType = (Integer)marker.getAttribute("sub_type");
            Boolean isCICS = (Boolean)marker.getAttribute("CICS");
            if (mrkrType.equals("com.ca.intertest.breakpoint.conditional") || mrkrType.equals("com.ca.intertest.breakpoint.watch")) {
                if (subType == 4) {
                    if (isCICS.booleanValue()) {
                        ArrayList<UnsetBreakpointMessage> messages = new ArrayList<UnsetBreakpointMessage>(marker.getBreakpointIDSize());
                        Long[] longArray = marker.getBreakpointIDs();
                        int n = longArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Long id = longArray[n2];
                            bpMessage = new UnsetBreakpointMessage(marker);
                            bpMessage.setSubmessageID((short)1);
                            bpMessage.setBreakpointID(id);
                            messages.add((UnsetBreakpointMessage)((Object)bpMessage));
                            ++n2;
                        }
                        return messages.toArray(new BreakpointMessage[messages.size()]);
                    }
                    bpMessage.setSubmessageID((short)6);
                } else if (isCICS.booleanValue()) {
                    bpMessage.setSubmessageID((short)2);
                } else {
                    bpMessage.setSubmessageID((short)6);
                }
            } else {
                if (subType == 1) {
                    ArrayList<UnsetBreakpointMessage> list = new ArrayList<UnsetBreakpointMessage>(marker.getBreakpointIDSize());
                    Long[] longArray = marker.getBreakpointIDs();
                    int n = longArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Long point = longArray[n3];
                        bpMessage = new UnsetBreakpointMessage(marker);
                        bpMessage.setBreakpointID(point);
                        bpMessage.setSubmessageID((short)1);
                        list.add((UnsetBreakpointMessage)((Object)bpMessage));
                        ++n3;
                    }
                    return list.toArray(new BreakpointMessage[list.size()]);
                }
                bpMessage.setSubmessageID((short)2);
            }
        }
        catch (ITException iTException) {
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        return new BreakpointMessage[]{bpMessage};
    }

    public static IMarker buildMarker(Map<String, Object> attributes, IBreakpointMessage message, debugFile file) throws ITException {
        IMarker marker;
        block13: {
            IResource resource = file.getResource();
            if (resource == null) {
                throw new ITException(String.valueOf(Messages.BreakpointMessageFactory_7) + message.getClass().getSimpleName());
            }
            if (resource.getType() != 1) {
                throw new ITException(String.valueOf(Messages.BreakpointMessageFactory_8) + message.getClass().getSimpleName());
            }
            BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
            int n = breakpointMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointMarker item = breakpointMarkerArray[n2];
                if (!item.exists()) break;
                try {
                    BreakpointMessage msg;
                    BreakpointMessage[] msgs = BreakpointMessageFactory.getInstance(item);
                    BreakpointMessage breakpointMessage = msg = msgs.length == 0 ? null : msgs[0];
                    if (message.equals(msg)) {
                        return null;
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
            marker = null;
            if (message instanceof IUnconditionalBreakpointMessage) {
                marker = resource.createMarker("com.ca.intertest.breakpoint.unconditional");
                break block13;
            }
            if (message instanceof IConditionalBreakpointMessage) {
                marker = resource.createMarker("com.ca.intertest.breakpoint.conditional");
                break block13;
            }
            if (message instanceof IVariableBreakpointMessage) {
                marker = resource.createMarker("com.ca.intertest.breakpoint.watch");
                break block13;
            }
            return null;
        }
        try {
            if (attributes != null) {
                marker.setAttributes(attributes);
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        return marker;
    }
}

