/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MoreMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public final class DebugServer
extends Thread
implements Runnable {
    static String cacopyright = "Copyright (c) 2016 CA";
    private ServerSocket serverSocket = null;
    private boolean more = true;
    private ThreadGroup threads = null;

    public DebugServer(int port) throws IOException {
        this.setName(this.getClass().getName());
        try {
            this.serverSocket = new ServerSocket(port);
            this.serverSocket.setSoTimeout(5000);
        }
        catch (IOException e) {
            Logger.loggit(32, String.valueOf(Messages.DebugServer_1) + Integer.toString(port));
            throw e;
        }
    }

    public void shutdown() {
        this.more = false;
        Logger.loggit(0, Messages.DebugServer_2);
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void finalize() {
        try {
            this.serverSocket.close();
            Logger.loggit(0, Messages.DebugServer_3);
        }
        catch (IOException iOException) {
            Logger.loggit(32, Messages.DebugServer_4);
        }
    }

    @Override
    public void run() {
        this.threads = new ThreadGroup("intertest");
        while (this.more) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                InetAddress netaddress = clientSocket.getInetAddress();
                String inet = netaddress.getHostAddress();
                int inetport = clientSocket.getPort();
                String ConnectionID = String.format("%1$s:%2$d", inet, inetport).trim();
                CVMO cvmo = this.PreReadIn(clientSocket, ConnectionID);
                Thread thread = null;
                DebugTalker talker = new DebugTalker(clientSocket, cvmo, ConnectionID);
                thread = new Thread(this.threads, talker);
                if (thread == null) continue;
                thread.start();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                Logger.loggit(32, Messages.DebugServer_5);
                return;
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        Logger.loggit(0, Messages.DebugServer_6);
    }

    private CVMO PreReadIn(Socket client, String connectionID) throws Exception {
        InputStream inReader;
        if (client == null || client.isClosed() || !client.isConnected()) {
            throw new ITException("Unexpected serverSocket setup error");
        }
        try {
            inReader = client.getInputStream();
        }
        catch (IOException e) {
            Logger.loggit(32, String.format(Messages.DebugTalker_4, HexUtil.getErrorText((Throwable)e)));
            throw e;
        }
        byte[] len = new byte[4];
        byte[] buffer = null;
        int bufflen = 0;
        ByteBuffer bytebuffer = null;
        boolean morepackets = true;
        CVMO initialCVMO = new CVMO();
        while (morepackets) {
            if (client == null || client.isClosed() || !client.isConnected()) {
                throw new ITException("Unexpected serverSocket setup error");
            }
            int bytesread = inReader.read(len, 0, 4);
            if (bytesread == -1) {
                client.close();
                return initialCVMO;
            }
            if (bytesread != len.length || (bufflen = ByteBuffer.wrap(len).getInt()) <= 4) continue;
            int toread = bufflen - 4;
            try {
                buffer = new byte[toread + 4];
                int pos = 4;
                while (bytesread >= 0 && toread > 0) {
                    bytesread = inReader.read(buffer, pos, toread);
                    toread -= bytesread;
                    pos += bytesread;
                }
                bytebuffer = ByteBuffer.wrap(buffer).putInt(0, bufflen);
                Logger.logPacket(buffer, CVMO.class, new Throwable(), connectionID);
                initialCVMO.setArray(bytebuffer, false);
                morepackets = initialCVMO.getLastMessage() instanceof MoreMessage;
            }
            catch (VirtualMachineError e) {
                Logger.loggit(e);
                initialCVMO.addMessage((DebugMessage)new StatusMessage(32, HexUtil.getErrorText((Throwable)e)));
                morepackets = false;
            }
        }
        return initialCVMO;
    }
}

