/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.IUnconditionalBreakpointMessage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class UnconditionalBreakpointMessage
extends com.ca.intertest.tools.UnconditionalBreakpointMessage
implements IUnconditionalBreakpointMessage {
    String cacopyright = "Copyright \u00a9 2016 CA";

    public UnconditionalBreakpointMessage(IMarker marker) throws CoreException {
        this();
        IResource res = marker.getResource();
        this.setProgram(decorator.getShortName(res));
        BreakpointMessageFactory.setAttributes((BreakpointMessage)this, marker);
    }

    public UnconditionalBreakpointMessage(BreakpointMarker marker) throws CoreException {
        this(marker.getMarker());
        this.breakpointID = marker.getBreakpointID();
    }

    public UnconditionalBreakpointMessage() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (!(object instanceof BreakpointMarker)) {
            return super.equals(object);
        }
        BreakpointMarker marker = (BreakpointMarker)object;
        try {
            if (!marker.getType().equals("com.ca.intertest.breakpoint.unconditional")) {
                return false;
            }
            int subtype = marker.getAttribute("sub_type", -1);
            if (subtype != this.getSubmessageID()) {
                return false;
            }
            switch (subtype) {
                case 1: {
                    return true;
                }
                case 3: {
                    String para = marker.getAttribute("label", "");
                    return para.equals(this.getParagraph());
                }
                case 2: {
                    int statement = marker.getAttribute("stmtNumber", -2);
                    return statement == this.getStatement();
                }
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

