/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.DumpMarker;
import com.ca.intertest.common.LoadListing;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.common.Snapshot;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.QueueBreakpoints;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.debug.debugPropertySource;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.BackStepMessage;
import com.ca.intertest.tools.BacktraceLogMessage;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ExecuteMessage;
import com.ca.intertest.tools.GetTracelogMessage;
import com.ca.intertest.tools.ITException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class debugSession
implements IAdaptable,
IDebugListener,
IDebug,
IActionFilter,
IPropertyChangeListener {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private boolean changed = false;
    protected final HashMap<String, debugFile> debugfiles = new HashMap();
    private final Debug parent;
    private final IProject project;
    private ServerElement debugServer = null;
    private FileServer fileServer = null;
    private debugPropertySource source = null;
    protected ResourceProperty store = null;
    private IResourceChangeListener listener;
    protected DebugTalker talker = null;
    private FilePropertyChangeListener filelistener;
    private Integer uid;
    protected boolean debugging = false;
    private String memoryUpdatePassword = "";
    private final ListenerList debugListeners = new ListenerList();
    private final ListenerList propertyChangeListeners = new ListenerList();
    protected final ArrayList<BacktraceLogMessage.TraceLogRecord> tracelog = new ArrayList(1000);
    private HashMap<Long, BreakpointMarker> breakpointmarkers = null;
    protected QueueBreakpoints queue;
    private String name;
    private String version;
    private boolean wideRegs;
    private boolean AFloat;
    private boolean stepAfter = false;
    protected File snapshotfile;
    Snapshot snapshot = null;
    protected final ServerList serverlist = ServerList.getInstance();
    private int currentIP;
    protected final decorator sessiondecorator = new decorator();

    public debugSession(IProject resource, Debug parent) throws ITException, CoreException {
        this.project = resource;
        IPath snapshotPath = this.project.getLocation();
        snapshotPath = snapshotPath.append(".snapshot");
        this.snapshotfile = snapshotPath.toFile();
        this.parent = parent;
        if (this.project == null || !this.project.hasNature("com.ca.intertest.natures.intertest")) {
            throw new ITException(Messages.debugSession_3);
        }
        this.store = new SessionStore((IResource)this.project);
        this.name = decorator.getShortName(this.store);
        String serverID = this.store.getString("com.ca.intertest.server");
        this.fileServer = this.serverlist.getFileServer(serverID);
        if (this.fileServer != null && !serverID.equals(this.fileServer.getUUIDString())) {
            this.store.setValue("com.ca.intertest.server", this.fileServer.getUUIDString());
            this.store.save();
        }
        if ((serverID = this.store.getString("com.ca.intertest.debugserver")).length() != 0) {
            this.debugServer = this.serverlist.getServer(serverID);
        }
        if (this.debugServer != null && !serverID.equals(this.debugServer.getUUIDString())) {
            this.store.setValue("com.ca.intertest.debugserver", this.debugServer.getUUIDString());
            this.store.save();
        }
        this.version = this.getVersion();
        this.wideRegs = this.isWideRegs();
        this.AFloat = this.isAFloat();
        this.stepAfter = this.isStepAfter();
        this.listener = new ResourceChangeListener();
        this.filelistener = new FilePropertyChangeListener();
        this.removedisabledMarkers();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 1);
        DumpMarker.dump(this.getResource().findMarkers(null, true, 2));
        String id = this.store.getString("uid");
        if (id == null || id.length() == 0 || id.startsWith("-")) {
            this.resetUID();
        } else {
            this.uid = this.store.getInt("uid");
        }
        this.refresh();
        this.getQueue();
        this.addPropertyChangeListener(this);
        this.store.addPropertyChangeListener(this);
        this.serverlist.addPropertyChangeListener(this);
    }

    public abstract String getProjectType();

    protected abstract QueueBreakpoints getQueue();

    public abstract void sendUnsetBreakpointsMessages();

    public abstract void sendUnsetMonitorMessages();

    public debugFile addDebugfile(IResource res) throws ITException {
        Assert.isNotNull((Object)res);
        Assert.isLegal((boolean)res.isAccessible(), (String)Messages.debugSession_7);
        debugFile debugfile = this.getFile(res);
        if (debugfile != null) {
            return debugfile;
        }
        debugfile = new debugFile((IFile)res, this);
        debugfile.addPropertyChangeListener(this.filelistener);
        this.debugfiles.put(res.getName(), debugfile);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", null, (Object)debugfile);
        this.firePropertyChangeListeners(event);
        this.changed = true;
        return debugfile;
    }

    public int compareTo(debugSession anotherSession) {
        if (anotherSession == null) {
            return -1;
        }
        return this.getTitle().compareToIgnoreCase(anotherSession.getTitle());
    }

    @Override
    public void dispose() {
        this.debugListeners.clear();
        this.propertyChangeListeners.clear();
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
            this.listener = null;
        }
        for (Map.Entry<String, debugFile> entry : this.debugfiles.entrySet()) {
            entry.getValue().dispose();
        }
        this.debugfiles.clear();
        this.store.save();
        this.suspendSession();
        this.removedisabledMarkers();
    }

    public void putSnapshot() {
        try {
            this.snapshot = new Snapshot(this);
            FileOutputStream fos = new FileOutputStream(this.snapshotfile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.snapshot);
            oos.close();
        }
        catch (ITException iTException) {
            this.snapshot = null;
            this.snapshotfile.delete();
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.snapshot = null;
            this.snapshotfile.delete();
        }
    }

    protected Snapshot getSnapshot() {
        if (this.snapshot == null) {
            try {
                ObjectInputStream oos = new ObjectInputStream(new FileInputStream(this.snapshotfile));
                this.snapshot = (Snapshot)oos.readObject();
                oos.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        return this.snapshot;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Integer && this.debugging) {
            return obj.equals(this.uid);
        }
        if (!(obj instanceof debugSession)) {
            return false;
        }
        IDebug proj = (IDebug)obj;
        return this.getResource().equals((Object)proj.getResource());
    }

    @Override
    public synchronized void firePropertyChangeListeners(PropertyChangeEvent event) {
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.add((Object)listener);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.source == null) {
                this.source = new debugPropertySource(this);
            }
            return this.source;
        }
        if (this.project != null) {
            return this.project.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        return this.debugfiles.values().toArray();
    }

    public ArrayList<debugFile> getMonitored(boolean monitored) {
        ArrayList<debugFile> list = new ArrayList<debugFile>(this.debugfiles.size());
        for (debugFile file : this.debugfiles.values()) {
            if (file.isMonitor() != monitored) continue;
            list.add(file);
        }
        return list;
    }

    public debugFile getFile(String name) {
        debugFile found = this.debugfiles.get(name);
        if (found == null) {
            found = this.debugfiles.get(String.valueOf(name) + ".intertest");
        }
        return found;
    }

    public debugFile getFile(IResource res) {
        return this.debugfiles.get(res.getName());
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    @Override
    public debugMarkerGroup getMarkergroup() {
        try {
            return debugMarkerGroup.LoadMarkers(this);
        }
        catch (ITException iTException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.sessiondecorator.decorateText("", this.project, this.store);
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public final IResource getResource() {
        return this.project;
    }

    @Override
    public ResourceProperty getStore() {
        return this.store;
    }

    @Override
    public boolean hasChildren() {
        return this.debugfiles.size() > 0;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public boolean isAtBreakpoint() {
        if (this.isDebugging() && this.talker != null) {
            return this.talker.isActive();
        }
        return false;
    }

    public String getBreakText() {
        BreakMessage msg;
        if (this.isAtBreakpoint() && (msg = this.talker.getBreakmessage()) != null) {
            return this.talker.getBreakmessage().getText();
        }
        return "";
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public void refresh() {
        this.name = this.project.getName();
        if (this.project.isAccessible()) {
            this.name = decorator.getShortName(this.store);
            try {
                IResource[] iResourceArray = this.project.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    if (res.getType() == 1 && res.isAccessible()) {
                        try {
                            this.addDebugfile(res);
                            this.changed = false;
                        }
                        catch (ITException iTException) {}
                    }
                    ++n2;
                }
                Iterator<Map.Entry<String, debugFile>> it = this.debugfiles.entrySet().iterator();
                while (it.hasNext()) {
                    debugFile file = it.next().getValue();
                    if (file.getResource().isAccessible()) continue;
                    PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", (Object)file, null);
                    this.firePropertyChangeListeners(event);
                    it.remove();
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        } else {
            this.debugfiles.clear();
        }
    }

    public synchronized void deleteAllDebugfiles() {
        Iterator<Map.Entry<String, debugFile>> it = this.debugfiles.entrySet().iterator();
        while (it.hasNext()) {
            debugFile file = it.next().getValue();
            this.removeDebugfile(file);
        }
    }

    private synchronized void removeDebugfile(debugFile debugfile) {
        String key = debugfile.getResource().getName();
        if (this.debugfiles.containsKey(key)) {
            try {
                IFile ifile = (IFile)debugfile.getResource();
                if (ifile.exists()) {
                    ResourceAttributes attrs = ifile.getResourceAttributes();
                    if (attrs != null && attrs.isReadOnly()) {
                        attrs.setReadOnly(false);
                        ifile.setResourceAttributes(attrs);
                    }
                    this.changed = true;
                    ifile.delete(true, null);
                }
            }
            catch (CoreException e) {
                Logger.loggit(4, Messages.debugSession_10, e);
            }
        }
    }

    public synchronized void deleteDebugfile(debugFile debugfile) {
        String key;
        if (debugfile != null && this.debugfiles.containsKey(key = debugfile.getResource().getName())) {
            if (debugfile.isMainModule()) {
                String prefix = debugfile.getPrefix();
                for (debugFile item : this.getMonitored(debugfile.isMonitor())) {
                    if (!item.getName().startsWith(prefix)) continue;
                    this.deleteDebugfile(item);
                }
            }
            this.removeDebugfile(debugfile);
        }
    }

    public final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String toString() {
        return this.getTitle();
    }

    public Integer getUID() {
        return this.uid;
    }

    public abstract void setDebug();

    public synchronized void resetDebug() {
        this.debugging = false;
        if (this.talker != null) {
            this.talker.Shutdown();
        }
        this.talker = null;
        this.putSnapshot();
        for (Map.Entry<String, debugFile> entry : this.debugfiles.entrySet()) {
            debugFile item = entry.getValue();
            if (!item.isMonitor()) continue;
            item.setEntered(false);
            BreakpointMarker[] breakpointMarkerArray = item.getBreakpointmarkers();
            int n = breakpointMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BreakpointMarker breakpoint = breakpointMarkerArray[n2];
                breakpoint.setBreakpointID(0L);
                ++n2;
            }
        }
    }

    public void postMessage(DebugMessage message) {
    }

    public ServerElement getDebugServer() {
        return this.debugServer;
    }

    public void setDebugServer(ServerElement debugServer) {
        if (this.debugServer == null || !this.debugServer.equals(debugServer)) {
            this.debugServer = debugServer;
            if (debugServer != null) {
                this.store.setValue("com.ca.intertest.debugserver", debugServer.getUUIDString());
            } else {
                this.store.setValue("com.ca.intertest.debugserver", null);
            }
            this.store.save();
        }
    }

    public FileServer getFileServer() {
        return this.fileServer;
    }

    public void setFileServer(FileServer fileServer) {
        if (this.fileServer == null || !this.fileServer.equals(fileServer)) {
            this.fileServer = fileServer;
            if (fileServer != null) {
                this.store.setValue("com.ca.intertest.server", fileServer.getUUIDString());
            } else {
                this.store.setValue("com.ca.intertest.server", null);
            }
            this.store.save();
        }
    }

    public abstract boolean isCICS();

    public abstract boolean isBatch();

    public DebugTalker getTalker() {
        if (this.talker != null && this.talker.isActive()) {
            return this.talker;
        }
        return null;
    }

    public void setTalker(DebugTalker talker) {
        this.talker = talker;
    }

    public abstract void suspendSession();

    public abstract void endSession();

    @Override
    public synchronized void fireDebugMessageListeners(debugEvent event) {
        Object[] objectArray = this.debugListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDebugListener)listener).debugEventOccured(event);
            ++n2;
        }
    }

    @Override
    public synchronized void removeDebugListener(IDebugListener listener) {
        this.debugListeners.remove((Object)listener);
    }

    @Override
    public synchronized void addDebugListener(IDebugListener listener) {
        if (listener != null) {
            this.debugListeners.add((Object)listener);
        }
    }

    private void removedisabledMarkers() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getResource().findMarkers("com.ca.intertest.intertestmarker", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.exists()) {
                    try {
                        Object result = marker.getAttribute("BREAKPOINT_ENABLED");
                        if (result != null && !Boolean.parseBoolean(result.toString())) {
                            marker.delete();
                        } else {
                            result = marker.getAttribute("enabled");
                            if (result != null && !Boolean.parseBoolean(result.toString())) {
                                marker.delete();
                            } else {
                                result = marker.getType();
                                if (result != null && result.toString().equals("com.ca.intertest.breakpoint.rbp")) {
                                    short commandID = (short)marker.getAttribute("cmd", 0);
                                    if (commandID == 0) {
                                        marker.delete();
                                    }
                                } else if (result != null && result.toString().equals("com.ca.intertest.breakpoint.project")) {
                                    marker.delete();
                                }
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    public synchronized void post(Object obj) throws Exception {
        this.queue.post();
    }

    public synchronized void addBreakpoint(IMarker marker) throws Exception {
        this.queue.addBreakpoint(marker);
    }

    public void addMonitor(debugFile file) throws Exception {
        this.queue.addMonitor(file);
    }

    public void addBreakpoints(debugFile file) {
        this.queue.addBreakpoints(file);
    }

    public String getMemoryUpdatePassword() {
        return this.memoryUpdatePassword;
    }

    public void setMemoryUpdatePassword(String password) {
        this.memoryUpdatePassword = password;
    }

    public boolean testAttribute(Object target, String name, String value) {
        String args = String.format(Messages.debugSession_12, target.toString(), name, value);
        return args.length() > 0;
    }

    @Override
    public debugSession getSession() {
        return this;
    }

    public abstract String[] getUEXIT(boolean var1);

    @Override
    public abstract boolean isExecutionCount();

    @Override
    public abstract void setExecutionCount(boolean var1);

    @Override
    public abstract boolean isDataMonitor();

    @Override
    public abstract void setDataMonitor(boolean var1);

    @Override
    public abstract boolean isStatementTrace();

    @Override
    public abstract void setStatementTrace(boolean var1);

    public abstract void buildBreakpointQueue();

    public abstract boolean isDataMonitorOK();

    public abstract String getType();

    public String getVersion() {
        return (String)Attribute.getValue("version", this.getStore());
    }

    public void setVersion(String ver) {
        if (this.version == null) {
            this.version = "";
        }
        if (!this.version.equals(ver)) {
            this.version = ver;
            this.store.setValue("version", ver);
            this.store.save();
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "version", (Object)this, (Object)this));
        }
    }

    public abstract void postSnapshot(Snapshot var1, boolean var2);

    public void addStatementTrace(IDebug resource, boolean force) throws Exception {
        this.queue.addStatementTrace(resource, force);
    }

    public void addDataMonitor(IDebug resource, boolean force) throws Exception {
        this.queue.addDataMonitor(resource, force);
    }

    public void addExecutionCount(IDebug resource, boolean force, short subId) throws Exception {
        if (subId < 0) {
            subId = 1;
        }
        this.queue.addExecutionCount(resource, force, subId);
    }

    public void addRBPBreakpoints() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getResource().findMarkers("com.ca.intertest.breakpoint.rbp", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.exists() && marker.getAttribute("BREAKPOINT_ENABLED", false)) {
                    try {
                        this.addBreakpoint(marker);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    public boolean isFirstModule() {
        for (Map.Entry<String, debugFile> element : this.debugfiles.entrySet()) {
            if (!element.getValue().isEntered()) continue;
            return false;
        }
        return true;
    }

    public debugFile refreshFile(String progid, String DSN, boolean monitor, boolean post, boolean notify, int date, int time) {
        return this.refreshFile(progid, DSN, monitor, post, notify, date, time, null);
    }

    public debugFile refreshFile(String progid, String DSN, boolean monitor, boolean post, boolean notify, int date, int time, String reasonText) {
        Member member;
        debugFile file = this.getFile(progid);
        boolean keepCurrentDate = false;
        boolean checkrefresh = false;
        if (DSN == null) {
            DSN = "";
        }
        if (file == null) {
            member = new Member();
            String membername = progid.replace(".intertest", "");
            member.setName(membername);
            member.setSelectedDate(date);
            member.setSelectedTime(time);
        } else {
            ResourceProperty filestore = file.getStore();
            int filedate = (Integer)Attribute.getValue("gt_m_jul", filestore);
            int filetime = (Integer)Attribute.getValue("gt_m_tim", filestore);
            String fileDSN = Attribute.getValue("dsn", filestore).toString();
            if (reasonText != null && (reasonText.equalsIgnoreCase("CompositeSetupPage") || reasonText.equalsIgnoreCase("CICSQueueBreakpoints"))) {
                keepCurrentDate = true;
                reasonText = null;
            }
            if (filedate == date && filetime == time && date != 0 && time != 0 && (DSN.length() == 0 || DSN.equalsIgnoreCase(fileDSN)) && !keepCurrentDate) {
                file.setMonitor(monitor, post);
                return file;
            }
            if (!(date != 0 && time != 0 || filedate == 0 || filetime == 0 || DSN.length() != 0 && !DSN.equalsIgnoreCase(fileDSN) || keepCurrentDate)) {
                file.setMonitor(monitor, post);
                return file;
            }
            if (keepCurrentDate && filedate != 0 && filetime != 0) {
                date = filedate;
                time = filetime;
                DSN = fileDSN;
            }
            filestore.setValue("gt_m_jul", date);
            filestore.setValue("gt_m_tim", time);
            filestore.save();
            member = new Member(file);
            member.setOverwrite(false);
            member.setSelectedDate(date);
            member.setSelectedTime(time);
            checkrefresh = notify;
        }
        member.setMonitor(monitor);
        member.setDsn(DSN);
        FileConnection connection = new FileConnection(this.getFileServer());
        LoadListing loader = new LoadListing(connection, member, this, reasonText);
        try {
            loader.run();
        }
        catch (Exception e) {
            loader.buildDummy(e, member);
        }
        connection.disconnect();
        int result = loader.getResult();
        file = this.getFile(progid);
        Display display = Display.getDefault();
        switch (result) {
            case 1: {
                if (file == null || !checkrefresh || this.countBreakpoints(file) <= 0 || display == null) break;
                final String filetext = file.getName();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)Messages.debugSession_16, (String)String.format(Messages.debugSession_17, filetext));
                    }
                });
                break;
            }
        }
        if (file != null) {
            ResourceProperty filestore = file.getStore();
            filestore.setValue("gt_m_jul", date);
            filestore.setValue("gt_m_tim", time);
            filestore.save();
            file.setMonitor(monitor, post);
        }
        return file;
    }

    private int countBreakpoints(debugFile file) {
        int count = 0;
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = file.getResource().findMarkers("com.ca.intertest.breakpoint", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker element = iMarkerArray[n2];
                boolean enabled = element.getAttribute("BREAKPOINT_ENABLED", false);
                if (enabled) {
                    ++count;
                }
                ++n2;
            }
            markers = file.getResource().findMarkers("com.ca.intertest.monitor", true, 0);
            count += markers.length;
        }
        catch (CoreException coreException) {}
        return count;
    }

    @Override
    public BreakpointMarker getBreakpointMarker(long ID) {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        return this.getBreakpointMarker(new Long(ID));
    }

    private void loadbreakpointmarkers() {
        this.breakpointmarkers = new HashMap();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.project.findMarkers("com.ca.intertest.breakpoint", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.exists() && marker.getAttribute("BREAKPOINT_ENABLED", false)) {
                    try {
                        String type = marker.getType();
                        if (type != null && "com.ca.intertest.breakpoint.rbp".equals(type)) {
                            this.addBreakpointMarker(marker);
                        }
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
        }
        catch (Exception exception) {
            this.breakpointmarkers = null;
        }
    }

    @Override
    public BreakpointMarker getBreakpointMarker(Long ID) {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        return this.breakpointmarkers.get(ID);
    }

    protected void removeBreakpointMarker(IMarker marker) {
        if (this.breakpointmarkers != null) {
            Long id = new Long(marker.getId());
            this.breakpointmarkers.remove(id);
        }
    }

    @Override
    public BreakpointMarker addBreakpointMarker(IMarker marker) {
        Long id;
        BreakpointMarker item;
        block5: {
            item = null;
            try {
                if (marker.isSubtypeOf("com.ca.intertest.breakpoint")) break block5;
                return null;
            }
            catch (Exception exception) {}
        }
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        if ((item = this.getBreakpointMarker(id = new Long(marker.getId()))) == null) {
            item = new BreakpointMarker(marker);
            this.breakpointmarkers.put(id, item);
        }
        return item;
    }

    @Override
    public synchronized BreakpointMarker[] getBreakpointmarkers() {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        ArrayList<BreakpointMarker> list = new ArrayList<BreakpointMarker>(this.breakpointmarkers.size());
        for (Map.Entry<Long, BreakpointMarker> bmarker : this.breakpointmarkers.entrySet()) {
            BreakpointMarker item = bmarker.getValue();
            if (!item.exists()) continue;
            list.add(item);
        }
        return list.toArray(new BreakpointMarker[list.size()]);
    }

    @Override
    public BreakpointMarker getBreakpointMarkerbyID(long breakpointID) {
        if (this.breakpointmarkers == null) {
            return null;
        }
        for (BreakpointMarker item : this.breakpointmarkers.values()) {
            if (item.getBreakpointID() != breakpointID) continue;
            return item;
        }
        return null;
    }

    public void removeMonitor(debugFile file) {
        this.queue.removeMonitor(file);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object oldvalue = event.getOldValue();
        Object newvalue = event.getNewValue();
        if (event.getSource() instanceof ServerList) {
            if (oldvalue != null && newvalue == null) {
                if (this.debugServer != null && this.debugServer.equals(oldvalue)) {
                    this.setDebugServer(null);
                }
                if (this.fileServer != null && this.fileServer.equals(oldvalue)) {
                    this.setFileServer(null);
                }
            }
            return;
        }
        if (event.getProperty().equals("com.ca.intertest.server") && newvalue != null) {
            String serverID = newvalue.toString();
            this.fileServer = this.serverlist.getFileServer(serverID);
            if (this.fileServer != null && !serverID.equals(this.fileServer.getUUIDString())) {
                this.store.setValue("com.ca.intertest.server", this.fileServer.getUUIDString());
                this.store.save();
            }
            return;
        }
        if (event.getProperty().equals("com.ca.intertest.debugserver") && newvalue != null) {
            String serverID = newvalue.toString();
            if (serverID.length() != 0) {
                this.debugServer = ServerList.getInstance().getServer(serverID);
            }
            if (this.debugServer != null && !serverID.equals(this.debugServer.getUUIDString())) {
                this.store.setValue("com.ca.intertest.debugserver", this.debugServer.getUUIDString());
                this.store.save();
            }
            return;
        }
    }

    public void resetUID() {
        this.uid = IntertestPlugin.generateUID();
        this.store.setValue("uid", this.uid);
        this.store.save();
    }

    public void setTraceInfo(CVMI cvmi) {
        boolean foundit = false;
        DebugMessage[] debugMessageArray = cvmi.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            if (message instanceof ExecuteMessage || message instanceof BackStepMessage) {
                short steptype = message.getSubmessageID();
                switch (steptype) {
                    case 4: {
                        this.currentIP -= ((BackStepMessage)message).getCount();
                        foundit = true;
                        break;
                    }
                    case 8: {
                        this.currentIP += ((BackStepMessage)message).getCount();
                        foundit = true;
                    }
                }
            }
            ++n2;
        }
        if (!foundit) {
            this.currentIP = 0;
            this.tracelog.clear();
        } else if (this.currentIP < 0 || this.currentIP > this.tracelog.size()) {
            this.currentIP = 0;
        }
    }

    public boolean isWideRegs() {
        return (Boolean)Attribute.getValue("wide_regs", this.getStore());
    }

    public void setWideRegs(boolean wideRegs) {
        if (this.wideRegs != wideRegs) {
            this.wideRegs = wideRegs;
            this.store.setValue("wide_regs", wideRegs);
            this.store.save();
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "wide_regs", (Object)this, (Object)this));
        }
    }

    public boolean isAFloat() {
        return (Boolean)Attribute.getValue("afloat", this.getStore());
    }

    public void setAFloat(boolean afloat) {
        if (this.AFloat != afloat) {
            this.AFloat = afloat;
            this.store.setValue("afloat", afloat);
            this.store.save();
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "afloat", (Object)this, (Object)this));
        }
    }

    public boolean isStepAfter() {
        return (Boolean)Attribute.getValue("step_after", this.getStore());
    }

    public void setAfter(boolean stepafter) {
        if (this.stepAfter != stepafter) {
            this.stepAfter = stepafter;
            this.store.setValue("step_after", stepafter);
            this.store.save();
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "step_after", (Object)this, (Object)this));
        }
    }

    public ArrayList<BacktraceLogMessage.TraceLogRecord> getTracelog() {
        return this.tracelog;
    }

    protected void setTraceLog(CVMO cvmo) {
        boolean doit;
        boolean bl = doit = this.talker == null ? false : this.talker.getDebugfile().isStatementTrace();
        if (!doit && this.isCICS()) {
            for (debugFile item : this.getMonitored(true)) {
                if (!item.isStatementTrace() || !item.isTermID() && !item.isTranID()) continue;
                doit = true;
                break;
            }
        }
        if (!doit) {
            this.currentIP = 0;
            this.tracelog.clear();
            return;
        }
        doit = false;
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 4: {
                    this.currentIP = 0;
                    this.tracelog.clear();
                    return;
                }
                case 1: {
                    int type = this.talker.getBreakType();
                    switch (type) {
                        case 10: 
                        case 11: {
                            return;
                        }
                    }
                    doit = true;
                    break;
                }
            }
            ++n2;
        }
        if (!doit) {
            return;
        }
        CVMI cvmi = new CVMI();
        cvmi.addMessage((DebugMessage)new GetTracelogMessage());
        CVMO cvmotrace = null;
        try {
            cvmotrace = this.talker.process(cvmi);
        }
        catch (Exception e1) {
            Logger.loggit(e1);
            this.currentIP = 0;
            this.tracelog.clear();
            return;
        }
        DebugMessage[] debugMessageArray2 = cvmotrace.getMessages();
        int n3 = debugMessageArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            DebugMessage item = debugMessageArray2[n4];
            if (item.getMessageID() == 3) {
                BacktraceLogMessage.TraceLogRecord[] records;
                this.currentIP = 0;
                this.tracelog.clear();
                BacktraceLogMessage.TraceLogRecord[] traceLogRecordArray = records = ((BacktraceLogMessage)item).getLogRecords();
                int n5 = records.length;
                int n6 = 0;
                while (n6 < n5) {
                    BacktraceLogMessage.TraceLogRecord record = traceLogRecordArray[n6];
                    this.tracelog.add(record);
                    ++n6;
                }
                this.currentIP = records.length;
            }
            ++n4;
        }
    }

    public int getCurrentIP() {
        return this.currentIP;
    }

    public boolean isBackTraceStop(debugFile debugfile) {
        if (debugfile == null) {
            return false;
        }
        if (!debugfile.isDataMonitor()) {
            return false;
        }
        if (this.getTalker() == null) {
            return false;
        }
        return this.getTalker().getBreakType() == 11;
    }

    private class DeltaWalker
    implements IResourceDeltaVisitor {
        private DeltaWalker() {
        }

        public synchronized boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            IProject thisproject = res.getProject();
            if (!debugSession.this.project.equals((Object)thisproject)) {
                return true;
            }
            this.changeMarkers(delta);
            if (res.getType() == 1) {
                debugFile file = debugSession.this.getFile(res);
                int kind = delta.getKind();
                switch (kind) {
                    case 2: {
                        if (file == null) break;
                        debugSession.this.debugfiles.remove(file.getName());
                        PropertyChangeEvent event = new PropertyChangeEvent((Object)file, "com.ca.intertest.ui.views.debug", (Object)file, null);
                        file.firePropertyChangeListeners(event);
                        Outline outline = file.getOutline();
                        if (outline == null) break;
                        event = new PropertyChangeEvent((Object)file, "com.ca.intertest.property.outline", (Object)outline, null);
                        file.firePropertyChangeListeners(event);
                        break;
                    }
                    case 1: {
                        try {
                            file = debugSession.this.addDebugfile(res);
                            PropertyChangeEvent event = new PropertyChangeEvent((Object)file, "com.ca.intertest.ui.views.debug", null, (Object)file);
                            file.firePropertyChangeListeners(event);
                            Outline outline = file.getOutline();
                            if (outline == null) break;
                            event = new PropertyChangeEvent((Object)file, "com.ca.intertest.property.outline", null, (Object)outline);
                            file.firePropertyChangeListeners(event);
                        }
                        catch (ITException iTException) {}
                        break;
                    }
                    case 4: {
                        IMarkerDelta[] markerdeltas;
                        if (file == null) break;
                        IMarkerDelta[] iMarkerDeltaArray = markerdeltas = delta.getMarkerDeltas();
                        int n = markerdeltas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarkerDelta element = iMarkerDeltaArray[n2];
                            if (element.isSubtypeOf("com.ca.intertest.file")) {
                                file.refresh();
                                break;
                            }
                            ++n2;
                        }
                        PropertyChangeEvent event = new PropertyChangeEvent((Object)file, "com.ca.intertest.ui.views.debug", (Object)file, (Object)file);
                        file.firePropertyChangeListeners(event);
                        Outline outline = file.getOutline();
                        if (outline == null) break;
                        event = new PropertyChangeEvent((Object)file, "com.ca.intertest.property.outline", (Object)outline, (Object)outline);
                        file.firePropertyChangeListeners(event);
                    }
                }
            }
            return true;
        }

        private void changeMarkers(IResourceDelta delta) {
            IMarkerDelta[] markerdeltas;
            IMarkerDelta[] iMarkerDeltaArray = markerdeltas = delta.getMarkerDeltas();
            int n = markerdeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResource proj;
                IMarkerDelta element = iMarkerDeltaArray[n2];
                if (element.isSubtypeOf("com.ca.intertest.intertestmarker") && (proj = element.getResource()).equals((Object)debugSession.this.project)) {
                    String type = element.getType();
                    IMarker marker = element.getMarker();
                    int kind = element.getKind();
                    BreakpointMarker bpmarker = null;
                    switch (kind) {
                        case 1: {
                            bpmarker = debugSession.this.addBreakpointMarker(marker);
                            debugSession.this.firePropertyChangeListeners(new PropertyChangeEvent((Object)debugSession.this, type, null, (Object)marker));
                            break;
                        }
                        case 2: {
                            debugSession.this.firePropertyChangeListeners(new PropertyChangeEvent((Object)debugSession.this, type, (Object)marker, null));
                            debugSession.this.removeBreakpointMarker(marker);
                            break;
                        }
                        case 4: {
                            bpmarker = debugSession.this.getBreakpointMarker(marker.getId());
                            if (bpmarker != null) {
                                bpmarker.setValid(true);
                            }
                            debugSession.this.firePropertyChangeListeners(new PropertyChangeEvent((Object)debugSession.this, type, (Object)marker, (Object)marker));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private class FilePropertyChangeListener
    implements IPropertyChangeListener {
        private FilePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            debugSession.this.firePropertyChangeListeners(event);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public synchronized void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new DeltaWalker());
            }
            catch (CoreException coreException) {}
        }
    }

    private class SessionStore
    extends ResourceProperty {
        public SessionStore(IResource resource) {
            super(resource);
        }
    }
}

