/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Messages;
import com.ca.intertest.dialogs.UserLogon;
import com.ca.intertest.server.CICSServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.server.ServiceConnection;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.testingtools.common.Cavhconf;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.TTHttpException;
import com.ca.testingtools.common.XMLCavhuapi;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.dialogs.StandbyDialog;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class ServerElement
implements IAdaptable,
Comparator<ServerElement> {
    private static final String ERROR_CAVHCONF_REASON = "The CAVHCONF configuration module, which is loaded into the CSA, indicates that the product is not intended to be used on this system.";
    private static final String ERROR_CAVHCONF_MESSAGE = "CA InterTest not available on this system as set in CAVHCONF.";
    private static final String ERROR_DIALOG_TITLE_BATCH = "CA InterTest Batch";
    public static final String ERROR_DIALOG_TITLE_CICS = "CA InterTest for CICS";
    private static final String ERROR_CAVHCONF_OBTAIN = "CAVHCONF could not be obtained from the server.";
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static final String HOSTNAME = "Hostname";
    public static final String SERVER_NAME = "Name";
    protected String name = "";
    protected String hostname = "";
    private boolean userDialog = false;
    protected int port = 0;
    private boolean defaultserver = false;
    private String user = "";
    private String password = "";
    private boolean savepassword = false;
    protected boolean changed = false;
    protected ListenerList propertyChangeListeners = new ListenerList();
    protected String prefix;
    protected ScopedPreferenceStore store;
    private int result = 0;
    private String statusText = Messages.ServerElement_0;
    private int connecttime = -1;
    protected String UUIDString = "";
    private Cavhconf cavhconf = null;
    private boolean checkCavhconf = true;

    public ServerElement(IMemento child) {
        this(child.getString(SERVER_NAME), child.getString("Host"), child.getInteger("Port"), child.getString("UUID"));
        this.defaultserver = Boolean.valueOf(child.getString("Default_Server"));
        this.changed = false;
    }

    protected ServerElement(String name, String host, int port, String uuid) {
        this.store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.intertest");
        this.name = name == null ? "" : name;
        this.hostname = host.trim();
        this.port = port;
        this.UUIDString = uuid;
        this.setUUIDString(uuid);
        this.prefix = String.valueOf(uuid) + "_";
        this.savepassword = this.store.getBoolean(String.valueOf(this.prefix) + "SAVE_PASSWD");
        this.user = this.store.getString(String.valueOf(this.prefix) + "UserID");
        if (this.savepassword) {
            this.password = this.store.getString(String.valueOf(this.prefix) + "Password");
            this.password = HexUtil.decryptPassword((String)this.user, (String)this.password);
        }
        this.changed = false;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    @Override
    public int compare(ServerElement o1, ServerElement o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 == null) {
            return 1;
        }
        int result = o1.name.compareToIgnoreCase(o2.getName());
        if (result == 0) {
            result = o1.port == o2.getPort() ? 0 : (o1.port < o2.getPort() ? -1 : 1);
        }
        return result;
    }

    public int compareTo(ServerElement anotherServer) {
        return this.compare(this, anotherServer);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServerElement) {
            return this.UUIDString.equals(((ServerElement)obj).getUUIDString());
        }
        return false;
    }

    public void firePropertyChangeListeners(PropertyChangeEvent event) {
        this.changed = true;
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public String getHostname() {
        return this.hostname == null ? null : this.hostname.trim();
    }

    public String getLogonUser() throws ITException {
        if (!this.userDialog || this.user.length() < 1) {
            Display display = IntertestPlugin.getDefault().getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    UserLogon dialog = new UserLogon(null, ServerElement.this);
                    dialog.create();
                    ServerElement.this.result = dialog.open();
                }
            });
            if (this.result != 0) {
                throw new ITException(Messages.ServerElement_3);
            }
            this.userDialog = true;
        }
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public abstract boolean isCICS_server();

    public boolean isDefaultserver() {
        return this.defaultserver;
    }

    public boolean isSavepassword() {
        return this.savepassword;
    }

    public final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setChild(IMemento child) {
        child.putString(SERVER_NAME, this.getName());
        child.putString("Host", this.getHostname());
        child.putInteger("Port", this.getPort());
        child.putString("CICS_SERVER", Boolean.toString(this.isCICS_server()));
        child.putString("Default_Server", Boolean.toString(this.defaultserver));
        if (this.UUIDString.length() == 0) {
            this.UUIDString = UUID.randomUUID().toString();
        }
        child.putString("UUID", this.UUIDString);
        if (this.isCICS_server()) {
            child.putString("CICS_SECURITY", Boolean.toString(((CICSServer)this).isSecurityEnabled()));
        }
    }

    public void setDefaultserver(boolean defaultserver) {
        if (this.defaultserver != defaultserver) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "Default Server", (Object)this.defaultserver, (Object)defaultserver);
            this.defaultserver = defaultserver;
            this.firePropertyChangeListeners(event);
            this.changed = true;
        }
    }

    public void setHostname(String newhostname) {
        String string = newhostname = newhostname == null ? "" : newhostname.trim();
        if (!newhostname.equals(this.hostname)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, HOSTNAME, (Object)this.hostname, (Object)newhostname);
            this.hostname = newhostname;
            this.firePropertyChangeListeners(event);
            this.changed = true;
            if (this.isCICS_server()) {
                return;
            }
            TTServer oldTTServer = ServerList.getInstance().getInterTestServerByName(this.name);
            if (oldTTServer != null) {
                oldTTServer.setHostname(newhostname);
            }
        }
    }

    public void setPassword(String password) {
        if (this.password == null || !this.password.equals(password)) {
            this.password = password.trim();
            if (this.savepassword) {
                String tempassword = HexUtil.encryptPassword((String)this.user, (String)password);
                this.store.setValue(String.valueOf(this.prefix) + "Password", tempassword);
                try {
                    this.store.save();
                }
                catch (IOException iOException) {}
            }
            this.changed = true;
        }
    }

    public void setPort(int port) {
        if (this.port != port) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "Port", (Object)this.port, (Object)port);
            this.port = port;
            this.firePropertyChangeListeners(event);
            this.changed = true;
            TTServer oldTTServer = ServerList.getInstance().getInterTestServerByName(this.name);
            if (oldTTServer != null) {
                oldTTServer.setPort(port);
            }
        }
    }

    public void setSavepassword(boolean savepassword) {
        if (this.savepassword != savepassword) {
            this.savepassword = savepassword;
            this.store.setValue(String.valueOf(this.prefix) + "SAVE_PASSWD", this.savepassword);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
        }
    }

    public void setUser(String user) {
        String string = user = user == null ? "" : user.trim();
        if (!this.user.equals(user)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "UserID", (Object)this.user, (Object)user);
            this.user = user;
            this.firePropertyChangeListeners(event);
            this.changed = true;
            this.store.setValue(String.valueOf(this.prefix) + "UserID", this.user);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
            TTServer oldTTServer = ServerList.getInstance().getInterTestServerByName(this.name);
            if (oldTTServer != null) {
                oldTTServer.setUser(user);
            }
        }
    }

    public String toString() {
        return String.format(Messages.ServerElement_9, this.getName(), this.getHostname(), this.getPort());
    }

    public void resetUserDialog() {
        this.userDialog = false;
    }

    protected void setUserDialog() {
        this.userDialog = true;
    }

    public final Integer getConnecttime() {
        if (this.connecttime < 0) {
            this.connecttime = ServerList.getInstance().getConnecttime();
        }
        return this.connecttime;
    }

    public final void setConnecttime(Integer connecttime) {
        this.connecttime = connecttime;
        if (connecttime < 0) {
            connecttime = ServerList.getInstance().getConnecttime();
        }
    }

    private final void setUUIDString(String string) {
        if (string == null || string.length() == 0) {
            this.UUIDString = UUID.randomUUID().toString();
            this.changed = true;
        } else if (!string.equals(this.UUIDString)) {
            this.UUIDString = string;
            this.changed = true;
        }
    }

    public String getUUIDString() {
        this.setUUIDString(this.UUIDString);
        return this.UUIDString;
    }

    public void setName(String name) {
        String string = name = name == null ? "" : name.trim();
        if (!this.name.equals(name)) {
            String oldServerName = this.name;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_NAME, (Object)this.name, (Object)name);
            this.name = name;
            this.firePropertyChangeListeners(event);
            this.changed = true;
            if (this.isCICS_server()) {
                return;
            }
            TTServer oldTTServer = ServerList.getInstance().getInterTestServerByName(oldServerName);
            if (oldTTServer != null) {
                oldTTServer.setName(name);
            }
        }
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String setStatusText(String statusText) {
        String string = statusText = statusText == null ? "" : statusText.trim();
        if (!this.statusText.equals(statusText)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "StatusText", (Object)this.statusText, (Object)statusText);
            String oldValue = this.statusText;
            this.statusText = statusText;
            this.firePropertyChangeListeners(event);
            this.changed = true;
            return oldValue;
        }
        this.cavhconf = null;
        this.checkCavhconf = true;
        return statusText;
    }

    public Job checkStatus(long delayStart) {
        CheckStatusJob job = new CheckStatusJob(this);
        job.setPriority(50);
        job.setSystem(true);
        job.schedule(delayStart);
        return job;
    }

    private void checkPint() {
        if (!this.isCICS_server() & this.getStatusText().equals("Available")) {
            XMLDocument xmldoc = null;
            try {
                xmldoc = XMLCavhuapi.generatePintRequest();
            }
            catch (TTException e) {
                e.printStackTrace();
            }
            StandbyDialog dialog = new StandbyDialog(null, "Fetching server configuration.");
            dialog.open();
            CheckPintJob job = new CheckPintJob(this, xmldoc);
            job.schedule();
            try {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.cavhconf = new Cavhconf(true, true, true, true);
                    dialog.close();
                }
            }
            finally {
                this.cavhconf = new Cavhconf(true, true, true, true);
                dialog.close();
            }
        }
    }

    public boolean isEnabled(boolean isCICS) throws TTException {
        if (this.checkCavhconf && this.cavhconf == null) {
            this.checkPint();
        }
        if (!this.checkCavhconf | !this.getStatusText().equals("Available")) {
            return true;
        }
        if (this.cavhconf == null) {
            throw new TTException(ERROR_CAVHCONF_OBTAIN);
        }
        if (isCICS) {
            return this.cavhconf.isPintIntci();
        }
        return this.cavhconf.isPintIntbt();
    }

    public void reportCavhconfError(boolean isCICS) {
        this.reportCavhconfError(isCICS, new TTException(ERROR_CAVHCONF_REASON));
    }

    public void reportCavhconfError(boolean isCICS, TTException e) {
        String title = isCICS ? ERROR_DIALOG_TITLE_CICS : ERROR_DIALOG_TITLE_BATCH;
        TT_ErrorDialog.openError(null, (String)title, (String)ERROR_CAVHCONF_MESSAGE, (Throwable)e);
    }

    private class CheckPintJob
    extends Job {
        private ServerElement server;
        private XMLDocument xmlDoc;

        public CheckPintJob(ServerElement server, XMLDocument xmlDoc) {
            super(server.getName());
            this.server = server;
            this.xmlDoc = xmlDoc;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String apacheServerName = this.getName();
            TTServer apacheServer = ServerList.getInstance().getInterTestServerByName(apacheServerName);
            ServerConnect connection = new ServerConnect(apacheServer, "testingtools/utility");
            XMLRequest xmlResponse = null;
            HashMap map = new HashMap();
            try {
                xmlResponse = connection.connect("conf", map, true, this.xmlDoc);
            }
            catch (TTHttpException e) {
                if (e.getHttpStatusCode() == 404) {
                    this.server.checkCavhconf = false;
                    return Status.OK_STATUS;
                }
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            catch (TTException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            try {
                dBuilder = dbFactory.newDocumentBuilder();
                Document rdoc = dBuilder.parse(xmlResponse.toInputStream());
                this.server.cavhconf = XMLCavhuapi.parseCavhuapiResponse((Document)rdoc);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            catch (SAXException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            catch (IOException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    private class CheckStatusJob
    extends Job {
        final ServerElement server;

        public CheckStatusJob(ServerElement server) {
            super(String.valueOf(Messages.ServerElement_12) + server.getName());
            this.server = server;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ServiceConnection connection = new ServiceConnection(this.server);
            this.server.setStatusText(connection.getStatusText());
            connection.disconnect(true);
            return Status.OK_STATUS;
        }
    }
}

