/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.debug.debugFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class BrowseAction
implements IViewActionDelegate,
IDoubleClickListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private IStructuredSelection selection;
    private IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        IWorkbenchPage page = this.view.getSite().getPage();
        for (Object obj : this.selection.toList()) {
            IFile file = null;
            if (obj instanceof IT_TreeItem) {
                Object treeitem = ((IT_TreeItem)obj).getObj();
                if (treeitem instanceof debugFile) {
                    file = ((debugFile)treeitem).getResource();
                } else if (treeitem instanceof IFile) {
                    file = (IFile)treeitem;
                }
            } else if (obj instanceof IFile) {
                file = (IFile)obj;
            }
            if (file == null) continue;
            try {
                page.openEditor((IEditorInput)new FileEditorInput(file), "com.ca.intertest.ui.lister");
            }
            catch (PartInitException partInitException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        boolean enabled = false;
        for (Object obj : sel.toList()) {
            if (obj instanceof IT_TreeItem) {
                obj = ((IT_TreeItem)obj).getObj();
            }
            if (obj instanceof debugFile) {
                enabled = ((debugFile)obj).isProgram();
                break;
            }
            if (!(obj instanceof IFile)) continue;
            enabled = true;
            break;
        }
        Object object = this.selection = enabled ? sel : null;
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(null, event.getSelection());
        this.run(null);
    }
}

