/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.NewCopyDialog;
import com.ca.intertest.ui.actions.NewCopy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class NewCopyAction
implements IViewActionDelegate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private Shell shell;
    private String program;
    private debugSession session;

    public void init(IViewPart view) {
        this.shell = view.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.program == null || this.program.length() == 0) {
            NewCopyDialog dialog = new NewCopyDialog(this.shell);
            dialog.create();
            if (dialog.open() != 0) {
                return;
            }
            this.program = dialog.getProgram();
        }
        if (this.program.length() > 0) {
            NewCopy newcopy = new NewCopy(this.shell, this.session, this.program);
            newcopy.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.session = null;
        this.program = null;
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object obj = sel.getFirstElement();
        if (obj instanceof IT_TreeItem) {
            IT_TreeItem root = ((IT_TreeItem)obj).getRoot();
            if (root != null && root.getType() == TreeType.SESSION) {
                this.session = (debugSession)root.getObj();
                if (!this.session.isCICS() || !this.session.isDebugging()) {
                    this.session = null;
                } else {
                    obj = ((IT_TreeItem)obj).getObj();
                }
            }
            if (obj instanceof debugFile) {
                debugFile debugfile = (debugFile)obj;
                this.session = debugfile.getSession();
                if (debugfile.isProgram()) {
                    this.program = debugfile.getName();
                }
            }
        }
        action.setEnabled(this.session != null);
    }
}

