/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.Messages;
import com.ca.intertest.ui.actions.RulerBreakpointAction;
import com.ca.intertest.wizards.BreakpointManager;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulerConfigureBPaction
extends RulerBreakpointAction {
    static String cacopyright = "Copyright (c) 2016 CA";

    public RulerConfigureBPaction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        super(editor, rulerInfo);
    }

    @Override
    public void run() {
        if (this.resourceMarkers.isEmpty()) {
            if (this.isValidStatement()) {
                this.addMarker();
            }
        } else {
            this.changeMarker();
        }
    }

    @Override
    protected void addMarker() {
        int firstLine = this.statement.getLine();
        if (this.bpMarkerExists(firstLine)) {
            return;
        }
        Map<String, Object> attributes = this.setBaseAttributes(firstLine);
        if (!this.appendBaseAttributes(attributes)) {
            return;
        }
        String bpType = (String)attributes.get("markerType");
        Integer subType = (Integer)attributes.get("sub_type");
        boolean isGlobal = this.isGlobal(bpType, subType);
        BreakpointManager manager = new BreakpointManager(this.getLister(), attributes, isGlobal);
        manager.run();
    }

    @Override
    public void update() {
        super.update();
        this.setText(Messages.RulerConfigureBPaction_configure);
    }

    private void changeMarker() {
        IMarker marker = null;
        if (this.resourceMarkers.size() > 1 && this.getDebugSession().isCICS()) {
            List<IMarker> mrkrs = this.getMarkerSelections(true);
            marker = mrkrs.get(0);
        } else {
            marker = (IMarker)this.resourceMarkers.get(0);
        }
        BreakpointManager manager = new BreakpointManager(this.getLister(), marker, false);
        manager.run();
    }
}

