/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugBatchSessionSetup;
import com.ca.intertest.debug.DebugCICSSessionSetup;
import com.ca.intertest.debug.DebugSessionSetup;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.ui.views.debugtree.DebugTreeView;
import com.ca.intertest.wizards.BatchSettingsWizard;
import com.ca.intertest.wizards.CICSSettingsWizard;
import com.ca.intertest.wizards.SettingsWizardDialog;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class StartDebugAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    Shell shell;
    protected TreeViewer viewer;
    protected IStructuredSelection selected;
    protected debugSession session = null;
    protected IViewPart view = null;
    private static final String ERROR_TTSERVER_NOTSET = "CA TestingTool Server is not set.";
    private static final String ERROR_TTSERVER_NOTSET_REASON = "CA TestingTool Server needs to be set to obtain CAVHCONF.";

    public void dispose() {
    }

    public void init(IViewPart view) {
        if (view instanceof DebugTreeView) {
            DebugTreeView debugtreeview = (DebugTreeView)view;
            this.viewer = debugtreeview.getTreeViewer();
        } else {
            this.viewer = null;
        }
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IT_TreeItem root;
        if (this.view == null) {
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                this.init(page.showView("com.ca.intertest.ui.views.debug"));
                action.setEnabled(false);
            }
            catch (PartInitException e) {
                Logger.loggit(e);
            }
            return;
        }
        if (this.selected == null) {
            action.setEnabled(false);
            return;
        }
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Object obj = this.selected.getFirstElement();
        if (obj instanceof IT_TreeItem && (root = ((IT_TreeItem)obj).getRoot()) != null) {
            obj = root.getObj();
        }
        if (obj instanceof IResource) {
            this.session = Debug.getInstance().getSession((IResource)obj);
        } else if (obj instanceof debugSession) {
            this.session = (debugSession)obj;
        } else {
            return;
        }
        if (this.session.getFileServer() == null) {
            TT_ErrorDialog.openError(null, (String)"CA InterTest for CICS", (String)ERROR_TTSERVER_NOTSET, (Throwable)new TTException(ERROR_TTSERVER_NOTSET_REASON));
            return;
        }
        try {
            if (!this.session.getFileServer().isEnabled(this.session.isCICS())) {
                this.session.getFileServer().reportCavhconfError(this.session.isCICS());
                return;
            }
        }
        catch (TTException e) {
            this.session.getFileServer().reportCavhconfError(this.session.isCICS(), e);
            return;
        }
        if (this.session.isDebugging()) {
            return;
        }
        if (this.promptForSettings() != 1024) {
            return;
        }
        try {
            DebugSessionSetup dsession = this.session.isCICS() ? new DebugCICSSessionSetup(this.session) : new DebugBatchSessionSetup(this.session);
            int result = dsession.launch();
            if (result > 4) {
                IT_ErrorDialog.openError(32, Messages.StartDebugAction_Title, Messages.StartDebugAction_Reason_text, null);
            }
        }
        catch (Exception e) {
            String msg = HexUtil.getErrorText((Throwable)e);
            Logger.loggit(e);
            IT_ErrorDialog.openError(32, Messages.StartDebugAction_Title, msg, (Throwable)e);
        }
        if (this.viewer != null) {
            this.viewer.refresh((Object)this.selected, true);
            this.viewer.refresh(this.selected.getFirstElement(), true);
            this.viewer.setSelection((ISelection)this.selected);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty()) {
            this.selected = null;
            action.setEnabled(false);
            return;
        }
        this.view = this.getView();
        if (this.view == null) {
            this.selected = null;
            action.setEnabled(false);
            return;
        }
        boolean enabled = false;
        debugSession session = null;
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            IT_TreeItem root;
            this.selected = (IStructuredSelection)selection;
            obj = this.selected.getFirstElement();
            if (obj instanceof IT_TreeItem && (root = ((IT_TreeItem)obj).getRoot()) != null) {
                obj = root.getObj();
            }
            if (obj instanceof IDebug) {
                IProject project = ((IDebug)obj).getResource().getProject();
                session = Debug.getInstance().getSession((IResource)project);
                enabled = session == null ? false : !session.isDebugging();
            }
        }
        action.setEnabled(enabled);
        if (enabled) {
            this.selected = new StructuredSelection((Object)((IDebug)obj).getResource().getProject());
            action.setToolTipText(session.isCICS() ? Messages.StartDebugAction_2 : Messages.StartDebugAction_3);
        } else {
            action.setToolTipText(Messages.StartDebugAction_4);
        }
    }

    private int promptForSettings() {
        boolean prompt;
        boolean bl = prompt = !this.session.getStore().getBoolean("settingsShowWizard");
        if (!prompt) {
            if (this.session.getDebugServer() == null) {
                prompt = true;
            } else if (this.session.getFileServer() == null) {
                prompt = true;
            } else if (this.session.isBatch()) {
                String jcl = this.session.getStore().getString("settingsConvertDSN");
                boolean bl2 = prompt = jcl == null || jcl.length() == 0;
            }
        }
        if (!this.session.isDataMonitorOK()) {
            if (this.session.isBatch()) {
                boolean found = false;
                for (debugFile file : this.session.getMonitored(true)) {
                    if (!file.isDataMonitor()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    prompt = true;
                    String msg = String.valueOf(Messages.StartDebugAction_5) + Messages.StartDebugAction_6 + Messages.StartDebugAction_7;
                    MessageDialog.openWarning(null, (String)Messages.StartDebugAction_8, (String)msg);
                }
            } else {
                String msg;
                boolean found = false;
                for (debugFile file : this.session.getMonitored(true)) {
                    if (!file.isStatementTrace() || !file.isDataMonitor()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    prompt = true;
                    msg = String.valueOf(Messages.StartDebugAction_9) + Messages.StartDebugAction_10 + Messages.StartDebugAction_11;
                    MessageDialog.openWarning(null, (String)Messages.StartDebugAction_12, (String)msg);
                }
                prompt = true;
                String format = Messages.StartDebugAction_duplicate_warning;
                msg = String.format(format, new Object[0]);
                MessageDialog.openWarning(null, (String)Messages.StartDebugAction_12, (String)msg);
            }
        }
        if (prompt) {
            SettingsWizardDialog dialog = null;
            dialog = this.session.isCICS() ? new SettingsWizardDialog(this.shell, (IWizard)new CICSSettingsWizard(this.session, true)) : new SettingsWizardDialog(this.shell, (IWizard)new BatchSettingsWizard(this.session, true));
            dialog.create();
            return dialog.open();
        }
        return 1024;
    }

    private IViewPart getView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            return page.findView("com.ca.intertest.ui.views.debug");
        }
        return null;
    }
}

