/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.breakpoint;

import com.ca.intertest.common.Messages;
import com.ca.intertest.ui.actions.GlobalBreakpointAction;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.breakpoint.BreakpointPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class BreakpointPageBook
extends PageBookView {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String COL_ORDER = "column_order";
    private static final String COL_WIDTH = "column_width";
    private static final String COL_COUNT = "column_count";
    private static final String COL_SORT = "column_sort";
    private static final String COL_DIRECTION = "column_direction";
    static final int BKPT_TYPE = 0;
    static final int BKPT_OPERAND = 1;
    static final int BKPT_STATEMENT = 2;
    static final int BKPT_SOURCE = 3;
    static final int BKPT_USER = 4;
    static final int BKPT_TERMID = 5;
    private int sortcolumn = -1;
    private int sortdirection = 0;
    static final String[] labels = new String[]{Messages.BreakpointPageBook_5, Messages.BreakpointPageBook_6, Messages.BreakpointPageBook_7, Messages.BreakpointPageBook_8, Messages.BreakpointPageBook_9, Messages.BreakpointPageBook_10};
    static final int[] styles = new int[]{16384, 16384, 131072, 16384, 16384, 16384};
    private int[] order;
    private int[] Column_width;
    private int[] width;
    private GlobalBreakpointAction action;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.breakpointsview";

    public BreakpointPageBook() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.order = nArray;
        this.Column_width = new int[]{10, 20, 6, 20, 8, 4};
        this.width = null;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer ix;
            Integer count = memento.getInteger(COL_COUNT);
            if (count == null) {
                count = labels.length;
            }
            if (count == labels.length) {
                int i;
                String colstring = memento.getString(COL_ORDER);
                if (colstring != null) {
                    String[] colorder = colstring.split(";");
                    this.order = new int[colorder.length];
                    i = 0;
                    while (i < colorder.length) {
                        this.order[i] = Integer.parseInt(colorder[i]);
                        ++i;
                    }
                }
                if ((colstring = memento.getString(COL_WIDTH)) != null) {
                    String[] colwidth = colstring.split(";");
                    this.width = new int[colwidth.length];
                    i = 0;
                    while (i < colwidth.length) {
                        this.width[i] = Integer.parseInt(colwidth[i]);
                        ++i;
                    }
                }
            }
            if ((ix = memento.getInteger(COL_SORT)) != null) {
                this.sortcolumn = ix;
            }
            if ((ix = memento.getInteger(COL_DIRECTION)) != null) {
                this.sortdirection = ix;
            }
        }
        super.init(site, memento);
        this.action = new GlobalBreakpointAction(this.getSite());
    }

    public void saveState(IMemento memento) {
        memento.putInteger(COL_COUNT, this.order.length);
        StringBuilder colstring = new StringBuilder();
        int[] nArray = this.order;
        int n = this.order.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            colstring.append(String.format("%d;", item));
            ++n2;
        }
        colstring.setLength(colstring.length() - 1);
        memento.putString(COL_ORDER, colstring.toString());
        colstring = new StringBuilder();
        if (this.width == null) {
            this.checkWidth();
        }
        nArray = this.width;
        n = this.width.length;
        n2 = 0;
        while (n2 < n) {
            int col = nArray[n2];
            colstring.append(String.format("%d;", col));
            ++n2;
        }
        colstring.setLength(colstring.length() - 1);
        memento.putString(COL_WIDTH, colstring.toString());
        memento.putInteger(COL_SORT, this.sortcolumn);
        memento.putInteger(COL_DIRECTION, this.sortdirection);
        super.saveState(memento);
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.setMessage(Messages.BreakpointPage_no_info);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook(), CONTEXT_HELP_ID);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        this.checkWidth();
        BreakpointPage page = (BreakpointPage)((Object)part.getAdapter(BreakpointPage.class));
        if (page != null) {
            page.setPagebook(this, this.action);
            this.initPage(page);
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof ListerEditor;
    }

    public int[] getOrder() {
        return this.order;
    }

    public void setOrder(int[] order) {
        this.order = order;
    }

    public int[] getWidth() {
        this.checkWidth();
        return this.width;
    }

    public int getSortdirection() {
        return this.sortdirection;
    }

    public void setSortdirection(int sortdirection) {
        this.sortdirection = sortdirection;
    }

    public int getSortcolumn() {
        return this.sortcolumn;
    }

    public void setSortcolumn(int sortcolumn) {
        this.sortcolumn = sortcolumn;
    }

    protected void checkWidth() {
        PageBook pagebook;
        if (this.width == null && (pagebook = this.getPageBook()) != null) {
            Composite control = this.getPageBook().getParent();
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[this.Column_width.length];
            int j = 0;
            while (j < this.Column_width.length) {
                this.width[j] = this.Column_width[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
    }
}

