/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.RegisterViewPageBook;
import com.ca.intertest.ui.views.data.ViewData;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class RegisterViewData
extends ViewData {
    public static final String OFFSET = "offset";
    public static final String ROW = "row";
    static String cacopyright = "Copyright (c) 2016 CA";
    protected IPropertyChangeListener propertychangelistener;
    private IDebugListener debuglistener;
    private RegisterViewPageBook pagebook;
    public static final String[] childname = new String[]{"0-3", "4-7", "8-11", "12-15", "16-19", "20-23", "24-27", "28-31"};
    public static final String STRIDE = "stride";

    public RegisterViewData(IResource resource, AbstractDataViewPage viewpage) {
        super(resource, viewpage);
        this.refreshed = false;
        this.pagebook = (RegisterViewPageBook)viewpage.getPagebook();
        this.propertychangelistener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                block7: {
                    String key;
                    block6: {
                        TreeObject[] objects;
                        Boolean oldvalue;
                        if (!"REGISTERS".equals(event.getSource())) {
                            return;
                        }
                        Boolean newvalue = (Boolean)event.getNewValue();
                        if (newvalue.equals(oldvalue = (Boolean)event.getOldValue())) {
                            return;
                        }
                        key = event.getProperty();
                        if (!newvalue.equals(Boolean.FALSE)) break block6;
                        TreeObject[] treeObjectArray = objects = RegisterViewData.this.getTreeObjects(key);
                        int n = objects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeObject item = treeObjectArray[n2];
                            RegisterViewData.this.removeObject(item);
                            RegisterViewData.this.viewer.remove((Object)item);
                            ++n2;
                        }
                        break block7;
                    }
                    TreeObject[] objects = RegisterViewData.this.makeTreeObjects(key, RegisterViewPageBook.getKeyword(key));
                    ArrayList<TreeObject> added = new ArrayList<TreeObject>(objects.length);
                    TreeObject[] treeObjectArray = objects;
                    int n = objects.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TreeObject item = treeObjectArray[n3];
                        if (!RegisterViewData.this.keepObjects.contains(item) && RegisterViewData.this.addObject(item)) {
                            RegisterViewData.this.fetchBackingData(item);
                            added.add(item);
                        }
                        ++n3;
                    }
                    if (added.size() <= 0) break block7;
                    RegisterViewData.this.fetchBackingData(true);
                    RegisterViewData.this.viewer.refresh();
                    for (TreeObject item : added) {
                        RegisterViewData.this.viewer.expandToLevel((Object)item, 1);
                    }
                }
            }
        };
        this.pagebook.addPropertyChangeListener(this.propertychangelistener);
        this.debuglistener = new IDebugListener(){

            @Override
            public void debugEventOccured(final debugEvent event) {
                if (RegisterViewData.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Display display = Display.getDefault();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object source = event.getSource();
                            if (source instanceof CVMO) {
                                RegisterViewData.this.fetchBackingData(true);
                            } else if (source instanceof CVMI) {
                                for (TreeObject item : (this).RegisterViewData.this.keepObjects) {
                                    item.nullBackingdata();
                                }
                            }
                        }
                    });
                }
            }
        };
        this.debugitem.addDebugListener(this.debuglistener);
    }

    @Override
    public void sendMemoryMessage(TreeObject treeobject, TreeObject parent) {
    }

    private TreeObject[] makeTreeObjects(String name, String keyword) {
        TreeObject treeobject = this.getKeywordObject(name, keyword);
        if (treeobject != null) {
            return new TreeObject[]{treeobject};
        }
        return new TreeObject[0];
    }

    private TreeObject getKeywordObject(String name, String keyword) {
        IMemento item;
        TreeObject treeobject;
        block12: {
            HashMap<String, IMemento> map;
            block11: {
                if (name == null || name.trim().length() < 1) {
                    return null;
                }
                if (keyword == null) {
                    keyword = "";
                }
                treeobject = null;
                String version = this.session.getVersion();
                if (version == null || version.length() == 0) {
                    version = this.session.isCICS() ? "65" : "01";
                }
                if ((map = Keywords.getKeywords(this.session.getType(), version)) != null) break block11;
                return null;
            }
            item = map.get(keyword);
            if (item != null) break block12;
            return null;
        }
        try {
            treeobject = new TreeObject(name, "1");
            treeobject.setAttribute("dataflag", "DATAVIEW_KEYWORD");
            treeobject.setAttribute("level", "1");
            treeobject.setKeyword(keyword);
            Integer stride = item.getInteger(STRIDE);
            if (stride == null) {
                stride = 8;
            }
            String stridestr = stride.toString();
            if (name.equals("PSW")) {
                treeobject.setAttribute(STRIDE, stridestr);
                treeobject.setAttribute(ROW, Integer.toString(0));
                treeobject.setAttribute(OFFSET, Integer.toString(0));
                treeobject.setAttribute("length", String.valueOf(stride * 4));
            } else {
                treeobject.setAttribute("length", String.valueOf(stride * 16));
                int realChildnameLen = name == "VREG" ? childname.length : 4;
                int i = 0;
                while (i < realChildnameLen) {
                    TreeObject child = new TreeObject(childname[i], "1");
                    child.setAttribute("dataflag", "DATAVIEW_KEYWORD");
                    child.setAttribute("level", "2");
                    child.setAttribute(ROW, Integer.toString(i));
                    child.setAttribute(OFFSET, Integer.toString(stride * i * 4));
                    child.setAttribute(STRIDE, stridestr);
                    treeobject.addChild(child);
                    ++i;
                }
            }
            return treeobject;
        }
        catch (Exception e) {
            Logger.loggit(e);
            return null;
        }
    }

    @Override
    public TreeObject[] findObjects(String name) {
        return null;
    }

    @Override
    public boolean deleteObject(TreeObject treeobject) {
        boolean result = false;
        String markerid = treeobject.getAttribute(this.getUniqueKey());
        if (markerid != null) {
            try {
                long id = Long.parseLong(markerid);
                IMarker marker = this.debugitem.getResource().getMarker(id);
                if (marker != null && marker.exists()) {
                    marker.delete();
                    result = true;
                }
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        return result;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        TreeObject item;
        int n;
        int n2;
        TreeObject[] treeObjectArray;
        TreeObject[] objects;
        this.keepObjects.clear();
        if (this.pagebook.isPSW().booleanValue()) {
            treeObjectArray = objects = this.makeTreeObjects("PSW", "PSW");
            n2 = objects.length;
            n = 0;
            while (n < n2) {
                item = treeObjectArray[n];
                this.addObject(item);
                ++n;
            }
        }
        if (this.pagebook.isRegs().booleanValue()) {
            treeObjectArray = objects = this.makeTreeObjects("REGS", "REGS");
            n2 = objects.length;
            n = 0;
            while (n < n2) {
                item = treeObjectArray[n];
                this.addObject(item);
                ++n;
            }
        } else if (this.pagebook.isRegs64().booleanValue()) {
            treeObjectArray = objects = this.makeTreeObjects("REGS64", "REGS");
            n2 = objects.length;
            n = 0;
            while (n < n2) {
                item = treeObjectArray[n];
                this.addObject(item);
                ++n;
            }
        }
        if (this.pagebook.isFPRregs().booleanValue()) {
            treeObjectArray = objects = this.makeTreeObjects("FLPT", "FLPT");
            n2 = objects.length;
            n = 0;
            while (n < n2) {
                item = treeObjectArray[n];
                this.addObject(item);
                ++n;
            }
        }
        if (this.pagebook.isARegs().booleanValue()) {
            treeObjectArray = objects = this.makeTreeObjects("AREG", "AREG");
            n2 = objects.length;
            n = 0;
            while (n < n2) {
                item = treeObjectArray[n];
                this.addObject(item);
                ++n;
            }
        }
        if (this.pagebook.isVRegs().booleanValue()) {
            treeObjectArray = objects = this.makeTreeObjects("VREG", "VREG");
            n2 = objects.length;
            n = 0;
            while (n < n2) {
                item = treeObjectArray[n];
                this.addObject(item);
                ++n;
            }
        }
        this.fetchBackingData(false);
        return this.keepObjects.toArray(new Object[this.keepObjects.size()]);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected TreeObject[] getTreeObjects(String name) {
        ArrayList<TreeObject> list = new ArrayList<TreeObject>();
        for (TreeObject item : this.keepObjects) {
            boolean exprFlag = item.getAttribute("dataflag").equals("DATAVIEW_KEYWORD");
            if (!exprFlag || !name.equals(item.getName())) continue;
            list.add(item);
        }
        return list.toArray(new TreeObject[list.size()]);
    }

    @Override
    public void dispose() {
        this.pagebook.removePropertyChangeListener(this.propertychangelistener);
        this.debugitem.removeDebugListener(this.debuglistener);
        super.dispose();
    }
}

