/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.debugtree;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.ui.views.debugtree.DebugTreeView;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;

public class DebugTreeContentProvider
implements ITreeContentProvider {
    private DebugTreeView view;
    private IT_TreeItem root = new IT_TreeItem(TreeType.TAG, "Root");

    public DebugTreeContentProvider(DebugTreeView view) {
        this();
        this.view = view;
    }

    private DebugTreeContentProvider() {
    }

    public void dispose() {
        for (debugSession session : Debug.getInstance().getSessions()) {
            session.removePropertyChangeListener(this.view.getPropertyChangeListener());
        }
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IT_TreeItem) {
            return ((IT_TreeItem)parent).getChildren();
        }
        if (parent instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)parent).getChildren(parent);
        }
        return new Object[0];
    }

    public IT_TreeItem findObject(Object obj) {
        TreeItem[] list;
        if (obj == null) {
            return null;
        }
        IT_TreeItem found = null;
        Tree tree = this.view.getTreeViewer().getTree();
        if (tree.isDisposed()) {
            return found;
        }
        TreeItem[] treeItemArray = list = this.view.getTreeViewer().getTree().getItems();
        int n = list.length;
        int n2 = 0;
        block0: while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object object = item.getData();
            if (object instanceof IT_TreeItem) {
                if (((IT_TreeItem)object).getObj().equals(obj)) {
                    found = (IT_TreeItem)object;
                    break;
                }
                IT_TreeItem[] iT_TreeItemArray = ((IT_TreeItem)object).getChildren();
                int n3 = iT_TreeItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IT_TreeItem treeitem = iT_TreeItemArray[n4];
                    found = this.findObject(treeitem, obj);
                    if (found != null) break block0;
                    ++n4;
                }
            }
            ++n2;
        }
        return found;
    }

    public IT_TreeItem findObject(IT_TreeItem parent, Object obj) {
        if (obj.equals(parent.getObj())) {
            return parent;
        }
        IT_TreeItem[] iT_TreeItemArray = parent.getChildren();
        int n = iT_TreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IT_TreeItem child = iT_TreeItemArray[n2];
            IT_TreeItem item = this.findObject(child, obj);
            if (item != null) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public IT_TreeItem findItemName(IT_TreeItem parent, String name) {
        IT_TreeItem[] iT_TreeItemArray = parent.getChildren();
        int n = iT_TreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IT_TreeItem child = iT_TreeItemArray[n2];
            IT_TreeItem item = this.findItemName(child, name);
            if (item != null) {
                return item;
            }
            ++n2;
        }
        if (name.equals(parent.getName())) {
            return parent;
        }
        return null;
    }

    public void add(Object parent, Object obj) {
        IT_TreeItem insertobject;
        IT_TreeItem insertparent;
        IT_TreeItem treeitem = this.findObject(obj);
        if (treeitem != null) {
            return;
        }
        if (obj instanceof debugSession) {
            treeitem = this.newSession((debugSession)obj);
            this.root.addChild(treeitem);
            treeitem.setParent(null);
            insertparent = null;
            insertobject = treeitem;
        } else if (obj instanceof debugFile) {
            debugFile debugfile = (debugFile)obj;
            debugfile.getStore().addPropertyChangeListener(this.view.getPropertyChangeListener());
            boolean monitor = debugfile.isMonitor();
            debugSession session = (debugSession)debugfile.getParent();
            IT_TreeItem tree = null;
            treeitem = this.findObject(session);
            if (treeitem != null) {
                String childname = monitor ? "MONITORED" : "UNMONITORED";
                IT_TreeItem[] iT_TreeItemArray = treeitem.getChildren();
                int n = iT_TreeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IT_TreeItem item = iT_TreeItemArray[n2];
                    if (childname.equals(item.getObj())) {
                        tree = item;
                        break;
                    }
                    ++n2;
                }
            }
            if (tree != null) {
                IT_TreeItem file = new IT_TreeItem(TreeType.PROGRAM, debugfile);
                tree.addChild(file);
                insertparent = tree;
                insertobject = file;
            } else {
                insertobject = null;
                insertparent = null;
            }
        } else {
            insertobject = null;
            insertparent = null;
        }
        if (insertobject != null) {
            this.view.getTreeViewer().getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewer viewer = DebugTreeContentProvider.this.view.getTreeViewer();
                    if (insertparent == null) {
                        Object[] elements = viewer.getExpandedElements();
                        TreePath[] treePaths = viewer.getExpandedTreePaths();
                        viewer.refresh();
                        viewer.setExpandedElements(elements);
                        viewer.setExpandedTreePaths(treePaths);
                    } else {
                        viewer.add(insertparent, insertobject);
                    }
                    viewer.expandToLevel(insertobject, 1);
                    viewer.setSelection((ISelection)new StructuredSelection(insertobject), true);
                }
            });
        }
    }

    public void remove(Object obj) {
        IT_TreeItem parent;
        final IT_TreeItem treeitem = this.findObject(obj);
        if (treeitem == null) {
            return;
        }
        Object item = treeitem.getObj();
        if (item instanceof IDebug) {
            ((IDebug)item).getStore().removePropertyChangeListener(this.view.getPropertyChangeListener());
        }
        if ((parent = treeitem.getParent()) != null) {
            parent.removeChild(treeitem);
        } else {
            this.root.removeChild(treeitem);
        }
        this.view.getTreeViewer().getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DebugTreeContentProvider.this.view.getTreeViewer().remove((Object)treeitem);
            }
        });
    }

    private IT_TreeItem newSession(debugSession session) {
        IT_TreeItem file;
        IT_TreeItem treeitem = new IT_TreeItem(TreeType.SESSION, session);
        IT_TreeItem newtree = new IT_TreeItem(TreeType.TAG, DebugTreeView.STATUS, DebugTreeView.STATUS_TEXT);
        treeitem.addChild(newtree);
        newtree = new IT_TreeItem(TreeType.TAG, "MONITORED", DebugTreeView.PROGRAMS_TEXT);
        treeitem.addChild(newtree);
        for (debugFile debugfile : session.getMonitored(true)) {
            debugfile.getStore().addPropertyChangeListener(this.view.getPropertyChangeListener());
            file = new IT_TreeItem(TreeType.PROGRAM, debugfile);
            newtree.addChild(file);
        }
        newtree = new IT_TreeItem(TreeType.TAG, "UNMONITORED", DebugTreeView.UNMONITORED_TEXT);
        treeitem.addChild(newtree);
        for (debugFile debugfile : session.getMonitored(false)) {
            debugfile.getStore().addPropertyChangeListener(this.view.getPropertyChangeListener());
            file = new IT_TreeItem(TreeType.PROGRAM, debugfile);
            newtree.addChild(file);
        }
        session.addDebugListener(new debugListener(session, treeitem));
        session.addPropertyChangeListener(this.view.getPropertyChangeListener());
        session.getStore().addPropertyChangeListener(this.view.getPropertyChangeListener());
        return treeitem;
    }

    public Object[] getElements(Object parent) {
        IT_TreeItem[] children;
        for (debugSession session : Debug.getInstance().getSessions()) {
            IT_TreeItem item;
            if (!session.getResource().isAccessible() || (item = this.findObject(this.root, session)) != null) continue;
            IT_TreeItem child = this.newSession(session);
            this.root.addChild(child);
            child.setParent(null);
        }
        IT_TreeItem[] iT_TreeItemArray = children = this.root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IT_TreeItem item = iT_TreeItemArray[n2];
            debugSession session = (debugSession)item.getObj();
            IResource project = session.getResource();
            if (project == null || !project.isAccessible()) {
                this.root.removeChild(item);
            }
            ++n2;
        }
        return this.root.getChildren();
    }

    public Object getParent(Object child) {
        if (child instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)child).getParent(child);
        }
        if (child instanceof IT_TreeItem) {
            return ((IT_TreeItem)child).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)parent).hasChildren(parent);
        }
        if (parent instanceof IT_TreeItem) {
            return ((IT_TreeItem)parent).hasChildren();
        }
        return false;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    private final class Debugeventrunner
    implements Runnable {
        private debugEvent event = null;
        private final TreeViewer viewer;
        private debugSession session;
        private IT_TreeItem treeitem;

        private Debugeventrunner() {
            this.viewer = DebugTreeContentProvider.this.view.getTreeViewer();
            this.session = null;
            this.treeitem = null;
        }

        public void init(debugEvent event, debugSession session, IT_TreeItem treeitem) {
            this.event = event;
            this.session = session;
            this.treeitem = treeitem;
        }

        @Override
        public void run() {
            IActionBars bars = DebugTreeContentProvider.this.view.getViewSite().getActionBars();
            IStatusLineManager statusLine = bars.getStatusLineManager();
            statusLine.setMessage(this.session.getBreakText());
            Object obj = this.event.getSource();
            if (!(obj instanceof DSECT)) {
                return;
            }
            DSECT dsect = (DSECT)obj;
            if (dsect instanceof CVMO) {
                DebugMessage[] debugMessageArray = dsect.getMessages();
                int n = debugMessageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IT_TreeItem parent;
                    DebugMessage msg = debugMessageArray[n2];
                    IT_TreeItem found = null;
                    switch (msg.getMessageID()) {
                        case 1: {
                            BreakMessage breakmessage = (BreakMessage)msg;
                            String progid = breakmessage.getProgram();
                            debugFile debugfile = this.session.getFile(progid);
                            found = DebugTreeContentProvider.this.findObject(debugfile);
                            if (found == null) break;
                            this.viewer.refresh((Object)this.treeitem.getParent(), true);
                            break;
                        }
                        case 4: {
                            found = DebugTreeContentProvider.this.findObject(this.session);
                        }
                    }
                    if (found != null) {
                        StructuredSelection sel = new StructuredSelection((Object)found);
                        this.viewer.setSelection(null);
                        this.viewer.setSelection((ISelection)sel, true);
                    }
                    if ((parent = this.treeitem.getParent()) != null) {
                        this.viewer.refresh((Object)parent, true);
                    }
                    this.viewer.refresh((Object)this.treeitem);
                    DebugTreeContentProvider.this.view.setFocus();
                    ++n2;
                }
            } else {
                DebugMessage[] debugMessageArray = dsect.getMessages();
                int n = debugMessageArray.length;
                int n3 = 0;
                while (n3 < n) {
                    DebugMessage message = debugMessageArray[n3];
                    short msgID = message.getMessageID();
                    switch (msgID) {
                        case 4: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 15: 
                        case 17: 
                        case 32: {
                            IT_TreeItem found = null;
                            DebugTalker talker = this.event.getTalker();
                            if (talker == null || (found = DebugTreeContentProvider.this.findObject(talker.getDebugfile())) == null) break;
                            this.viewer.refresh((Object)found, true);
                            found = DebugTreeContentProvider.this.findObject(this.session);
                            IT_TreeItem[] child = found.getChildren();
                            this.viewer.refresh((Object)child[0], true);
                            break;
                        }
                        case 26: {
                            IT_TreeItem found = DebugTreeContentProvider.this.findObject(this.session);
                            if (found == null) break;
                            IT_TreeItem[] child = this.treeitem.getChildren();
                            StructuredSelection sel = new StructuredSelection((Object)child[0]);
                            this.viewer.setSelection((ISelection)sel, true);
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    public class debugListener
    implements IDebugListener {
        private debugSession session;
        private IT_TreeItem treeitem;

        public debugListener(debugSession session, IT_TreeItem treeitem) {
            this.session = session;
            this.treeitem = treeitem;
        }

        @Override
        public void debugEventOccured(debugEvent event) {
            Control control;
            if (DebugTreeContentProvider.this.view.getTreeViewer() != null && !(control = DebugTreeContentProvider.this.view.getTreeViewer().getControl()).isDisposed()) {
                Debugeventrunner runner = new Debugeventrunner();
                runner.init(event, this.session, this.treeitem);
                control.getDisplay().syncExec((Runnable)runner);
            }
        }
    }
}

