/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.BreakpointMarkerAttributes;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.debug.ConditionalBreakpointMessage;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.UnconditionalBreakpointMessage;
import com.ca.intertest.debug.VariableBreakpointMessage;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.BreakpointGlobalPage;
import com.ca.intertest.wizards.BreakpointLinePage;
import com.ca.intertest.wizards.IBreakpointPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class BreakpointWizard
extends Wizard
implements INewWizard {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private ListerEditor lister = null;
    private IMarker marker = null;
    private IBreakpointPage bpPage;
    private Map<String, Object> attributes = null;
    public HashMap<String, ArrayList<TreeObject>> dataNames;
    private IMarker[] markers;
    private IResource resource = null;
    private boolean isCICS;
    private boolean isCOBOL;
    private debugFile debugfile;
    private boolean isGlobal;
    private boolean preLoad = false;

    private BreakpointWizard() {
    }

    public BreakpointWizard(ListerEditor editor, IMarker marker, boolean global) {
        this(editor, global);
        this.marker = marker;
        this.preLoad = true;
    }

    public BreakpointWizard(ListerEditor editor, Map<String, Object> attributes, boolean global) {
        this(editor, global);
        this.attributes = attributes;
        this.preLoad = true;
    }

    public BreakpointWizard(ListerEditor editor, boolean global) {
        this();
        this.lister = editor;
        this.resource = this.lister.getResource();
        this.isCICS = Debug.getInstance().getSession(this.resource).isCICS();
        this.debugfile = Debug.getInstance().getSession(this.resource).getFile(this.resource);
        this.dataNames = this.lister.getOutline().getNames();
        int lang = this.debugfile.getLanguage();
        this.isCOBOL = lang == 32;
        this.isGlobal = global;
        this.setNeedsProgressMonitor(true);
        try {
            this.markers = this.resource.findMarkers("com.ca.intertest.breakpoint", true, 1);
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    public String getWindowTitle() {
        String action = null;
        String type = null;
        action = this.marker == null ? Messages.BreakpointWizard_0 : Messages.BreakpointWizard_1;
        type = this.isGlobal ? Messages.BreakpointWizard_2 : Messages.BreakpointWizard_3;
        return new String(String.valueOf(action) + type + Messages.BreakpointWizard_4);
    }

    public void addPages() {
        if (this.marker == null) {
            this.setAttributes();
        } else {
            try {
                this.attributes = this.marker.getAttributes();
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        this.bpPage = this.isGlobal ? new BreakpointGlobalPage(Messages.BreakpointWizard_6) : new BreakpointLinePage(Messages.BreakpointWizard_7);
        this.addPage((IWizardPage)this.bpPage);
        this.bpPage.setAttributes(this.attributes);
    }

    public IWizardPage getStartingPage() {
        return (IWizardPage)this.bpPage;
    }

    public boolean performFinish() {
        if (!this.bpPage.canFinish()) {
            return false;
        }
        Object message = null;
        this.attributes.put("programid", decorator.getShortName(this.resource));
        this.attributes.put("CICS", Debug.getInstance().getSession(this.resource).isCICS());
        String mrkrType = this.bpPage.getMarkerType();
        if (mrkrType.equals("com.ca.intertest.breakpoint.unconditional")) {
            if (this.isGlobal) {
                this.attributes.put("all_sections", new Boolean(true));
                this.attributes.put("sub_type", 1);
            } else {
                this.attributes.put("all_sections", false);
                this.attributes.put("sub_type", 2);
            }
            this.attributes.put("message", this.getMarkerMessage(Messages.BreakpointProperties_unconditional_bp));
            message = new UnconditionalBreakpointMessage();
        }
        if (mrkrType.equals("com.ca.intertest.breakpoint.conditional")) {
            if (this.isGlobal) {
                this.attributes.put("global", new Boolean(true));
                this.attributes.put("sub_type", 4);
            } else {
                this.attributes.put("global", false);
                this.attributes.put("sub_type", 2);
            }
            this.attributes.put("message", this.getMarkerMessage(Messages.BreakpointProperties_conditional_bp));
            message = new ConditionalBreakpointMessage();
        }
        if (mrkrType.equals("com.ca.intertest.breakpoint.watch")) {
            this.attributes.put("sub_type", 0);
            this.attributes.put("message", this.getMarkerMessage(Messages.BreakpointProperties_variable_bp));
            message = new VariableBreakpointMessage();
        }
        if (this.bpPage.getStopAfter()) {
            this.attributes.put("stop_after", new Boolean(true));
        } else {
            this.attributes.put("stop_after", new Boolean(false));
        }
        this.attributes.put("skip_count", this.bpPage.getSkipCount());
        if (this.isCICS) {
            this.attributes.put("drop_monitoring", this.bpPage.getDropMonitoring());
        }
        if (message == null) {
            return false;
        }
        BreakpointMessageFactory.setAttributes((BreakpointMessage)message, this.attributes);
        try {
            IResource res = this.resource;
            Object bpMessage = message;
            IWorkspaceRunnable r = new IWorkspaceRunnable((BreakpointMessage)bpMessage){
                private final /* synthetic */ BreakpointMessage val$bpMessage;
                {
                    this.val$bpMessage = breakpointMessage;
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IMarker newMarker = BreakpointMessageFactory.buildMarker(BreakpointWizard.this.attributes, (IBreakpointMessage)this.val$bpMessage, BreakpointWizard.this.debugfile);
                        if (BreakpointWizard.this.marker != null && newMarker != null) {
                            BreakpointWizard.this.removeMarker();
                        }
                    }
                    catch (ITException e) {
                        Logger.loggit(e);
                    }
                }
            };
            res.getWorkspace().run(r, null, 1, null);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return true;
    }

    public ListerEditor getLister() {
        return this.lister;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public boolean isCICS() {
        return this.isCICS;
    }

    public boolean isCOBOL() {
        return this.isCOBOL;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected void setAttributes() {
        if (this.attributes != null) {
            return;
        }
        this.attributes = BreakpointMarkerAttributes.getBaseAttributes();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public HashMap<String, ArrayList<TreeObject>> getDataNames() {
        return this.dataNames;
    }

    private void removeMarker() {
        try {
            this.marker.setAttribute("BREAKPOINT_ENABLED", false);
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    private String getMarkerMessage(String type) {
        StringBuilder msg = new StringBuilder(String.valueOf(type) + ": ");
        msg.append(this.lister.getResource().getName());
        Object stmnt = this.attributes.get("stmtNumber");
        if (stmnt != null) {
            msg.append(" [Statement: " + this.attributes.get("stmtNumber").toString() + "]");
        }
        msg.append(" - " + this.attributes.get("source"));
        this.attributes.put("message", msg.toString());
        return msg.toString();
    }

    public IMarker[] getMarkers() {
        if (this.markers.length > 0) {
            return this.markers;
        }
        return null;
    }

    public IMarker[] getMarkers(String markerType) {
        if (this.markers.length <= 0) {
            return null;
        }
        IMarker[] bpMarkers = new IMarker[1];
        Boolean enabled = null;
        ArrayList<IMarker> markerList = new ArrayList<IMarker>(5);
        String typeOfMarker = null;
        int i = 0;
        while (i < this.markers.length) {
            try {
                typeOfMarker = this.markers[i].getType();
                if (markerType.equals(typeOfMarker) && (enabled = (Boolean)this.markers[i].getAttribute("BREAKPOINT_ENABLED")).booleanValue()) {
                    markerList.add(this.markers[i]);
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            ++i;
        }
        if (markerList.size() > 0) {
            return markerList.toArray(bpMarkers);
        }
        return null;
    }

    public boolean canPreLoad() {
        return this.preLoad;
    }
}

