/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.debug.ConditionalBreakpointMessage;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.wizards.AbstractBreakpointPage;
import com.ca.intertest.wizards.AbstractBreakpointWizard;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConditionalBreakpointPage
extends AbstractBreakpointPage {
    public static final String PAGE_NAME = Messages.ConditionalBreakpointPage_0;
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private Button buttonLeftKey = null;
    private Button buttonLeftVar = null;
    private Button buttonRightConstants = null;
    private Button buttonRightKey = null;
    private Button buttonRightLiterals = null;
    private Button buttonRightVar = null;
    private String[] keyItems = null;
    private Combo leftCombo = null;
    private Composite leftData = null;
    private Combo operator = null;
    private Combo rightCombo = null;
    private Composite rightData = null;
    private Text textLeftLength = null;
    private Text textLeftOffset = null;
    private Text textRightLength = null;
    private Text textRightOffset = null;

    public ConditionalBreakpointPage(AbstractBreakpointWizard wizard) {
        super(wizard, PAGE_NAME, "com.ca.intertest.breakpoint.conditional");
    }

    @Override
    public String getMarkerType() {
        return "com.ca.intertest.breakpoint.conditional";
    }

    @Override
    public String getName() {
        return PAGE_NAME;
    }

    @Override
    public boolean isPageComplete() {
        String string;
        int ix = this.leftCombo.getSelectionIndex();
        if (ix < 0) {
            string = this.leftCombo.getText().toUpperCase();
            ix = this.leftCombo.indexOf(string);
            if (ix >= 0) {
                this.leftCombo.select(ix);
            } else {
                this.setErrorMessage(Messages.ConditionalBreakpointPage_1);
                return false;
            }
        }
        if (this.wizard.isCICS()) {
            if (this.buttonRightLiterals.getSelection()) {
                ix = this.rightCombo.getSelectionIndex();
                string = ix >= 0 ? this.rightCombo.getItem(ix) : this.rightCombo.getText();
                if (string.length() < 3) {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_2);
                    return false;
                }
                char prefix = string.charAt(0);
                if (this.isLiteral(string = prefix == 'X' || prefix == 'x' ? string.toUpperCase() : String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1)) && this.isValidLiteral(string)) {
                    this.rightCombo.setText(string);
                    return true;
                }
                this.setErrorMessage(Messages.ConditionalBreakpointPage_3);
                return false;
            }
            ix = this.rightCombo.getSelectionIndex();
            if (ix < 0) {
                string = this.rightCombo.getText().toUpperCase();
                ix = this.rightCombo.indexOf(string);
                if (ix >= 0) {
                    this.rightCombo.select(ix);
                } else {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_4);
                    return false;
                }
            }
        }
        if (this.leftData != null && this.leftData.isVisible()) {
            string = this.textLeftLength.getText();
            if (string.length() > 0) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_5);
                    return false;
                }
            }
            if ((string = this.textLeftOffset.getText()).length() > 0) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_6);
                    return false;
                }
            }
        }
        if (this.rightData != null && this.rightData.isVisible()) {
            string = this.textRightLength.getText();
            if (string.length() > 0) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_7);
                    return false;
                }
            }
            if ((string = this.textRightOffset.getText()).length() > 0) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_8);
                    return false;
                }
            }
        }
        return super.isPageComplete();
    }

    @Override
    public BreakpointMessage performFinish() {
        if (this.wizard.isCICS()) {
            this.performCICSFinish();
        } else {
            this.performBatchFinish();
        }
        Integer oper = this.operator.getSelectionIndex();
        this.attributes.put("operator", oper + 1);
        if (this.wizard.isGlobal()) {
            this.attributes.put("global", new Boolean(true));
            this.attributes.put("sub_type", 4);
        } else {
            this.attributes.put("global", false);
            this.attributes.put("sub_type", 2);
        }
        this.attributes.put("message", this.getMarkerMessage(Messages.BreakpointProperties_conditional_bp));
        return new ConditionalBreakpointMessage();
    }

    private void performBatchFinish() {
        String left = null;
        int ix = this.leftCombo.getSelectionIndex();
        left = ix >= 0 ? this.leftCombo.getItem(ix) : this.leftCombo.getText();
        this.attributes.put("left_variable", left);
        this.attributes.put("left_type", new Integer(1));
        this.attributes.put("left_value_len", this.getVariableLength(left));
        String rightSide = null;
        ix = this.rightCombo.getSelectionIndex();
        rightSide = ix >= 0 ? this.rightCombo.getItem(ix) : this.rightCombo.getText();
        if (this.isVariable(rightSide)) {
            this.attributes.put("right_variable", rightSide);
            this.attributes.put("right_type", new Integer(1));
            this.attributes.put("right_value_len", this.getVariableLength(rightSide));
        } else if (this.isConstant(rightSide)) {
            this.attributes.put("right_variable", rightSide);
            this.attributes.put("right_type", new Integer(8));
            this.attributes.put("right_value_len", rightSide.length());
        } else {
            this.attributes.put("right_variable", rightSide);
            if (this.isLiteral(rightSide)) {
                this.attributes.put("right_type", new Integer(this.getLiteralType(rightSide).byteValue()));
            } else {
                this.attributes.put("right_type", new Integer(3));
            }
            this.attributes.put("right_value_len", rightSide.length());
        }
    }

    private void performCICSFinish() {
        Integer len;
        int ix = 0;
        String leftSide = null;
        String leftLength = null;
        String leftOffset = null;
        String rightSide = null;
        String rightLength = null;
        String rightOffset = null;
        ix = this.leftCombo.getSelectionIndex();
        leftSide = ix >= 0 ? this.leftCombo.getItem(ix) : this.leftCombo.getText();
        this.attributes.put("left_variable", leftSide);
        this.attributes.put("left_value_len", this.getVariableLength(leftSide));
        if (this.buttonLeftVar.getSelection()) {
            this.attributes.put("left_type", new Integer(1));
        }
        if (this.buttonLeftKey.getSelection()) {
            this.attributes.put("left_type", new Integer(2));
            this.attributes.put("left_value_len", 1);
        }
        if ((leftLength = this.textLeftLength.getText()) != null && leftLength.length() > 0) {
            try {
                len = Integer.valueOf(leftLength);
                this.attributes.put("left_length_override", len);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.attributes.containsKey("left_length_override")) {
            this.attributes.remove("left_length_override");
        }
        if ((leftOffset = this.textLeftOffset.getText()) != null && leftOffset.length() > 0) {
            try {
                len = Integer.valueOf(leftOffset);
                this.attributes.put("left_offset", len);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.attributes.containsKey("left_offset")) {
            this.attributes.remove("left_offset");
        }
        rightSide = (ix = this.rightCombo.getSelectionIndex()) >= 0 ? this.rightCombo.getItem(ix) : this.rightCombo.getText();
        this.attributes.put("right_variable", rightSide);
        this.attributes.put("right_type", new Integer(1));
        this.attributes.put("right_value_len", this.getVariableLength(rightSide));
        if (!this.buttonRightVar.getSelection()) {
            if (this.buttonRightKey.getSelection()) {
                this.attributes.put("right_type", new Integer(2));
                this.attributes.put("right_value_len", 1);
            } else if (this.buttonRightLiterals.getSelection()) {
                String prefix = rightSide.substring(0, 1);
                if (prefix.equals("X") || prefix.equals("x")) {
                    rightSide = rightSide.toUpperCase();
                }
                this.attributes.put("right_type", new Integer(this.getLiteralType(rightSide).byteValue()));
                this.attributes.put("right_variable", rightSide);
                int literalLen = this.getLiteralImpliedLength(rightSide);
                this.attributes.put("right_value_len", literalLen);
                this.attributes.put("left_value_len", literalLen);
            }
        }
        if (this.buttonRightConstants.getSelection()) {
            this.attributes.put("right_variable", rightSide);
            this.attributes.put("right_type", new Integer(8));
        }
        rightLength = this.textRightLength.getText();
        this.attributes.put("right_length_override", null);
        if (rightLength != null && rightLength.length() > 0) {
            try {
                len = Integer.valueOf(rightLength);
                this.attributes.put("right_length_override", len);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.attributes.containsKey("right_length_override")) {
            this.attributes.remove("right_length_override");
        }
        rightOffset = this.textRightOffset.getText();
        this.attributes.put("right_offset", null);
        if (rightOffset != null && rightOffset.length() > 0) {
            try {
                len = Integer.valueOf(rightOffset);
                this.attributes.put("right_offset", len);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.attributes.containsKey("right_offset")) {
            this.attributes.remove("right_offset");
        }
    }

    @Override
    public void preLoad() {
        Integer oper = (Integer)this.attributes.get("operator");
        if (oper == null) {
            oper = 1;
        }
        this.operator.select(oper - 1);
        if (this.wizard.isCICS()) {
            this.preLoadCICS();
        } else {
            int ix;
            String dataName = (String)this.attributes.get("left_variable");
            if (dataName != null) {
                ix = this.getSelectionIndex(this.leftCombo, dataName);
                if (ix >= 0) {
                    this.leftCombo.select(ix);
                } else {
                    this.leftCombo.setText(dataName);
                }
            }
            if ((dataName = (String)this.attributes.get("right_variable")) != null) {
                ix = this.getSelectionIndex(this.rightCombo, dataName);
                if (ix >= 0) {
                    this.rightCombo.select(this.rightCombo.indexOf(dataName));
                } else {
                    String[] temp = this.rightCombo.getItems();
                    String[] newlist = new String[temp.length + 1];
                    newlist[0] = dataName;
                    int i = 1;
                    while (i < newlist.length) {
                        newlist[i] = temp[i - 1];
                        ++i;
                    }
                    this.rightCombo.setItems(newlist);
                    this.rightCombo.select(0);
                }
            }
        }
        this.preLoadOptions();
    }

    protected Byte getLiteralType(String literal) {
        Byte type = -1;
        if (!this.isLiteral(literal)) {
            return type;
        }
        char prefix = literal.charAt(0);
        int i = 0;
        while (i < IConstants.LITERALS.length) {
            if (IConstants.LITERALS[i].charAt(0) == prefix) {
                return IConstants.LITERAL_TYPES[i];
            }
            ++i;
        }
        return (byte)3;
    }

    protected boolean isLiteral(String literal) {
        if (literal.length() == 1) {
            try {
                Integer.parseInt(literal);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        String check = literal.substring(0, 2).toUpperCase();
        String[] stringArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.substring(0, 2).toUpperCase().equals(check) && literal.endsWith("'")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isValidLiteral(String literal) {
        boolean isValid = true;
        literal = literal.toUpperCase();
        Pattern p = null;
        Matcher m = null;
        String[] parts = literal.split("'");
        String num = parts[1];
        byte type = this.getLiteralType(literal);
        switch (type) {
            case 4: {
                p = Pattern.compile("[0-9A-F]+");
                m = p.matcher(num);
                isValid = m.matches();
                if (!isValid) {
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_14);
                    break;
                }
                if (num.length() % 2 == 0) break;
                isValid = false;
                this.setErrorMessage(Messages.ConditionalBreakpointPage_15);
                break;
            }
            case 5: {
                p = Pattern.compile("[\\-0-9A-F]*[0-9A-F]+");
                m = p.matcher(num);
                isValid = m.matches();
                if (isValid) break;
                this.setErrorMessage(Messages.ConditionalBreakpointPage_17);
                break;
            }
            case 6: {
                Integer hw = null;
                try {
                    hw = Integer.parseInt(num);
                    if (hw < 32768) break;
                    isValid = false;
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_18);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid = false;
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_19);
                }
                break;
            }
            case 7: {
                Integer fw = null;
                try {
                    fw = Integer.parseInt(num);
                    if (fw > Integer.MIN_VALUE && fw < Integer.MAX_VALUE) {
                        isValid = true;
                        break;
                    }
                    isValid = false;
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_20);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid = false;
                    this.setErrorMessage(Messages.ConditionalBreakpointPage_21);
                }
                break;
            }
        }
        return isValid;
    }

    @Override
    protected void setOptions(Composite parent) {
        if (this.wizard.isCICS()) {
            this.setCICSOptions(parent);
        } else {
            this.setBatchOptions(parent);
        }
    }

    private Composite getLeftData() {
        return this.leftData;
    }

    private Composite getRightData() {
        return this.rightData;
    }

    private void preLoadCICS() {
        Integer rightOffset;
        Integer leftOff;
        Button button;
        String string = (String)this.attributes.get("left_variable");
        Byte b = 1;
        int ix = 0;
        Integer leftType = (Integer)this.attributes.get("left_type");
        if (leftType == null) {
            leftType = new Integer(1);
        }
        if (leftType.byteValue() == 1) {
            button = this.buttonLeftVar;
            ix = this.getArrayIndex(this.getSortedVariables(), string);
        } else {
            button = this.buttonLeftKey;
            ix = this.getArrayIndex(this.keyItems, string);
        }
        button.setData(SAVED_STRING, (Object)string);
        button.setData(SAVED_IX, (Object)ix);
        button.setSelection(true);
        this.notifyButton(button);
        Integer leftLen = (Integer)this.attributes.get("left_length_override");
        if (leftLen != null && leftLen > 0) {
            this.textLeftLength.setText(leftLen.toString());
        }
        if ((leftOff = (Integer)this.attributes.get("left_offset")) != null && leftOff > 0) {
            this.textLeftOffset.setText(leftOff.toString());
        }
        string = (String)this.attributes.get("right_variable");
        Integer rightType = (Integer)this.attributes.get("right_type");
        if (rightType == null) {
            rightType = new Integer(1);
        }
        b = rightType.byteValue();
        switch (b) {
            case 1: {
                button = this.buttonRightVar;
                ix = this.getArrayIndex(this.getSortedVariables(), string);
                break;
            }
            case 2: {
                button = this.buttonRightKey;
                ix = this.getArrayIndex(this.keyItems, string);
                break;
            }
            case 8: {
                button = this.buttonRightConstants;
                ix = this.getArrayIndex(constants, string);
                break;
            }
            default: {
                button = this.buttonRightLiterals;
                ix = this.preLoadLiterals(button);
            }
        }
        button.setData(SAVED_STRING, (Object)string);
        button.setData(SAVED_IX, (Object)ix);
        Integer rightLen = (Integer)this.attributes.get("right_length_override");
        if (rightLen != null && rightLen > 0) {
            this.textRightLength.setText(rightLen.toString());
        }
        if ((rightOffset = (Integer)this.attributes.get("right_offset")) != null && rightOffset > 0) {
            this.textRightOffset.setText(rightOffset.toString());
        }
        boolean drop = Boolean.parseBoolean(this.attributes.get("drop_monitoring").toString());
        this.checkDropMonitor.setSelection(drop);
        button.setSelection(true);
        this.notifyButton(button);
        this.preLoadOptions();
    }

    private int preLoadLiterals(Button button) {
        Integer ix = 0;
        String varName = (String)this.attributes.get("right_variable");
        byte varType = ((Integer)this.attributes.get("right_type")).byteValue();
        byte[] types = IConstants.LITERAL_TYPES;
        int i = 0;
        while (i < types.length) {
            if (varType == types[i]) {
                ix = i;
                break;
            }
            ++i;
        }
        if (ix < 0 & ix > types.length) {
            return 0;
        }
        String[] newList = new String[literals.length];
        int i2 = 0;
        while (i2 < literals.length) {
            newList[i2] = IConstants.LITERALS[i2];
            ++i2;
        }
        newList[ix.intValue()] = varName;
        button.setData(SAVED_ARRAY, (Object)newList);
        return ix;
    }

    private void setBatchOptions(Composite parent) {
        Composite allBatch = new Composite(parent, 0);
        allBatch.setLayoutData((Object)new GridData(4, 4, true, true));
        allBatch.setLayout((Layout)new GridLayout(1, false));
        Group groupLeftSide = new Group(allBatch, 0);
        groupLeftSide.setLayout((Layout)new GridLayout(1, true));
        groupLeftSide.setLayoutData((Object)new GridData(4, 0, true, false));
        groupLeftSide.setText(Messages.ConditionalBreakpointPage_23);
        this.leftCombo = new Combo((Composite)groupLeftSide, 2816);
        this.leftCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        String[] left = this.getLeftItems();
        this.leftCombo.setItems(left);
        this.leftCombo.select(this.matchItem(left));
        this.leftCombo.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        Composite operComp = new Composite(allBatch, 0);
        operComp.setLayoutData((Object)new GridData(4, 0, true, false));
        operComp.setLayout((Layout)new GridLayout(2, false));
        Label labelOperator = new Label(operComp, 0);
        labelOperator.setLayoutData((Object)new GridData(0, 0, true, false));
        labelOperator.setText(Messages.ConditionalBreakpointPage_24);
        this.operator = new Combo(operComp, 2824);
        this.operator.setLayoutData((Object)new GridData(4, 0, true, false));
        this.operator.setItems(operators);
        this.operator.select(0);
        Group groupRightSide = new Group(allBatch, 0);
        groupRightSide.setLayout((Layout)new GridLayout(1, true));
        groupRightSide.setLayoutData((Object)new GridData(4, 0, true, false));
        groupRightSide.setText(Messages.ConditionalBreakpointPage_25);
        this.rightCombo = new Combo((Composite)groupRightSide, 2816);
        this.rightCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.rightCombo.setItems(this.getRightItems());
        this.rightCombo.select(0);
        this.rightCombo.setData(SAVED_UPPERCASE, (Object)Boolean.FALSE);
    }

    private void setCICSOptions(Composite parent) {
        ArrayList<String> keyList = new ArrayList<String>();
        this.addCoreKeywords(keyList);
        this.addRegisters(keyList);
        this.keyItems = keyList.toArray(new String[keyList.size()]);
        Group groupLeftSide = new Group(parent, 0);
        groupLeftSide.setLayout((Layout)new GridLayout(1, false));
        groupLeftSide.setLayoutData((Object)new GridData(0, 0, false, false));
        groupLeftSide.setText(Messages.ConditionalBreakpointPage_26);
        Composite leftChoices = new Composite((Composite)groupLeftSide, 0);
        leftChoices.setLayout((Layout)new GridLayout(2, false));
        leftChoices.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonLeftVar = new Button(leftChoices, 16);
        this.buttonLeftVar.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonLeftVar.setText(Messages.ConditionalBreakpointPage_27);
        String[] listArray = this.getSortedVariables();
        this.buttonLeftVar.setData(SAVED_ARRAY, (Object)listArray);
        this.buttonLeftVar.setData(SAVED_IX, (Object)new Integer(this.matchItem(this.getSortedVariables())));
        this.buttonLeftVar.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        this.buttonLeftVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointPage.this.setComboData(e, ConditionalBreakpointPage.this.leftCombo);
            }
        });
        this.buttonLeftKey = new Button(leftChoices, 16);
        this.buttonLeftKey.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonLeftKey.setText(Messages.ConditionalBreakpointPage_28);
        this.buttonLeftKey.setData(SAVED_ARRAY, (Object)this.keyItems);
        this.buttonLeftKey.setData(SAVED_IX, (Object)new Integer(this.matchItem(this.keyItems)));
        this.buttonLeftKey.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        this.buttonLeftKey.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointPage.this.setComboData(e, ConditionalBreakpointPage.this.leftCombo);
            }
        });
        this.leftData = new Composite((Composite)groupLeftSide, 0);
        this.leftData.setLayout((Layout)new GridLayout(5, false));
        this.leftData.setLayoutData((Object)new GridData(0, 0, false, false));
        this.leftCombo = new Combo(this.leftData, 2816);
        this.leftCombo.setLayoutData((Object)new GridData(0, 0, false, false));
        this.leftCombo.setItems(this.getSortedVariables());
        this.leftCombo.select(this.matchItem(this.getLeftItems()));
        this.leftCombo.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        Label labelLeftLength = new Label(this.leftData, 0);
        labelLeftLength.setLayoutData((Object)new GridData(0, 0, false, false));
        labelLeftLength.setText(Messages.ConditionalBreakpointPage_29);
        GridData textData = new GridData(0, 0, false, false);
        this.textLeftLength = new Text(this.leftData, 2048);
        this.textLeftLength.setLayoutData((Object)textData);
        this.textLeftLength.setTextLimit(10);
        this.textLeftLength.addVerifyListener((VerifyListener)new verifyDigit(false));
        Label labelLeftOffset = new Label(this.leftData, 0);
        labelLeftOffset.setLayoutData((Object)new GridData(0, 0, false, false));
        labelLeftOffset.setText(Messages.ConditionalBreakpointPage_30);
        textData = new GridData(0, 0, false, false);
        this.textLeftOffset = new Text(this.leftData, 2048);
        this.textLeftOffset.setLayoutData((Object)textData);
        this.textLeftOffset.setTextLimit(10);
        Composite operComp = new Composite(parent, 0);
        operComp.setLayoutData((Object)new GridData(0, 0, false, false));
        operComp.setLayout((Layout)new GridLayout(2, false));
        Label labelOperator = new Label(operComp, 0);
        labelOperator.setLayoutData((Object)new GridData(0, 0, true, false));
        labelOperator.setText(Messages.ConditionalBreakpointPage_31);
        this.operator = new Combo(operComp, 2824);
        this.operator.setLayoutData((Object)new GridData(0, 4, false, false));
        this.operator.setItems(operators);
        this.operator.select(0);
        Group groupRightSide = new Group(parent, 0);
        groupRightSide.setLayout((Layout)new GridLayout(1, false));
        groupRightSide.setLayoutData((Object)new GridData(0, 0, false, false));
        groupRightSide.setText(Messages.ConditionalBreakpointPage_32);
        Composite rightChoice = new Composite((Composite)groupRightSide, 0);
        rightChoice.setLayout((Layout)new GridLayout(4, false));
        rightChoice.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightVar = new Button(rightChoice, 16);
        this.buttonRightVar.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightVar.setText(Messages.ConditionalBreakpointPage_33);
        this.buttonRightVar.setData(SAVED_ARRAY, (Object)this.getSortedVariables());
        this.buttonRightVar.setData(SAVED_IX, (Object)new Integer(this.matchItem(this.getSortedVariables())));
        this.buttonRightVar.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        this.buttonRightVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointPage.this.setComboData(e, ConditionalBreakpointPage.this.rightCombo);
                ConditionalBreakpointPage.this.getRightData().setVisible(true);
            }
        });
        this.buttonRightKey = new Button(rightChoice, 16);
        this.buttonRightKey.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightKey.setText(Messages.ConditionalBreakpointPage_34);
        this.buttonRightKey.setData(SAVED_ARRAY, (Object)this.keyItems);
        this.buttonRightKey.setData(SAVED_IX, (Object)new Integer(this.matchItem(this.keyItems)));
        this.buttonRightKey.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        this.buttonRightKey.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointPage.this.getRightData().setVisible(true);
                ConditionalBreakpointPage.this.setComboData(e, ConditionalBreakpointPage.this.rightCombo);
            }
        });
        this.buttonRightLiterals = new Button(rightChoice, 16);
        this.buttonRightLiterals.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightLiterals.setText(Messages.ConditionalBreakpointPage_35);
        this.buttonRightLiterals.setData(SAVED_ARRAY, (Object)literals);
        this.buttonRightLiterals.setData(SAVED_IX, (Object)new Integer(0));
        this.buttonRightLiterals.setData(SAVED_UPPERCASE, (Object)Boolean.FALSE);
        this.buttonRightLiterals.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointPage.this.getRightData().setVisible(false);
                ConditionalBreakpointPage.this.setComboData(e, ConditionalBreakpointPage.this.rightCombo);
            }
        });
        this.buttonRightConstants = new Button(rightChoice, 16);
        this.buttonRightConstants.setLayoutData((Object)new GridData(0, 0, false, false));
        this.buttonRightConstants.setText(Messages.ConditionalBreakpointPage_36);
        this.buttonRightConstants.setData(SAVED_ARRAY, (Object)constants);
        this.buttonRightConstants.setData(SAVED_IX, (Object)new Integer(0));
        this.buttonRightConstants.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        this.buttonRightConstants.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointPage.this.getRightData().setVisible(false);
                ConditionalBreakpointPage.this.setComboData(e, ConditionalBreakpointPage.this.rightCombo);
            }
        });
        this.rightData = new Composite((Composite)groupRightSide, 0);
        this.rightData.setLayout((Layout)new GridLayout(2, false));
        this.rightData.setLayoutData((Object)new GridData(0, 0, false, false));
        this.rightCombo = new Combo(this.rightData, 2816);
        this.rightCombo.setLayoutData((Object)new GridData(0, 0, false, false));
        this.rightCombo.setItems(this.getSortedVariables());
        this.rightCombo.select(0);
        this.rightCombo.setData(SAVED_UPPERCASE, (Object)Boolean.TRUE);
        this.rightData = new Composite(this.rightData, 0);
        this.rightData.setLayout((Layout)new GridLayout(4, false));
        this.rightData.setLayoutData((Object)new GridData(0, 0, false, false));
        Label labelRightLength = new Label(this.rightData, 0);
        labelRightLength.setLayoutData((Object)new GridData(0, 0, false, false));
        labelRightLength.setText(Messages.ConditionalBreakpointPage_37);
        textData = new GridData(0, 0, false, false);
        this.textRightLength = new Text(this.rightData, 2048);
        this.textRightLength.setLayoutData((Object)textData);
        this.textRightLength.setTextLimit(10);
        this.textRightLength.addVerifyListener((VerifyListener)new verifyDigit(false));
        Label labelRightOffset = new Label(this.rightData, 0);
        labelRightOffset.setLayoutData((Object)new GridData(0, 0, false, false));
        labelRightOffset.setText(Messages.ConditionalBreakpointPage_38);
        textData = new GridData(0, 0, false, false);
        this.textRightOffset = new Text(this.rightData, 2048);
        this.textRightOffset.setLayoutData((Object)textData);
        this.textRightOffset.setTextLimit(10);
        boolean newCbp = false;
        if (this.wizard.getMarker() != null) {
            try {
                String mType = this.wizard.getMarker().getType();
                if (!mType.equals("com.ca.intertest.breakpoint.conditional")) {
                    newCbp = true;
                }
            }
            catch (CoreException e1) {
                Logger.loggit(e1);
            }
        } else {
            newCbp = true;
        }
        if (newCbp) {
            this.buttonLeftVar.setSelection(true);
            Integer ix = (Integer)this.buttonLeftVar.getData(SAVED_IX);
            if (ix != null && ix >= 0) {
                this.leftCombo.select(ix.intValue());
            }
            this.notifyButton(this.buttonLeftVar);
            this.buttonLeftKey.setSelection(false);
            this.buttonRightVar.setSelection(true);
            this.notifyButton(this.buttonRightVar);
            this.buttonRightKey.setSelection(false);
            this.buttonRightLiterals.setSelection(false);
            this.buttonRightConstants.setSelection(false);
        }
    }

    protected Integer getLiteralImpliedLength(String literal) {
        Integer len = 0;
        Byte type = 0;
        type = this.getLiteralType(literal);
        switch (type) {
            case 3: {
                String lit = this.getLiteralString(literal);
                len = lit.length();
                break;
            }
            case 4: {
                String lit = this.getLiteralString(literal);
                len = lit.length() / 2;
                break;
            }
            case 5: {
                String lit = this.getLiteralString(literal);
                if (lit.length() == 1) {
                    len = 1;
                    break;
                }
                int length = lit.length();
                len = length / 2 + 1;
                break;
            }
            case 6: {
                len = 2;
                break;
            }
            case 7: {
                len = 4;
                break;
            }
        }
        return len;
    }

    protected String getLiteralString(String literal) {
        String[] parts = literal.split("'");
        return parts[1];
    }

    protected boolean isVariable(String variable) {
        ArrayList<TreeObject> treeList = this.getTreeList(variable);
        return treeList != null;
    }
}

