/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.CobolVariable;
import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MemoryRequest;
import com.ca.intertest.common.MemoryUpdateTable;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.PLIVariable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.VariableArrays;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DataReturnMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FindRequestMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.tools.StatusMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.CoreDumpRow;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CoreDumpRowList
implements IStructuredContentProvider,
IPropertyChangeListener {
    private String sMsg;
    private byte[] coredata = new byte[0];
    protected CoreDumpRow[] rows = new CoreDumpRow[0];
    private static String CORE_WORD = Messages.CoreDumpRowList_1;
    private int goFlag = 0;
    private int stmt;
    private String textstring;
    private String searchString = "";
    private int findRange = 0;
    private byte findType = 0;
    private short findDirect = 0;
    private static final Debug debug = Debug.getInstance();
    private final debugSession session;
    private IDebug debugitem;
    private MFAddress address;
    private int dataLength;
    private int coreDataLength;
    private int offsetAddr;
    private String exprCmd;
    private String progid;
    private String fetchMsg;
    private int lang;
    public debugFile debugfile;
    public IResource resource;
    public ListerEditor editor;
    public TableViewer tableViewer;
    public TreeObject treeobject = null;
    private static final String sep = "\u0000";
    public boolean hasSQL = true;

    public CoreDumpRowList(IResource res, ListerEditor lsteditor, TableViewer view) {
        this.resource = res;
        this.debugitem = debug.getResource(res);
        this.debugitem.addPropertyChangeListener(this);
        this.editor = lsteditor;
        this.tableViewer = view;
        this.session = (debugSession)debug.getResource((IResource)this.editor.getResource().getProject());
        this.debugfile = (debugFile)debug.getResource(this.editor.getResource());
        this.lang = this.debugfile.getStore().getHex("gt_m_lang");
    }

    public void initData(MFAddress argStartAddr, int argDataLength, int argOffsetAddr, String argExprCmd, String argProgid, int argStmt, String argVarname) {
        this.address = argStartAddr;
        this.dataLength = argDataLength;
        this.offsetAddr = argOffsetAddr;
        this.exprCmd = argExprCmd;
        this.stmt = argStmt;
        this.progid = argProgid;
        this.findRange = 0;
        if (this.session.isAtBreakpoint() && this.session.getName().length() != 0) {
            if (this.exprCmd.toUpperCase().equals("LASTSQL") || this.exprCmd.toUpperCase().equals("SQLRCODE")) {
                this.goFlag = 2;
            }
            if (this.goFlag < 2 || this.hasSQL) {
                boolean monitor = ((debugFile)this.debugitem).isMonitor();
                boolean entered = ((debugFile)this.debugitem).isEntered();
                if (monitor && entered) {
                    TreeObject tree;
                    MemoryRequest memRequest = new MemoryRequest(this.session, this.editor, this.progid, this.lang);
                    if (this.treeobject instanceof Variable) {
                        tree = this.treeobject;
                        if (this.dataLength > 0) {
                            tree.setAttribute("length", String.valueOf(this.dataLength));
                        }
                    } else {
                        tree = this.getTree();
                    }
                    memRequest.sendMemoryMessage(tree);
                    try {
                        DataReturnMessage drmsg = memRequest.getDataReturnMessage();
                        if (drmsg != null) {
                            this.processMemoryMessage(drmsg);
                        }
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                } else {
                    String msg = String.valueOf(Messages.CoreDumpRowList_7) + this.progid + Messages.CoreDumpRowList_8;
                    Logger.loggit(4, msg);
                }
            } else {
                this.textstring = String.valueOf(Messages.CoreDumpRowList_9) + this.exprCmd.toUpperCase() + sep + Messages.CoreDumpRowList_10 + this.progid + sep + Messages.CoreDumpRowList_11;
            }
        }
    }

    public TreeObject getTree() {
        TreeObject tree = null;
        String exprName = Messages.CoreDumpRowList_12;
        if (this.exprCmd.length() == 0) {
            String format = Messages.CoreDumpRowList_13;
            this.exprCmd = String.format(format, this.address.getAddrString(), String.valueOf(this.offsetAddr), this.address.getAletString(), Integer.toString(this.dataLength));
        }
        tree = Expressions.getTree(exprName, "CORE_EXPRESSION");
        tree.setKeyword(exprName);
        tree.setAlternateName(this.exprCmd);
        tree.setAttribute("length", Integer.toString(this.dataLength));
        return tree;
    }

    public void initVarData(MFAddress argStartAddr, int argDataLength, int argOffsetAddr, String argExprCmd, String argProgid, int argStmt, String argVarname, TreeObject argTreeobject) {
        this.treeobject = argTreeobject;
        int len = argDataLength;
        if ((this.treeobject instanceof CobolVariable || this.treeobject instanceof PLIVariable) && (Integer)Attribute.getValue("gt_dmax1", this.treeobject) > 0) {
            Integer[] idxs = new Integer[]{0};
            int max = VariableArrays.getArrayLth(this.treeobject, idxs, 3);
            int min = VariableArrays.getArrayLth(this.treeobject, idxs, 1);
            len += max - min;
        }
        String var = argVarname;
        MFAddress addr = argStartAddr;
        if (addr.equals((Object)MFAddress.ZERO_ADDR)) {
            addr = this.treeobject.getAddress();
        }
        if (!addr.equals((Object)MFAddress.ZERO_ADDR)) {
            var = "";
            this.treeobject = null;
        }
        this.initData(addr, len, argOffsetAddr, "", argProgid, argStmt, var);
    }

    public void initFindData(MFAddress argStartAddr, int argDataLength, int argFindDirection, String argSearchString, int argFindRange, int argFindType) {
        this.address = argStartAddr;
        this.dataLength = argDataLength;
        this.findDirect = (short)argFindDirection;
        this.searchString = argSearchString;
        this.findRange = argFindRange;
        this.findType = (byte)argFindType;
        this.sendFindMessage(this.session);
    }

    public void sendFindMessage(debugSession session) {
        DebugTalker talker = null;
        talker = session.getTalker();
        if (talker != null) {
            CVMO cvmo = null;
            try {
                CVMI cvmi = new CVMI();
                FindRequestMessage msg = new FindRequestMessage();
                msg.setDataLength(this.dataLength);
                msg.setAddress(this.address);
                msg.setFindValue(this.searchString);
                msg.setSubmessageID(this.findDirect);
                msg.setFindType(this.findType);
                msg.setFindRange(this.findRange);
                this.fetchMsg = "FIND " + (this.findDirect == 0 ? "NEXT" : "PREV") + " (" + (this.findType == 0 ? "Hex" : "Char") + ")" + " for range " + this.findRange + " and search string: " + this.searchString + " ";
                cvmi.addMessage((DebugMessage)msg);
                cvmo = talker.process(cvmi);
                this.processCVMO(cvmo);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    private void processCVMO(CVMO cvmo) {
        DebugMessage message = cvmo.getMessage(1);
        switch (message.getMessageID()) {
            case 5: {
                String msg = String.valueOf(CORE_WORD) + Messages.CoreDumpRowList_43 + this.fetchMsg;
                Logger.loggit(0, msg);
                DataReturnMessage drmsg = (DataReturnMessage)message;
                this.processMemoryMessage(drmsg);
                break;
            }
            case 18: {
                StatusMessage smsg = (StatusMessage)message;
                short errorLevel = smsg.getStatus();
                String errorMessage = smsg.getMessage(0);
                String msg = String.valueOf(CORE_WORD) + Messages.CoreDumpRowList_44 + errorLevel + Messages.CoreDumpRowList_45 + errorMessage + Messages.CoreDumpRowList_46 + this.fetchMsg;
                Shell sShell = new Shell();
                MessageDialog.openWarning((Shell)sShell, (String)(String.valueOf(CORE_WORD) + Messages.CoreDumpRowList_47), (String)msg);
                sShell.dispose();
                Logger.loggit((int)errorLevel, msg);
            }
        }
    }

    public void processMemoryMessage(DataReturnMessage msg) {
        short subMsgID = msg.getSubmessageID();
        if (subMsgID == 1) {
            this.goFlag = 2;
            this.textstring = HexUtil.toString((byte[])msg.getHexdata());
        } else {
            this.coredata = msg.getHexdata();
            this.goFlag = 1;
            if (this.coredata.length == 0) {
                this.goFlag = 0;
            } else if (this.exprCmd.length() > 0 || this.stmt > 0 || this.findRange > 0) {
                this.address = msg.getAddress();
            }
        }
        if (this.goFlag == 0) {
            this.sMsg = Messages.CoreDumpRowList_48;
            Logger.loggit(16, this.sMsg);
        } else if (this.goFlag == 1 && this.coredata != null) {
            this.loadData(this.coredata, this.address, this.offsetAddr);
        }
    }

    public void loadModifiedData(byte[] coreData, MFAddress addr, int offset) {
        this.coredata = coreData;
        this.loadData(this.coredata, addr, offset);
    }

    public void loadData(byte[] coreData, MFAddress address, int baseoffset) {
        this.coreDataLength = coreData.length;
        int rowCnt = (this.coreDataLength - 1) / 16 + 1;
        this.rows = new CoreDumpRow[rowCnt];
        MFAddress adjustedaddress = address.add((long)baseoffset);
        int i = 0;
        while (i < rowCnt) {
            this.rows[i] = new CoreDumpRow(adjustedaddress, i * 16, coreData);
            ++i;
        }
    }

    public String[] getTextstring() {
        return this.textstring.split(sep);
    }

    public int getInitFlag() {
        return this.goFlag;
    }

    public MFAddress getStartAddr() {
        return this.address;
    }

    public Object[] getElements(Object inputElement) {
        if (this.rows == null) {
            this.rows = new CoreDumpRow[0];
        }
        return this.rows;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public byte[] getCoredata() {
        return this.coredata;
    }

    public int getCoreDataLength() {
        return this.coreDataLength;
    }

    public byte[] getSavecoredata() {
        return null;
    }

    public void setSavecoredata(byte[] savecoredata) {
    }

    public void dispose() {
        this.debugitem.removePropertyChangeListener(this);
    }

    public void propertyChange(final PropertyChangeEvent event) {
        Display display;
        String property = event.getProperty();
        if (property.equals("MEMORY_UPDATE") && (display = this.editor.getEditorSite().getShell().getDisplay()) != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList tabs = (ArrayList)event.getNewValue();
                    for (MemoryUpdateTable tab : tabs) {
                        CoreDumpRow[] coreDumpRowArray = CoreDumpRowList.this.rows;
                        int n = CoreDumpRowList.this.rows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CoreDumpRow row = coreDumpRowArray[n2];
                            if (CoreDumpRowList.this.ApplyUpdate(tab, row)) {
                                String hexcell = tab.getHexcell();
                                byte[] ebytes = new byte[hexcell.length() / 2];
                                HexUtil.HextoBytes((String)hexcell, (byte[])ebytes);
                                long rowaddr = row.getAddress().getLow();
                                long celladdr = tab.getCelladdr().getLow();
                                int offset = (int)(celladdr - rowaddr);
                                byte[] ba = row.getRowData();
                                ByteBuffer bb = ByteBuffer.wrap(ba);
                                bb.position(offset);
                                bb.put(ebytes);
                                row.setRowData(bb.array());
                                if (!CoreDumpRowList.this.tableViewer.getControl().isDisposed()) {
                                    CoreDumpRowList.this.tableViewer.refresh((Object)row, true);
                                }
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    protected boolean ApplyUpdate(MemoryUpdateTable tab, CoreDumpRow row) {
        MFAddress celladdr;
        MFAddress startAddr = row.getAddress();
        int len = row.getRowData().length;
        MFAddress endAddr = startAddr;
        if (len > 1) {
            endAddr = startAddr.add((long)(len - 1));
        }
        return startAddr.compareTo(celladdr = tab.getCelladdr()) <= 0 && endAddr.compareTo(celladdr) >= 0;
    }

    public int size() {
        return this.rows.length;
    }

    public void nullTreeObject() {
        this.treeobject = null;
    }
}

