/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.common.scanSource;
import java.math.BigDecimal;

public class scanPLI
extends scanSource
implements IScanSource {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private String[] titles = new String[]{"5668-", "5655-", "5688-"};
    private char dot = (char)46;
    private char bar = (char)124;
    private BigDecimal version = null;
    public static final BigDecimal VERSION41 = new BigDecimal("4.10").setScale(2);
    private static final int UNKNOWN = 0;
    private static final int BARS = 1;
    private static final int DOTS = 2;
    private static final int ALL = 3;
    private static final int FREE = 4;
    private int scantype = 0;
    private String regexstd = "[0-9\\s]+";
    private String regexdotted = "[0-9\\.\\s]+";
    private String regex;
    private int left;
    private int right;
    private int previoustatement = -1;

    public scanPLI(String version) {
        this.version = ((BigDecimal)Attribute.getValue("gt_m_plc", version)).setScale(2);
        this.regex = this.regexstd;
        switch (this.version.intValue()) {
            case 3: 
            case 4: {
                this.scantype = 3;
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.scantype = 4;
            }
        }
        this.setValues();
    }

    @Override
    public boolean isCandidate(String line) {
        if (line.length() >= this.stmtStart) {
            if (line.trim().equals("SOURCE LISTING")) {
                return false;
            }
            int i = 0;
            while (i < this.titles.length) {
                int index = line.indexOf(this.titles[i]);
                if (index >= 0 && index < 10) {
                    return false;
                }
                ++i;
            }
            String frontend = line.substring(0, this.left).trim();
            if (frontend.startsWith("0")) {
                return false;
            }
            boolean numeric = frontend.matches(this.regex);
            switch (this.scantype) {
                case 1: {
                    if (line.length() <= this.right || line.charAt(this.left) != line.charAt(this.right) || line.charAt(this.left) != this.bar) break;
                    return numeric;
                }
                case 2: {
                    if (line.length() <= this.right || line.charAt(this.left) != line.charAt(this.right) || line.charAt(this.left) != this.dot) break;
                    return numeric;
                }
                case 3: 
                case 4: {
                    return numeric;
                }
                default: {
                    if (line.length() > this.right && line.charAt(this.left) == line.charAt(this.right)) {
                        if (line.charAt(this.left) == this.dot) {
                            this.scantype = 2;
                            this.setValues();
                            return numeric;
                        }
                        if (line.charAt(this.left) == this.bar) {
                            this.scantype = 1;
                            this.setValues();
                            return numeric;
                        }
                    }
                    if (numeric) {
                        return numeric;
                    }
                    return frontend.trim().length() == 0;
                }
            }
        }
        return false;
    }

    @Override
    protected void setValues() {
        if (this.version != null) {
            this.seqStart = 0;
            this.seqEnd = this.seqStart + 10;
            this.stripblanks = true;
            this.regex = this.regexstd;
            switch (this.scantype) {
                case 4: {
                    this.stmtComment = 17;
                    this.stmtStart = 17;
                    this.seqEnd -= 2;
                    break;
                }
                case 3: {
                    this.regex = this.regexdotted;
                    this.stmtComment = 20;
                    this.stmtStart = 20;
                    break;
                }
                case 1: 
                case 2: {
                    this.stmtComment = 19;
                    this.stmtStart = 19;
                    break;
                }
                default: {
                    if (this.version.intValue() == 2) {
                        this.stmtComment = 17;
                        this.stmtStart = 17;
                        break;
                    }
                    this.stmtComment = 18;
                    this.stmtStart = 18;
                }
            }
            this.left = this.stmtComment - 1;
            this.right = this.left + 72;
        }
    }

    @Override
    public int getType() {
        return 128;
    }

    @Override
    public int getStatement(String line) {
        int statement = -1;
        if (this.isCandidate(line)) {
            statement = this.getSeqNumberpli(line, true, this.seqStart, this.seqEnd - this.seqStart);
            if (statement == -1) {
                statement = 0;
            }
            if (statement < 1) {
                return statement;
            }
            return this.testStatement(statement);
        }
        return statement;
    }

    private final int getSeqNumberpli(String s, boolean trim, int start, int length) {
        String[] numbers = s.substring(start, start + length).trim().split(" ");
        if (numbers.length > 0) {
            String number = numbers[0];
            try {
                return new BigDecimal(number).intValue();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private int testStatement(int statement) {
        if (statement > this.previoustatement) {
            this.previoustatement = statement;
            return statement;
        }
        return -1;
    }

    public boolean isStatement(String line) {
        return Character.isSpaceChar(line.charAt(this.seqStart - 1)) && line.length() >= this.stmtComment;
    }

    public int getScantype() {
        return this.scantype;
    }

    public void setScantype(int scantype) {
        this.scantype = scantype;
        this.setValues();
    }
}

