/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.scanPLI;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymFile;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class ProtsymOpen
extends UIJob {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected IFile ifile;
    private FileEditorInput input;
    private IEditorPart editor;
    private String offset;
    private IMemoryManager memoryManager;
    private Member member;

    public ProtsymOpen(IFile ifile, Member member) {
        super(ifile.getName());
        this.ifile = ifile;
        this.member = member;
        String value = member.getAttribute("offset");
        this.offset = value == null ? "" : value;
        this.memoryManager = member.getMemoryManager();
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        block8: {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            boolean visible = page.isEditorAreaVisible();
            this.input = new FileEditorInput(this.ifile);
            page.setEditorAreaVisible(true);
            try {
                this.editor = page.openEditor((IEditorInput)this.input, "com.ca.testingtools.protsym.lister");
                if (!visible) {
                    page.showView("org.eclipse.ui.views.ContentOutline");
                }
                if (!(this.editor instanceof ListerEditor)) break block8;
                ListerEditor lister = (ListerEditor)this.editor;
                lister.setPartProperty("node_key", this.member.getAttribute("node_key"));
                lister.setMemoryManager(this.memoryManager);
                if (this.offset.length() <= 0) break block8;
                int iOffset = Integer.decode("0x" + this.offset);
                ProtsymFile protsym = ProtsymFile.getInstance((IResource)this.ifile);
                if (protsym.getLanguage() == 128) {
                    String verString = protsym.getStore().getString("version");
                    try {
                        BigDecimal version = new BigDecimal(verString).setScale(2);
                        int result = version.compareTo(scanPLI.VERSION41);
                        if (result >= 0) {
                            iOffset += 8;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                lister.PositionPoint(iOffset, "");
            }
            catch (PartInitException e) {
                TT_ErrorDialog.openError(null, (String)"Start.", (String)HexUtil.getErrorText((Throwable)e));
                page.setEditorAreaVisible(visible);
                return new Status(4, "com.ca.testingtools.protsym", 4, HexUtil.getErrorText((Throwable)e), null);
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
    }
}

