/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLProfile
extends XMLDocument {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final long serialVersionUID = 7812049040127162339L;
    public static final String PREFIX = "com.ca.testingtools.";
    public static final String TOPENTRY = "TestingTools";
    public static final String SERVERENTRY = "com.ca.testingtools.server";
    public static final String PROFILE = "profile";
    public static final String PROFILENODE = "profilenode";
    public static final String NODECHILD = "nodechild";
    private Element top = null;

    public XMLProfile(File file) throws TTException {
        super(file);
    }

    public XMLProfile() {
    }

    public Element[] getServers() {
        this.getTop();
        NodeList elements = this.top.getElementsByTagName(SERVERENTRY);
        return this.getElements(elements);
    }

    private Element[] getElements(NodeList elements) {
        ArrayList<Element> list = new ArrayList<Element>(elements.getLength());
        int index = 0;
        while (index < elements.getLength()) {
            list.add((Element)elements.item(index));
            ++index;
        }
        return list.toArray(new Element[list.size()]);
    }

    public Element[] getProfiles(Element server) {
        NodeList elements = server.getElementsByTagName(PROFILE);
        return this.getElements(elements);
    }

    public Element getProfile(Element server, String profile) {
        NodeList elements = server.getElementsByTagName(PROFILE);
        int index = 0;
        while (index < elements.getLength()) {
            Element item = (Element)elements.item(index);
            String result = item.getAttribute("id");
            if (profile.equals(result)) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public Element getProfileNode(Element profile, String node) {
        NodeList elements = profile.getElementsByTagName(PROFILENODE);
        int index = 0;
        while (index < elements.getLength()) {
            Element item = (Element)elements.item(index);
            String result = item.getAttribute("id");
            if (node.equals(result)) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public Element[] getProfileNodes(Element profile) {
        NodeList elements = profile.getElementsByTagName(PROFILENODE);
        return this.getElements(elements);
    }

    public Element getTop() {
        if (this.top == null) {
            this.top = this.getRoot();
        }
        return this.top;
    }

    protected void setRoot() {
        NodeList list = this.document.getElementsByTagName(TOPENTRY);
        this.root = list.getLength() < 1 ? (Element)this.document.appendChild(this.document.createElement(TOPENTRY)) : (Element)list.item(0);
    }

    protected void newDocument() {
        super.newDocument();
        this.setRoot();
        this.document.getDocumentElement().normalize();
    }
}

