/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.MATException;
import com.ca.mat.XMLParser;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.dialogs.MATErrorDialog;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.ListingMetadataRowModel;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.subpages.ListingSubpage;
import com.ca.mat.xml.XMLRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListingServerCallback
implements ServerCallback {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    String csect;
    String dsn;
    StandbyDialog dialog;
    Integer statement;
    IAnalysisPagePresentation view;
    Display display;

    public ListingServerCallback(String csect, String dsn, Integer statement, IAnalysisPagePresentation view, StandbyDialog dialog, Display display) {
        this.csect = csect;
        this.dsn = dsn;
        this.statement = statement;
        this.view = view;
        this.dialog = dialog;
        this.display = display;
    }

    @Override
    public void processReply(final XMLRequest reply, MATServer server) {
        if (this.dialog != null) {
            this.dialog.close();
            Singletons.getServerProxy(this.display).removeDependentDialog(server, this.dialog);
        }
        if (reply.getErrorLevel() == 0 && reply.getAttachedFile() != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        InputStream is = reply.toInputStream();
                        try {
                            try {
                                new XMLParser(ListingServerCallback.this.dsn, is, ListingServerCallback.this.display);
                                ListingMetadataRowModel metadata = Singletons.getListingManager(ListingServerCallback.this.display).getMetadata(ListingServerCallback.this.dsn, ListingServerCallback.this.csect);
                                if (metadata.getFileState().isEmpty() || metadata.getFileState().equals("AVAILABLE")) {
                                    MATTableModel listingModel = Singletons.getListingManager(ListingServerCallback.this.display).createModel(ListingServerCallback.this.dsn, ListingServerCallback.this.csect, metadata, reply.getAttachedFile());
                                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(ListingSubpage.class, "", ListingServerCallback.this.dsn, 1, ListingServerCallback.this.view, "com.ca.mat.help.listing", listingModel);
                                    detachedView.setPresentationName(String.format("Listing for CSECT %s", ListingServerCallback.this.csect));
                                    detachedView.overrideSubtitle(String.format("Csect: %s Language: %s From: %s %s", ListingServerCallback.this.csect, metadata.getLanguage(), metadata.getDate(), metadata.getTime()));
                                    ListingSubpage page = (ListingSubpage)detachedView.getCurrentPage();
                                    if (page != null && page instanceof ListingSubpage) {
                                        page.setCsect(ListingServerCallback.this.csect);
                                        page.setSelectedStatement(ListingServerCallback.this.statement);
                                    }
                                    break block13;
                                }
                                ListingServerCallback.this.processError(reply, null, ListingServerCallback.this.csect, metadata.getFileState(), metadata.getListingDSN());
                            }
                            catch (Exception e) {
                                ListingServerCallback.this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                                try {
                                    is.close();
                                }
                                catch (IOException e2) {
                                    ListingServerCallback.this.log.log(Level.INFO, e2.getClass().getSimpleName(), e2);
                                }
                            }
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                ListingServerCallback.this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                            }
                        }
                    }
                }
            });
        } else {
            InputStream is = reply.toInputStream();
            String filestate = null;
            String listingDSN = null;
            try {
                new XMLParser(this.dsn, is, this.display);
                ListingMetadataRowModel metadata = Singletons.getListingManager(this.display).getMetadata(this.dsn, this.csect);
                if (metadata != null) {
                    filestate = metadata.getFileState();
                    listingDSN = metadata.getListingDSN();
                }
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            this.processError(reply, null, this.csect, filestate, listingDSN);
        }
    }

    @Override
    public void cancel(XMLRequest reply, MATServer server) {
        if (this.dialog != null) {
            this.dialog.close();
            Singletons.getServerProxy(this.display).removeDependentDialog(server, this.dialog);
        }
        this.deleteTempFile(reply);
    }

    @Override
    public boolean abort(XMLRequest reply, MATException e, MATServer server) {
        if (this.dialog != null) {
            this.dialog.close();
            Singletons.getServerProxy(this.display).removeDependentDialog(server, this.dialog);
        }
        InputStream is = reply.toInputStream();
        String filestate = null;
        String listingDSN = null;
        try {
            new XMLParser(this.dsn, is, this.display);
            ListingMetadataRowModel metadata = Singletons.getListingManager(this.display).getMetadata(this.dsn, this.csect);
            if (metadata != null) {
                filestate = metadata.getFileState();
                listingDSN = metadata.getListingDSN();
            }
        }
        catch (Exception ex) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), ex);
        }
        this.processError(reply, null, this.csect, filestate, listingDSN);
        this.deleteTempFile(reply);
        return true;
    }

    private void processError(XMLRequest reply, MATException e, String csect, String fileState, String listingDSN) {
        final ArrayList<String> detail = new ArrayList<String>();
        int rc = reply != null ? reply.getErrorLevel() : 20;
        if (rc > 0) {
            Element log;
            int i;
            NodeList list;
            String reasonText;
            String titleText;
            if (fileState != null) {
                if (fileState.equals("LISTING_MIGRATED")) {
                    titleText = "Listing migrated";
                    String string = String.format("Listing dataset %s has been migrated to archive. Use ISPF to retrieve the listing dataset.", listingDSN);
                }
                if (fileState.equals("NOTFOUND")) {
                    titleText = "Listing not registered";
                    reasonText = String.format("Listing for csect %s is not registered in CA MAT. ", csect);
                } else {
                    titleText = "Error downloading listing";
                    reasonText = String.format("Error requesting listing for csect %s", csect);
                    if (reply != null) {
                        list = reply.getLogs(null);
                        i = 0;
                        while (i < list.getLength()) {
                            log = (Element)list.item(i);
                            detail.addAll(reply.logtoList(log));
                            ++i;
                        }
                    }
                    if (detail.isEmpty() && e != null) {
                        detail.add(HexUtil.getErrorText(e));
                    }
                }
            } else {
                if (reply != null) {
                    list = reply.getLogs(null);
                    i = 0;
                    while (i < list.getLength()) {
                        log = (Element)list.item(i);
                        detail.addAll(reply.logtoList(log));
                        ++i;
                    }
                }
                if (detail.isEmpty() && e != null) {
                    detail.add(HexUtil.getErrorText(e));
                }
                titleText = "Error downloading listing";
                reasonText = String.format("Error requesting listing for csect %s", csect);
            }
            if (reasonText.isEmpty()) {
                reasonText = "An error occured on the server, see detail for explanation";
            }
            final String finalTitle = titleText;
            final String finalText = reasonText;
            final Exception exception = new Exception(reasonText);
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MATErrorDialog.openError(shell, finalTitle, finalText, exception, detail);
                }
            });
        }
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager(this.display).unregisterTempFile(reply.getAttachedFile());
        }
    }
}

