/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.MATException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.xml.XMLParserUtil;
import com.ca.mat.xml.XMLRequest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorProfileServerCallback
implements ServerCallback {
    Logger log;

    @Override
    public void processReply(XMLRequest reply, MATServer server) {
        this.log = Logging.getLogger(server.getDisplay());
        if (server.equals(Singletons.getServerProxy(server.getDisplay()).getConnectedServer())) {
            if (server.getStatus() == 1) {
                this.log.info("Connected to server " + server.getName());
            }
            server.setStatusText(2, "Connected");
            try {
                XMLParserUtil.parseXMLAttachment(reply, server);
            }
            catch (Exception e) {
                Logger log = Logging.getLogger(server.getDisplay());
                log.log(Level.INFO, "Failed to read monitor tree data", e);
            }
        }
    }

    @Override
    public void cancel(XMLRequest reply, MATServer server) {
        if (server.getStatus() == 1 || server.getStatus() == 4) {
            if (server.equals(Singletons.getServerProxy(server.getDisplay()).getConnectedServer())) {
                server.setStatusText(2, "Connected");
            } else {
                server.setStatusText(2, "Unknown");
            }
        }
        this.deleteTempFile(reply);
    }

    @Override
    public boolean abort(XMLRequest reply, MATException e, MATServer server) {
        if (server.getStatus() == 4) {
            if (server.equals(Singletons.getServerProxy(server.getDisplay()).getConnectedServer())) {
                server.setStatusText(2, "Connected");
            } else {
                server.setStatusText(2, "Unknown");
            }
            this.deleteTempFile(reply);
            return true;
        }
        if (server.getStatus() == 1) {
            if (server.equals(Singletons.getServerProxy(server.getDisplay()).getConnectedServer())) {
                server.setStatusText(2, "Connected");
            } else {
                server.setStatusText(2, "Unknown");
            }
            this.deleteTempFile(reply);
        }
        return false;
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager().unregisterTempFile(reply.getAttachedFile());
        }
    }
}

