/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MQQueueActivityRowModel;
import com.ca.mat.rowmodels.MQViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.subpages.QueueActivitySubpage;
import com.ca.mat.views.subpages.QueueManagerActivitySubpage;
import com.ca.mat.views.subpages.TextDisplayTableFormatSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class MQViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (commandId.equals("com.ca.mat.commands.analysis.mqview.codedetails")) {
            HashMap<String, Object[]> codeViewArgs = new HashMap<String, Object[]>();
            ArrayList<String[]> codeViewTitles = new ArrayList<String[]>();
            AnalysisPageCalculated mqPage = (AnalysisPageCalculated)page;
            codeViewArgs.putAll(mqPage.getFilterExpressions());
            codeViewTitles.addAll(mqPage.getTitleExpressions());
            if (obj instanceof MQViewRowModel) {
                MQViewRowModel rowModel = (MQViewRowModel)obj;
                codeViewArgs.put("Statement", new Object[]{rowModel.getQueueManager()});
                codeViewTitles.add(new String[]{"Queue Manager", rowModel.getQueueManager()});
            } else if (obj instanceof MQQueueActivityRowModel) {
                String manager = ((QueueActivitySubpage)page).getQueueManager();
                MQQueueActivityRowModel rowModel = (MQQueueActivityRowModel)obj;
                codeViewArgs = new HashMap();
                codeViewArgs.put("Statement", new Object[]{manager});
                codeViewTitles.add(new String[]{"Queue Manager", manager});
                String queueName = rowModel.getQueue();
                if (queueName.trim().equalsIgnoreCase("not available")) {
                    queueName = "";
                }
                codeViewArgs.put("outddn", new Object[]{rowModel.getQQNC8()});
                codeViewTitles.add(new String[]{"Queue", queueName});
                codeViewArgs.put("majnm", new Object[]{rowModel.getRequestType()});
                codeViewTitles.add(new String[]{"Request Type", rowModel.getRequestType()});
            } else {
                throw new RuntimeException(String.format("Command %1$s invoked on unsupported class: %2$s", commandId, obj.getClass().toString()));
            }
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            model = model.filterBy(codeViewArgs);
            model = AnalysisUtils.calculateCodeView(model, dsn, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CodeViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.codedetail", model);
            String partName = "Code Details:";
            for (String[] entry : codeViewTitles) {
                partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
            }
            detachedView.setPresentationName(partName);
            AnalysisPage newPage = detachedView.getCurrentPage();
            if (newPage != null && newPage instanceof CodeViewPage) {
                CodeViewPage codeViewPage = (CodeViewPage)newPage;
                codeViewPage.setFilterExpressions(codeViewArgs);
                codeViewPage.setTitleExpressions(codeViewTitles);
            }
            if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                ((AnalysisPageCalculated)newPage).refreshHeader();
            }
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.mqview.queuemanagerinfo")) {
            if (!(obj instanceof MQViewRowModel)) {
                return null;
            }
            String queueManager = ((MQViewRowModel)obj).getQueueManager();
            String section = "MQ Queue Manager " + queueManager;
            MATTableModel result = Singletons.getAnalysisManager().getModel(dsn, section, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "Queue Manager Information ", dsn, type, presentation, "com.ca.mat.help.queuemanagerinfo", result);
            detachedView.setPresentationName(String.format("Queue Manager Information: %s", queueManager));
        } else if (commandId.equals("com.ca.mat.commands.analysis.mqview.queueinfo")) {
            String queueManager = ((QueueActivitySubpage)page).getQueueManager();
            MQQueueActivityRowModel rowModel = (MQQueueActivityRowModel)obj;
            String section = "MQ Queue Info " + queueManager + "," + rowModel.getQQNC8() + "," + rowModel.getRequestType();
            MATTableModel result = Singletons.getAnalysisManager().getModel(dsn, section, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "Queue Information ", dsn, type, presentation, "com.ca.mat.help.queueinfo", result);
            detachedView.setPresentationName(String.format("Queue Information: Queue Manager: %1$s, Queue: %2$s", queueManager, rowModel.getQueue()));
        } else if (commandId.equals("com.ca.mat.commands.analysis.mqview.queueactivity")) {
            HashMap<String, Object[]> viewArgs = new HashMap<String, Object[]>();
            ArrayList<String[]> viewTitles = new ArrayList<String[]>();
            QueueManagerActivitySubpage mqPage = (QueueManagerActivitySubpage)page;
            viewArgs.putAll(mqPage.getFilterExpressions());
            viewTitles.addAll(mqPage.getTitleExpressions());
            if (!(obj instanceof MQViewRowModel)) {
                return null;
            }
            String queueManager = ((MQViewRowModel)obj).getQueueManager();
            Object[] tranId = mqPage.getFilterExpressions().get("Transaction");
            String section = tranId != null ? "MQ-Qmngr-Activity " + queueManager + " Tran " + tranId[0].toString() : "MQ Qmngr Activity " + queueManager;
            viewTitles.add(new String[]{"QueueManager", queueManager});
            MATTableModel result = Singletons.getAnalysisManager().getModel(dsn, section, type);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(QueueActivitySubpage.class, "Queue Activity", dsn, type, presentation, "com.ca.mat.help.mqqueueactivityview", result);
            ((QueueActivitySubpage)detachedView.getCurrentPage()).setQueueManager(queueManager);
            AnalysisPage newPage = detachedView.getCurrentPage();
            if (newPage != null && newPage instanceof QueueActivitySubpage) {
                QueueActivitySubpage subPage = (QueueActivitySubpage)newPage;
                subPage.setFilterExpressions(viewArgs);
                subPage.setTitleExpressions(viewTitles);
            }
            ((QueueActivitySubpage)newPage).refreshHeader();
            detachedView.setPresentationName(String.format("Queue Activity: Queue manager:%s", queueManager));
        }
        return null;
    }
}

