/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class USSViewFunctionsRowModel
extends MATTableRow
implements IXmlAttrHandler,
Cloneable,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    public static final String DISPLAY_MODE_THREAD = "display_mode_thread";
    public static final String DISPLAY_MODE_FUNCTION = "display_mode_function";
    public static final String GROUP_BY_THREAD = "group_by_thread";
    public static final String GROUP_BY_FUNCTION = "group_by_function";
    public static final String FILTER_PROCESSID = "procesid";
    public static final String FILTER_THREADID = "threadid";
    public static final String FILTER_WAIT_TYPE_1 = "twaittp1";
    public static final String FILTER_WAIT_TYPE_2 = "twaittp2";
    private String procesid = "";
    private String threadid = "";
    private Integer twaittp1 = null;
    private Integer twaittp2 = null;
    private String tfuncton = "";
    private String tmvsprog = "";
    private Double tact = null;
    private Double twat = null;
    private Double ttot = null;
    private String displayMode = null;

    public USSViewFunctionsRowModel(MATTableModel model) {
        super(model);
    }

    public USSViewFunctionsRowModel() {
        this(null);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        USSViewFunctionsRowModel result = new USSViewFunctionsRowModel(model);
        String value = attr.getValue("PROCESID");
        if (value != null) {
            result.procesid = value.trim();
        }
        if ((value = attr.getValue("THREADID")) != null) {
            result.threadid = value.trim();
        }
        if ((value = attr.getValue("TWAITTP1")) != null) {
            result.twaittp1 = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TWAITTP2")) != null) {
            result.twaittp2 = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TFUNCTON")) != null) {
            result.tfuncton = value.trim();
        }
        if ((value = attr.getValue("TMVSPROG")) != null) {
            result.tmvsprog = value.trim();
        }
        if ((value = attr.getValue("TACT")) != null) {
            result.tact = Double.valueOf(value);
        }
        if ((value = attr.getValue("TWAT")) != null) {
            result.twat = Double.valueOf(value);
        }
        if ((value = attr.getValue("TTOT")) != null) {
            result.ttot = Double.valueOf(value);
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        if (this.displayMode == null) {
            throw new RuntimeException("displayMode not set in USS row - check correspoding handler or analysistabbedview method");
        }
        if (this.displayMode.equals(DISPLAY_MODE_THREAD)) {
            return new Object[]{this.threadid, this.tact, this.twat, this.ttot};
        }
        if (this.displayMode.equals(DISPLAY_MODE_FUNCTION)) {
            return new Object[]{this.tfuncton, this.tmvsprog, this.tact, this.twat, this.ttot};
        }
        throw new RuntimeException(String.format("(%1$s) Unknown displayMode in getArray() (%2$s)", this.getClass().toString(), this.displayMode));
    }

    public String getThreadId() {
        return this.threadid;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public USSViewFunctionsRowModel clone() {
        USSViewFunctionsRowModel result = new USSViewFunctionsRowModel(this.model);
        result.procesid = this.procesid;
        result.tact = this.tact;
        result.tfuncton = this.tfuncton;
        result.threadid = this.threadid;
        result.tmvsprog = this.tmvsprog;
        result.ttot = this.ttot;
        result.twaittp1 = this.twaittp1;
        result.twaittp2 = this.twaittp2;
        result.twat = this.twat;
        result.displayMode = this.displayMode;
        return result;
    }

    public void addRow(USSViewFunctionsRowModel ussRow) {
        this.tact = this.tact + ussRow.tact;
        this.twat = this.twat + ussRow.twat;
        this.ttot = this.ttot + ussRow.ttot;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (FILTER_PROCESSID.equals(fieldName)) {
            return this.procesid != null && this.procesid.equals(value);
        }
        if (FILTER_THREADID.equals(fieldName)) {
            return this.threadid != null && this.threadid.equals(value);
        }
        if (FILTER_WAIT_TYPE_1.equals(fieldName)) {
            return this.twaittp1 != null && this.twaittp1.equals(value);
        }
        if (FILTER_WAIT_TYPE_2.equals(fieldName)) {
            return this.twaittp2 != null && this.twaittp2.equals(value);
        }
        return false;
    }

    public String getFunction() {
        return this.tfuncton;
    }

    public Integer getTType1() {
        return this.twaittp1;
    }

    public Integer getTType2() {
        return this.twaittp2;
    }

    public String getProcessId() {
        return this.procesid;
    }

    public Double getActive() {
        return this.tact;
    }

    public Double getTotal() {
        return this.ttot;
    }

    public Double getWait() {
        return this.twat;
    }
}

