/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.views.pages.AnalysisPage;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;

public class ChartPage
extends AnalysisPage {
    static final String ID = "com.ca.mat.context";
    String dsn;
    int type;
    JFreeChart chart;
    Composite composite;
    Label barGraph;
    Label pieGraph;

    @Override
    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    @Override
    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 4);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.barGraph = new Label(this.composite, 4);
        GridData gData = new GridData(16384, 128, false, false);
        gData.widthHint = 800;
        gData.heightHint = 400;
        this.barGraph.setLayoutData((Object)gData);
        this.pieGraph = new Label(this.composite, 4);
        gData = new GridData(0, 128, false, false);
        gData.widthHint = 400;
        gData.heightHint = 400;
        this.pieGraph.setLayoutData((Object)gData);
        this.recalcGraph();
    }

    public void recalcGraph() {
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, "Code View", this.type);
        if (model == null) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "TimeView", this.type);
            model = AnalysisUtils.calculateCodeView(model, this.dsn, this.type);
            Singletons.getAnalysisManager().put(this.dsn, "Code View", model, this.type);
        }
        String[] xAxis = new String[]{"Active", "Wait", "Total"};
        String[] yAxis = new String[model.getRows().length];
        double[][] data = new double[3][model.getRows().length];
        int i = 0;
        MATTableRow[] mATTableRowArray = model.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            CodeViewRowModel codeRow = (CodeViewRowModel)row;
            yAxis[i] = String.valueOf(codeRow.getModule()) + "(" + codeRow.getCSECT() + ")";
            data[0][i] = codeRow.getActive();
            data[1][i] = codeRow.getWait();
            data[2][i] = codeRow.getTotal();
            ++i;
            ++n2;
        }
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset((Comparable[])xAxis, (Comparable[])yAxis, (double[][])data);
        this.chart = ChartFactory.createBarChart((String)"Delays by Module/Csect", (String)"Type", (String)"Module(Csect)", (CategoryDataset)dataset);
        Image image1 = new Image((Device)Display.getCurrent(), ChartPage.convertToSWT(this.chart.createBufferedImage(800, 400)));
        this.barGraph.setImage(image1);
        PieDataset pieDataset = DatasetUtilities.createPieDatasetForRow((CategoryDataset)dataset, (Comparable)((Object)"Total"));
        this.chart = ChartFactory.createPieChart((String)"Total Delay by Csect", (PieDataset)pieDataset);
        Image image2 = new Image((Device)Display.getCurrent(), ChartPage.convertToSWT(this.chart.createBufferedImage(400, 400)));
        this.pieGraph.setImage(image2);
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public void setMenu(Menu popup) {
        this.composite.setMenu(popup);
    }

    @Override
    public void setDSN(String dsn) {
        this.dsn = dsn;
    }

    @Override
    public String getDSN() {
        return this.dsn;
    }

    @Override
    public String getContextHelpId() {
        return null;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        if (this.composite != null && !this.composite.isDisposed()) {
            this.recalcGraph();
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return ID;
    }

    static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }
}

