/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.connect.MATFamily;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerJob;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;

public class ServerMultiJob
extends Job
implements IJobChangeListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private List<ServerJob> jobs = new ArrayList<ServerJob>();
    ServerJob running = null;
    MATServer server;
    boolean canceled = false;

    public ServerMultiJob(String name, MATServer server) {
        super(name);
        this.server = server;
    }

    public void addJob(ServerJob job, boolean required) {
        if (this.server != job.getServer()) {
            throw new IllegalArgumentException("Server mismatch");
        }
        this.jobs.add(job);
        job.setRequired(required);
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    protected void canceling() {
        this.canceled = true;
        if (this.running != null) {
            this.running.canceling();
        }
    }

    public boolean belongsTo(Object family) {
        if ("com.ca.mat".equals(family.toString())) {
            return true;
        }
        if (family instanceof MATServer && this.server.equals(family)) {
            return true;
        }
        if (family instanceof MATFamily && this.running != null) {
            return this.running.belongsTo(family);
        }
        return false;
    }

    protected IStatus run(IProgressMonitor monitor) {
        for (ServerJob job : this.jobs) {
            if (this.canceled) {
                return Status.CANCEL_STATUS;
            }
            this.running = job;
            IStatus status = job.run(monitor);
            this.running = null;
            if (status.getMessage().equals("Server error") && job.isRequired()) {
                return status;
            }
            if (!status.matches(8)) continue;
            return status;
        }
        return Status.OK_STATUS;
    }
}

