/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class LinkSuggestionsRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String MODULE_ID = "tmodule";
    Logger log = Logger.getLogger(this.getClass().getName());
    private String tmodule = "";
    private String csect = "";
    private String offset = "";
    private String length = "";
    private Double pct = null;

    public LinkSuggestionsRowModel(MATTableModel model) {
        this(model, "", "");
    }

    public LinkSuggestionsRowModel(MATTableModel model, String module, String csect) {
        super(model);
        this.tmodule = module;
        this.csect = csect;
        this.pct = 0.0;
    }

    public LinkSuggestionsRowModel() {
        this(null, null, null);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        LinkSuggestionsRowModel result = new LinkSuggestionsRowModel(model);
        String value = attr.getValue("TMODULE");
        if (value != null) {
            result.tmodule = value.trim();
        }
        if ((value = attr.getValue("CSECT")) != null) {
            result.csect = value.trim();
        }
        if ((value = attr.getValue("OFFSET")) != null) {
            result.offset = value.trim();
        }
        if ((value = attr.getValue("LENGTH")) != null) {
            result.length = value.trim();
        }
        if ((value = attr.getValue("PCT")) != null) {
            result.pct = Double.valueOf(value);
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.csect, this.offset, this.length, this.pct};
    }

    public void addPercent(double percent) {
        this.pct = this.pct == null ? percent : this.pct + percent;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (MODULE_ID.equals(fieldName)) {
            return this.tmodule != null && this.tmodule.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public Double getPercent() {
        return this.pct;
    }

    public String getModule() {
        return this.tmodule;
    }

    public String getCsect() {
        return this.csect;
    }
}

