/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IMenuService;

public abstract class AnalysisPageBasic
extends AnalysisPage
implements IDoubleClickListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private IMATTableViewer viewer;
    protected int type;
    protected String dsn;
    private Composite wrapper;
    private ISelection selection;
    private ISelectionChangedListener selectionChangeListener;
    private HelpListener helpListener;
    private FocusListener focusListener;

    @Override
    public final void createControl(Composite parent) {
        this.wrapper = new Composite(parent, 4);
        this.wrapper.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 4, true, true);
        this.wrapper.setLayoutData((Object)data);
        this.createHeaderPart(this.wrapper);
        this.viewer = MATTableViewerFactory.createNew(this.wrapper);
        this.setUpViewer(this.viewer);
        if (!this.viewer.getControl().isDisposed()) {
            Singletons.getViewerSynchronizationManager().addViewer(this.getViewerMementoType(), this.viewer);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), this.getContextHelpId());
        }
        this.selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AnalysisPageBasic.this.selection = event.getSelection();
            }
        };
        this.viewer.addSelectionChangedListener(this.selectionChangeListener);
        this.helpListener = new HelpListener(){

            public void helpRequested(HelpEvent e) {
            }
        };
        this.viewer.addHelpListener(this.helpListener);
        final AnalysisPageBasic inst = this;
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent event) {
                Singletons.getAnalysisManager().analysisPageFocused(inst);
            }

            public void focusLost(FocusEvent event) {
            }
        };
        this.viewer.getControl().addFocusListener(this.focusListener);
        this.viewer.addDoubleClickListener(this);
        this.wrapper.addFocusListener(this.focusListener);
    }

    public void createHeaderPart(Composite Parent) {
    }

    public void setModel(MATTableModel model) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            if (model != null && model.equals(this.viewer.getCATableModel())) {
                return;
            }
            this.viewer.setCATableModel(model);
            this.viewer.getTable().select(0);
        }
    }

    public MATTableModel getModel() {
        return this.viewer.getCATableModel();
    }

    protected abstract void setUpViewer(IMATTableViewer var1);

    public final IMATTableViewer getViewer() {
        return this.viewer;
    }

    @Override
    public Control getControl() {
        return this.wrapper;
    }

    @Override
    public void setMenu(Menu popup) {
        this.viewer.getControl().setMenu(popup);
    }

    @Override
    public void dispose() {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(this.selectionChangeListener);
            this.viewer.removeHelpListener(this.helpListener);
            this.selectionChangeListener = null;
            this.helpListener = null;
        }
        Singletons.getViewerSynchronizationManager().removeViewer(this.viewer);
        this.viewer = null;
        super.dispose();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    @Override
    public final void setDSN(String dsn) {
        this.dsn = dsn;
    }

    @Override
    public final String getDSN() {
        return this.dsn;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public abstract String getContextHelpId();

    public void setContextHelpId(String contextHelpId) {
    }

    @Override
    public abstract String getId();

    protected abstract String getViewerMementoType();

    protected String getAutonavigationCommandId() {
        return null;
    }

    public String getAdditionalTitleText() {
        return "";
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.getAutonavigationCommandId() == null) {
            return;
        }
        Singletons.getAnalysisManager().analysisPageFocused(this);
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService comm = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = comm.getCommand(this.getAutonavigationCommandId());
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        MenuManager menuMgr = new MenuManager("menu", "popup:com.ca.mat.views.analysisdetachedview?after=additions");
        menuService.populateContributionManager((ContributionManager)menuMgr, "popup:com.ca.mat.views.analysisview");
        IContributionItem contribItem = menuMgr.find(command.getId());
        if (contribItem != null) {
            contribItem.isVisible();
        }
        try {
            if (command.isEnabled()) {
                service.executeCommand(this.getAutonavigationCommandId(), null);
            }
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Autonavigation failed", e);
        }
    }
}

