/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CallStackPage;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.DB2Page;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.subpages.CallerIdSubpage;
import com.ca.mat.views.subpages.DataDetailSubpage;
import com.ca.mat.views.subpages.IMSStatementSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class TranViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (obj instanceof TranViewRowModel) {
            TranViewRowModel rowModel = (TranViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.codedetails")) {
                HashMap<String, Object[]> codeViewArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> codeViewTitles = new ArrayList<String[]>();
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    codeViewArgs.put("Transaction", new Object[]{""});
                } else {
                    codeViewArgs.put("Transaction", new Object[]{tranName});
                }
                codeViewTitles.add(new String[]{"Transaction", rowModel.getTransactionName()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = model.filterBy(codeViewArgs);
                model = AnalysisUtils.calculateCodeView(model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CodeViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.codedetail", model);
                String partName = "Code Details:";
                for (String[] entry : codeViewTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CodeViewPage) {
                    CodeViewPage codeViewPage = (CodeViewPage)newPage;
                    codeViewPage.setFilterExpressions(codeViewArgs);
                    codeViewPage.setTitleExpressions(codeViewTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.callerid")) {
                HashMap<String, Object[]> callerIdArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> callerIdTitles = new ArrayList<String[]>();
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    callerIdArgs.put("Transaction", new Object[]{""});
                } else {
                    callerIdArgs.put("Transaction", new Object[]{tranName});
                }
                callerIdTitles.add(new String[]{"Transaction", rowModel.getTransactionName()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                MATTableModel modelCs = Singletons.getAnalysisManager().getModel(dsn, "Call Stack Info", type);
                model = model.filterBy(callerIdArgs);
                model = AnalysisUtils.calculateCallerId(model, dsn, type, Display.getCurrent());
                model = AnalysisUtils.addCallStackToCallerId(model, modelCs, tranName);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CallerIdSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.callerid", model);
                String partName = "CallerId:";
                for (String[] entry : callerIdTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CallerIdSubpage) {
                    CallerIdSubpage callerIdPage = (CallerIdSubpage)newPage;
                    callerIdPage.setFilterExpressions(callerIdArgs);
                    callerIdPage.setTitleExpressions(callerIdTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.delaydetails")) {
                HashMap<String, Object[]> delayViewArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> delayViewTitles = new ArrayList<String[]>();
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    delayViewArgs.put("Transaction", new Object[]{""});
                } else {
                    delayViewArgs.put("Transaction", new Object[]{tranName});
                }
                delayViewTitles.add(new String[]{"Transaction", rowModel.getTransactionName()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = model.filterBy(delayViewArgs);
                model = AnalysisUtils.calculateDelayView(model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DelayViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.delaydetail", model);
                String partName = "Delay Detail:";
                for (String[] entry : delayViewTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof DelayViewPage) {
                    DelayViewPage delayPage = (DelayViewPage)newPage;
                    delayPage.setFilterExpressions(delayViewArgs);
                    delayPage.setTitleExpressions(delayViewTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.datadetails")) {
                String section = rowModel.getDataDetailSection();
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DataDetailSubpage.class, section, dsn, type, presentation);
                detachedView.setPresentationName(String.format("Data Detail: Transaction %s", rowModel.getTransactionName()));
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.imsstatementdetailsline")) {
                String section = "IMS Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    model = model.filterBy("tranid", rowModel.getTransactionName());
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                detachedView.setPresentationName(String.format("IMS Statements: Transaction %s", rowModel.getTransactionName()));
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.db2statementdetails")) {
                String section = "DB2 View";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    model = model.filterBy("Correlation", rowModel.getTransactionName());
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DB2Page.class, section, dsn, type, presentation, "com.ca.mat.help.db2view", model);
                detachedView.setPresentationName(String.format("DB2 Statements: Transaction %s", rowModel.getTransactionName()));
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.tranview.callstack")) {
                HashMap<String, Object[]> callStackArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> callStackTitles = new ArrayList<String[]>();
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    callStackArgs.put("", new Object[]{""});
                } else {
                    callStackArgs.put("", new Object[]{tranName});
                }
                callStackTitles.add(new String[]{"Transaction", rowModel.getTransactionName()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "Call Stack Info", type);
                MATTableModel modelTran = Singletons.getAnalysisManager().getModel(dsn, "TranView", type);
                model = model.filterBy(callStackArgs);
                model = AnalysisUtils.calculateCallStack(model, dsn, type, Display.getCurrent(), ((TranViewRowModel)obj).getTransactionName());
                model = AnalysisUtils.initializeElapsed(model, modelTran);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CallStackPage.class, "", dsn, type, presentation, CallStackPage.CONTEXT_HELP_ID, model);
                String partName = "CallStack:";
                for (String[] entry : callStackTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CallStackPage) {
                    CallStackPage callStackPage = (CallStackPage)newPage;
                    callStackPage.setFilterExpressions(callStackArgs);
                    callStackPage.setTitleExpressions(callStackTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
        }
        return null;
    }
}

