/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.logging;

import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MATLogHandler
extends FileHandler
implements IPropertyChangeListener {
    private static final String LOG_LEVEL = "loglevels";
    private static String logFormat = String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator") + "!ENTRY com.ca.mat %s %s %s %s" + System.getProperty("line.separator") + "!MESSAGE %s";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private String userId;

    public MATLogHandler(String file, String userId) throws IOException {
        super(file, 10240, 5, true);
        Level level;
        this.userId = userId;
        IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();
        String levelStr = store.getString(LOG_LEVEL);
        try {
            level = Level.parse(levelStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            level = Level.WARNING;
            store.setDefault(LOG_LEVEL, level.getName());
        }
        this.setLevel(level);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void close() throws SecurityException {
        super.close();
    }

    @Override
    public void flush() {
        super.flush();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String levelStr;
        String property = event.getProperty();
        if (LOG_LEVEL.equals(property) && (levelStr = (String)event.getNewValue()) != null) {
            try {
                Level level = Level.parse(levelStr);
                this.setLevel(level);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void createSessionHeader() {
        Date date = new Date();
        String sessionMessage = String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator") + "!SESSION %s %s -----------------------------------------------";
        sessionMessage = String.format(sessionMessage, dateFormat.format(date), timeFormat.format(date));
        LogRecord initialRecord = new LogRecord(Level.SEVERE, sessionMessage);
        super.publish(initialRecord);
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        Logging.displayLogRecord(this.userId, record);
        Level level = record.getLevel();
        if (level == Level.ALL) {
            return;
        }
        int statusInt = level == Level.SEVERE ? 4 : (level == Level.WARNING ? 2 : (level == Level.INFO ? 1 : 0));
        Throwable thrown = record.getThrown();
        record.setThrown(null);
        String message = this.getFormatter().format(record);
        Date date = new Date(record.getMillis());
        String recordString = String.format(logFormat, statusInt, level.intValue(), dateFormat.format(date), timeFormat.format(date), message);
        LogRecord logFileRecord = new LogRecord(level, recordString);
        logFileRecord.setThrown(thrown);
        super.publish(logFileRecord);
    }
}

