/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.USSViewFunctionsRowModel;
import java.util.logging.Logger;

public class USSViewRowModel
extends MATTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private String initcmd = "";
    private String procesid = "";
    private Double uactive = null;
    private Double utotal = null;
    private Double uwait = null;

    public USSViewRowModel(MATTableModel model, String procesid, String initcmd, Double uactive, Double utotal, Double uwait) {
        super(model);
        this.procesid = procesid;
        this.initcmd = initcmd;
        this.uactive = uactive;
        this.utotal = utotal;
        this.uwait = uwait;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.procesid, this.initcmd, this.uactive, this.uwait, this.utotal};
    }

    public String getProcessId() {
        return this.procesid;
    }

    public Double getAct() {
        return this.uactive;
    }

    public Double getWait() {
        return this.uwait;
    }

    public Double getTot() {
        return this.utotal;
    }

    public void addRow(USSViewFunctionsRowModel ussViewFunctionRow) {
        this.uactive = this.uactive + ussViewFunctionRow.getActive();
        this.utotal = this.utotal + ussViewFunctionRow.getTotal();
        this.uwait = this.uwait + ussViewFunctionRow.getWait();
    }

    public void addPercent(double active, double wait, double total) {
        this.uactive = this.uactive == null ? active : this.uactive + active;
        this.uwait = this.uwait == null ? wait : this.uwait + wait;
        this.utotal = this.utotal == null ? total : this.utotal + total;
    }
}

