/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.MATException;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallStackInfoRowModel;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.IPageWithModes;
import com.ca.mat.views.pages.PageWithModesContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CallStackPage
extends AnalysisPageCalculated
implements IPageWithModes {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = CallStackPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private static final String ID_ROOT = "com.ca.mat.pages.callview";
    public static final String ID_CSECT = "com.ca.mat.pages.callview.csect";
    public static final String ID_MODULE = "com.ca.mat.pages.callview.module";
    public static final String ID_PSEUDO = "com.ca.mat.pages.callview.pseudo";
    public static String CONTEXT_HELP_ID = "com.ca.mat.help.codeview";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.callview.histogram";
    public static final String TTASKID = "ttaskid";
    public static final String SECTION_NAME = "Call Stack Info";
    private String modeType = CodeViewRowModel.TYPE_CSECT;
    private String taskId = null;
    private String transactionId = null;
    private String taskName = null;
    private String stmtNum;
    private String dbrm;
    private String currentMode = CodeViewRowModel.TYPE_CSECT;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        if (this.modeType.equals(CallStackInfoRowModel.TYPE_CSECT)) {
            viewer.addColumn("Task", 5, "Task", 1, false, false);
            viewer.addColumn("SEQ", 5, "SEQ", 2, true, false);
            viewer.addColumn("Tran", 5, "Tran", 1, false, false);
            viewer.addColumn("Term", 5, "Term", 1, false, false);
            viewer.addColumn("Module", 5, "Module", 1, true, false);
            viewer.addColumn("Count", 3, "Count", 2, true, true);
            viewer.addColumn("Elapsed", 3, "Elapsed", 2, true, true);
            viewer.addColumn("Elapsed Avg", 3, "Elapsed Avg", 2, true, true);
            viewer.setDefaultSortColumn(0);
            viewer.setDefaultSortDirection(1024);
        } else if (this.modeType.equals(CallStackInfoRowModel.TYPE_MODULE)) {
            viewer.addColumn("Task", 5, "Task", 1, false, false);
            viewer.addColumn("SEQ", 5, "SEQ", 2, true, false);
            viewer.addColumn("Tran", 5, "Tran", 1, false, false);
            viewer.addColumn("Term", 5, "Term", 1, false, false);
            viewer.addColumn("Module", 5, "Module", 1, true, false);
            viewer.addColumn("Count", 3, "Count", 2, true, true);
            viewer.addColumn("Elapsed", 3, "Elapsed", 2, true, true);
            viewer.addColumn("Elapsed Avg", 3, "Elapsed Avg", 2, true, true);
            viewer.setDefaultSortColumn(0);
            viewer.setDefaultSortDirection(1024);
        } else if (this.modeType.equals(CallStackInfoRowModel.TYPE_PSEUDO)) {
            viewer.addColumn("Task", 5, "Task", 1, false, false);
            viewer.addColumn("SEQ", 5, "SEQ", 2, true, false);
            viewer.addColumn("Tran", 5, "Tran", 1, false, false);
            viewer.addColumn("Term", 5, "Term", 1, false, false);
            viewer.addColumn("Module", 5, "Module", 1, true, false);
            viewer.addColumn("Count", 3, "Count", 2, true, true);
            viewer.addColumn("Elapsed", 3, "Elapsed", 2, true, true);
            viewer.addColumn("Elapsed Avg", 3, "Elapsed Avg", 2, true, true);
            viewer.setDefaultSortColumn(0);
            viewer.setDefaultSortDirection(1024);
        } else {
            throw new RuntimeException("mode for Call Stack is not set");
        }
    }

    @Override
    public String getId() {
        if (CodeViewRowModel.TYPE_CSECT.equals(this.modeType)) {
            return ID_CSECT;
        }
        if (CodeViewRowModel.TYPE_MODULE.equals(this.modeType)) {
            return ID_MODULE;
        }
        if (CodeViewRowModel.TYPE_PSEUDO.equals(this.modeType)) {
            return ID_PSEUDO;
        }
        throw new MATException("Invalid CodeView mode: " + this.modeType);
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public void setContextHelpId(String contextHelpId) {
        CONTEXT_HELP_ID = contextHelpId;
    }

    @Override
    protected String getViewerMementoType() {
        String VIEWER_MEMENTO_TYPE = null;
        if (this.modeType.equals(CodeViewRowModel.TYPE_CSECT)) {
            VIEWER_MEMENTO_TYPE = "pages.codeview.csect.viewer";
        } else if (this.modeType.equals(CodeViewRowModel.TYPE_MODULE)) {
            VIEWER_MEMENTO_TYPE = "pages.codeview.module.viewer";
        } else if (this.modeType.equals(CodeViewRowModel.TYPE_PSEUDO)) {
            VIEWER_MEMENTO_TYPE = "pages.codeview.pseudo.viewer";
        }
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }

    public void setModeType(String modeType) {
        this.modeType = modeType;
    }

    public String getModeType() {
        return this.modeType;
    }

    @Override
    public String getAdditionalTitleText() {
        return "Mode: " + this.modeType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        this.setFilterValue("Task Id", taskId);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        this.setFilterValue("Transaction", transactionId);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setDB2Id(String dbrm, String stmtNum) {
        this.dbrm = dbrm;
        this.stmtNum = stmtNum;
        this.setFilterValue("tdbrm", dbrm);
        this.setFilterValue("tdbrmnr", stmtNum);
    }

    public String getDBRM() {
        return this.dbrm;
    }

    public String getDBRMNR() {
        return this.stmtNum;
    }

    @Override
    public PageWithModesContainer changeMode(String newMode) {
        this.currentMode = newMode;
        Map<String, Object[]> activeInternalFilters = this.getFilterExpressions();
        HashMap<String, Object[]> newFilters = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object[]> entry : activeInternalFilters.entrySet()) {
            newFilters.put(entry.getKey(), entry.getValue());
        }
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.getDSN(), "TimeView", this.type);
        model = model.filterBy(newFilters);
        CallStackPage result = new CallStackPage();
        result.setDSN(this.dsn);
        result.setType(this.type);
        result.setTaskId(this.getTaskId());
        result.setTransactionId(this.getTransactionId());
        result.setDB2Id(this.getDBRM(), this.getDBRMNR());
        result.setTaskId(this.getTaskId());
        result.setModeType(newMode);
        result.setFilterExpressions(newFilters);
        result.currentMode = newMode;
        result.setModel(model);
        return new PageWithModesContainer(result, model);
    }

    @Override
    public String getRootId() {
        return ID_ROOT;
    }

    @Override
    public String getCurrentMode() {
        return this.currentMode;
    }
}

