/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.subpages;

import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.JVMPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractJVMSubpage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    protected JVMPage.JVMContextRestrictions contextRestrictions = null;
    private Composite wrapper;
    private Label methodLabel;
    private Label sourceLabel;
    private Label threadLabel;
    private Label processLabel;
    private Label modeLabel;
    private Label moduleLabel;

    public JVMPage.JVMContextRestrictions getContextRestrictions() {
        if (this.contextRestrictions == null) {
            return null;
        }
        return this.contextRestrictions.clone();
    }

    public void setContextRestrictions(JVMPage.JVMContextRestrictions contextRestrictions) {
        if (this.contextRestrictions == null) {
            this.contextRestrictions = contextRestrictions.clone();
        }
    }

    @Override
    public void createHeaderPart(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        this.wrapper.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.wrapper.setLayoutData((Object)gridData);
        this.modeLabel = new Label(this.wrapper, 4);
        this.moduleLabel = new Label(this.wrapper, 4);
        this.methodLabel = new Label(this.wrapper, 4);
        this.sourceLabel = new Label(this.wrapper, 4);
        this.processLabel = new Label(this.wrapper, 4);
        this.threadLabel = new Label(this.wrapper, 4);
    }

    public void refreshHeader() {
        if (this.contextRestrictions != null) {
            if (this.contextRestrictions.getFrom() != null) {
                this.modeLabel.setText("Mode: " + this.contextRestrictions.getFrom() + "    ");
            } else {
                this.modeLabel.setText("Mode: " + this.getTitleText() + "    ");
            }
            if (this.contextRestrictions.getDataMode() != null) {
                this.moduleLabel.setText("Methods: " + this.getTitleText() + "    ");
            }
            if (this.contextRestrictions.getJVMMethodName() != null) {
                this.methodLabel.setText("Method: " + this.contextRestrictions.getJVMMethodName() + "    ");
            }
            if (this.contextRestrictions.getJVMMethodSource() != null) {
                this.sourceLabel.setText("Source: " + this.contextRestrictions.getJVMMethodSource() + "    ");
            }
            if (this.contextRestrictions.getJVMProcess() != null) {
                this.processLabel.setText("Process: " + HexUtil.Squeeze(this.contextRestrictions.getJVMProcess()) + "     ");
            }
            if (this.contextRestrictions.getJVMThread() != null) {
                this.threadLabel.setText("Thread: " + this.contextRestrictions.getJVMThread() + "     ");
            }
            this.wrapper.getParent().layout(true, true);
        }
    }

    private String getTitleText() {
        String mode = "";
        String modeSubtype = this.contextRestrictions.getDataMode();
        mode = modeSubtype.equals("data_mode_application") ? "Application" : (modeSubtype.equals("data_mode_via") ? "Via" : (modeSubtype.equals("data_mode_current") ? "Current" : "Unknown"));
        return mode;
    }
}

