/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat;

import com.ca.mat.managers.Singletons;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private final String CONTEXT_HELP_ID = "com.ca.mat.help.preferencePage";
    private static final String[][] choices = new String[][]{{"Severe Error", Level.SEVERE.getName()}, {"Warning", Level.WARNING.getName()}, {"Info", Level.INFO.getName()}, {"Debug", Level.ALL.getName()}};
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public PreferencePage() {
        super(1);
        IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();
        this.setPreferenceStore((IPreferenceStore)store);
    }

    public PreferencePage(int style) {
        super(style);
    }

    public PreferencePage(String title, int style) {
        super(title, style);
    }

    public PreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        ComboFieldEditor logging = new ComboFieldEditor("loglevels", "&Logging level", choices, parent);
        this.addField((FieldEditor)logging);
        IntegerFieldEditor refresh = new IntegerFieldEditor("MAT_REFRESH_CYCLE", "Server &refresh interval in seconds", parent);
        refresh.setValidRange(30, 300);
        this.addField((FieldEditor)refresh);
        BooleanFieldEditor textOnlyTables = new BooleanFieldEditor("textOnlyTables", "Text-&only tables", 0, parent);
        this.addField((FieldEditor)textOnlyTables);
        BooleanFieldEditor refreshEnable = new BooleanFieldEditor("MAT_REFRESH", "Enable &server refresh", 0, parent);
        this.addField((FieldEditor)refreshEnable);
        BooleanFieldEditor storeLocalXMLEnable = new BooleanFieldEditor("MAT_STORE_LOCAL", "&Cache analysis results", 0, parent);
        this.addField((FieldEditor)storeLocalXMLEnable);
        BooleanFieldEditor localXMLEnable = new BooleanFieldEditor("MAT_USE_LOCAL", "&Use cached results when available", 0, parent);
        this.addField((FieldEditor)localXMLEnable);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "com.ca.mat.help.preferencePage");
        return control;
    }

    public void performApply() {
        super.performApply();
        try {
            ((IPersistentPreferenceStore)this.getPreferenceStore()).save();
        }
        catch (IOException e) {
            this.log.warning("Could not save user preference settings: " + e.getMessage());
        }
    }
}

