/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.connect.MATFamily;
import com.ca.mat.connect.MATServer;
import com.ca.mat.utils.HexUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class ServerStatusJob
extends Job {
    static String cacopyright = "Copyright (c) 2017 CA";
    protected final MATServer server;
    private Display display;
    private static final String REFRESHING = "Refreshing Status %1$s:";

    public ServerStatusJob(MATServer server, Display display) {
        super(String.format(REFRESHING, server.getText()));
        this.server = server;
        this.display = display;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.server.getPort() < 1) {
            this.server.setStatusText(12, "Invalid port");
        } else {
            try {
                InetSocketAddress socketaddress = new InetSocketAddress(this.server.getHostname(), this.server.getPort());
                SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket socket = (SSLSocket)ssf.createSocket();
                socket.connect(socketaddress);
                socket.close();
                if (!this.server.isActive()) {
                    this.server.setStatusText(3, "Active");
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.server.setStatusText(12, "Unknown host");
            }
            catch (IOException e) {
                String text = HexUtil.getErrorText(e);
                int ix = text.lastIndexOf(58);
                this.server.setStatusText(12, text.substring(0, ix > 0 ? ix : text.length()));
            }
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.toString().equals("com.ca.mat.plugin")) {
            return true;
        }
        if (family instanceof MATFamily) {
            return ((MATFamily)family).getDisplay().equals(this.display) && ((MATFamily)family).getType() == 0;
        }
        return super.belongsTo(family);
    }
}

