/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.handlers.RefreshHandler;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.rowmodels.tuntables.ScheduleRowModel;
import com.ca.mat.utils.TextUtil;
import com.ca.mat.utils.VerifyDSN;
import com.ca.mat.xml.XMLRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class DefineMonitorDialog
extends TestingToolsDialog {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final Pattern memberPattern = Pattern.compile("^[A-Z$#@][0-9A-Z#@]*");
    private static final Pattern jobPattern = Pattern.compile("^[0-9A-Z#@*%$?]+");
    private static final Pattern durationPattern = Pattern.compile("^[0]*[1-9][0-9]*[SM]$");
    private static final String CUSTOM_SCHEDULE_NAME = "**YES**";
    private static final String CONTEXT_HELP_ID_GENRAL = "com.ca.mat.help.monitordefinitiondialoggeneral";
    private static final String CONTEXT_HELP_ID_ADDITIONAL = "com.ca.mat.help.monitordefinitiondialogadditional";
    private static final String CONTEXT_HELP_ID_CICSIMS = "com.ca.mat.help.monitordefinitiondialogcicsims";
    private static final String CONTEXT_HELP_ID_DB2 = "com.ca.mat.help.monitordefinitiondialogdb2";
    private static final String CONTEXT_HELP_ID_WAS = "com.ca.mat.help.monitordefinitiondialogwas";
    private Composite parentComposite;
    private Composite composite;
    private Composite detailsButtonBar;
    private List<Composite> groups;
    private List<Button> groupButtons;
    private String title;
    private Text profileField;
    private Text descField;
    private Text jobnameField;
    private Text stepnameField;
    private Text pstepnameField;
    private Text programField;
    private Text monDSField;
    private Text targsysField1;
    private Text targsysField2;
    private Text targsysField3;
    private Text targsysField4;
    private Text monitorDurationField;
    private Text observationsField;
    private Text loadlibDDNField;
    private Text executionsField;
    private Text repetitionsField;
    private Text delayField;
    private Text gl4ExitField1;
    private Text gl4ExitField2;
    private Text dbExitField;
    private Text inclTaskField1;
    private Text inclTaskField2;
    private Text inclTaskField3;
    private Text inclTaskField4;
    private Text exclTaskField1;
    private Text exclTaskField2;
    private Text exclTaskField3;
    private Text exclTaskField4;
    private Text cicsTranCode1;
    private Text cicsTranCode2;
    private Text cicsTranCode3;
    private Text cicsTranCode4;
    private Text cicsTerminalId1;
    private Text cicsTerminalId2;
    private Text cicsTerminalId3;
    private Text cicsTerminalId4;
    private Text cicsUserId1;
    private Text cicsUserId2;
    private Text cicsUserId3;
    private Text cicsUserId4;
    private Text urlFilterField1;
    private Text urlFilterField2;
    private Text urlFilterField3;
    private Text urlFilterField4;
    private Text classFilterField1;
    private Text classFilterField2;
    private Text classFilterField3;
    private Text reportField;
    Combo schedCombo;
    private Button multiStepField;
    private Button db2ExplainField;
    private Button db2SQLfromCatalogField;
    private Button db2HvlocField;
    private Button db2HvcorField;
    private Button db2HviidField;
    private Button db2HvthdField;
    private Button batchRepField;
    private Button pmaRepField;
    private Button noRepField;
    private Button stepMonField;
    private Button wasExpertField;
    private MonitorProfileRowModel profileRow;
    private boolean editMode;
    private boolean valid;
    private boolean changed;
    private List<String> errorMessages;
    Control debug;

    public DefineMonitorDialog(Shell parent) {
        this(parent, MonitorProfileRowModel.getDefaultProfile(parent.getDisplay()));
        this.title = "New Monitor Definition";
        this.editMode = false;
    }

    public DefineMonitorDialog(Shell parent, MonitorProfileRowModel row) {
        super(parent);
        this.CONTEXT_HELP_ID = CONTEXT_HELP_ID_GENRAL;
        this.groups = new ArrayList<Composite>();
        this.groupButtons = new ArrayList<Button>();
        this.editMode = false;
        this.errorMessages = new ArrayList<String>();
        this.profileRow = row;
        this.title = "Edit Monitor Definition";
        this.editMode = true;
        this.createHelpBar = false;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.parentComposite = parent;
        Composite superComposite = (Composite)super.createDialogArea(parent);
        superComposite.setLayout((Layout)new GridLayout(1, false));
        this.composite = new Composite(superComposite, 4);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 0, true, false);
        this.composite.setLayoutData((Object)gData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.CONTEXT_HELP_ID);
        this.detailsButtonBar = new Composite(this.composite, 4);
        this.detailsButtonBar.setLayout((Layout)new GridLayout(7, false));
        gData = new GridData(4, 0, true, false);
        this.detailsButtonBar.setLayoutData((Object)gData);
        Composite primaryGroup = this.createGroup(true);
        Label title1 = this.createSeparator(primaryGroup, "Specify parameters for monitoring session:  ", (Control)primaryGroup, (Control)primaryGroup);
        Label profileLabel = this.createLabel(primaryGroup, "Profile", (Control)primaryGroup, (Control)title1, 16);
        this.profileField = this.createField(primaryGroup, this.profileRow.getProfileName(), (Control)profileLabel, null, 12, 8);
        if (this.editMode) {
            this.profileField.setEditable(false);
            this.profileField.setBackground(this.getShell().getDisplay().getSystemColor(15));
        }
        Label reportLabel = this.createLabel(primaryGroup, "Report Dataset Prefix", (Control)primaryGroup, (Control)profileLabel, 16);
        this.reportField = this.createField(primaryGroup, this.profileRow.getReportPrefix(), (Control)reportLabel, null, 26, 26);
        this.batchRepField = this.createRadioButton(primaryGroup, "Batch Report", this.profileRow.getBatch(), (Control)this.reportField, null, 12);
        this.batchRepField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DefineMonitorDialog.this.reportField.setEnabled(false);
                DefineMonitorDialog.this.reportField.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.pmaRepField = this.createRadioButton(primaryGroup, "PMA Report", this.profileRow.getPma(), (Control)this.batchRepField, null, 12);
        this.pmaRepField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DefineMonitorDialog.this.reportField.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.noRepField = this.createRadioButton(primaryGroup, "No Report", this.profileRow.getNoReport(), (Control)this.pmaRepField, null, 12);
        this.noRepField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DefineMonitorDialog.this.reportField.setEnabled(false);
                DefineMonitorDialog.this.reportField.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.reportField.setEnabled(this.pmaRepField.getSelection());
        Label descLabel = this.createLabel(primaryGroup, "Description", (Control)primaryGroup, (Control)reportLabel, 16);
        this.descField = this.createField(primaryGroup, this.profileRow.getDescription(), (Control)descLabel, null, 50, 24);
        Label monDSLabel = this.createLabel(primaryGroup, "Monitor Dataset", (Control)primaryGroup, (Control)descLabel, 16);
        this.monDSField = this.createField(primaryGroup, this.profileRow.getDsn(), (Control)monDSLabel, null, 50, 46);
        Label title2 = this.createSeparator(primaryGroup, "Specify target name & system:", (Control)primaryGroup, (Control)monDSLabel);
        Label jobnameLabel = this.createLabel(primaryGroup, "Job Name", (Control)primaryGroup, (Control)title2, 16);
        this.jobnameField = this.createField(primaryGroup, this.profileRow.getJobName(), (Control)jobnameLabel, null, 12, 8);
        Label stepnameLabel = this.createLabel(primaryGroup, "Step Name", (Control)this.jobnameField, null, 12);
        this.stepnameField = this.createField(primaryGroup, this.profileRow.getStep(), (Control)stepnameLabel, null, 12, 8);
        this.multiStepField = this.createCheckbox(primaryGroup, "Multi-Step", this.profileRow.getMultiStep(), (Control)this.stepnameField, null, 25);
        Label pstepLabel = this.createLabel(primaryGroup, "Proc Step", (Control)primaryGroup, (Control)jobnameLabel, 16);
        this.pstepnameField = this.createField(primaryGroup, this.profileRow.getProcStep(), (Control)pstepLabel, null, 12, 8);
        Label progLabel = this.createLabel(primaryGroup, "Program", (Control)this.pstepnameField, null, 12);
        this.programField = this.createField(primaryGroup, this.profileRow.getProgram(), (Control)progLabel, null, 12, 8);
        Label targsysLabel = this.createLabel(primaryGroup, "Systems", (Control)primaryGroup, (Control)progLabel, 16);
        this.targsysField1 = this.createField(primaryGroup, this.profileRow.getTargsys1(), (Control)targsysLabel, null, 12, 8);
        this.targsysField2 = this.createField(primaryGroup, this.profileRow.getTargsys2(), (Control)this.targsysField1, null, 12, 8);
        this.targsysField3 = this.createField(primaryGroup, this.profileRow.getTargsys3(), (Control)this.targsysField2, null, 12, 8);
        this.targsysField4 = this.createField(primaryGroup, this.profileRow.getTargsys4(), (Control)this.targsysField3, null, 12, 8);
        Label title3 = this.createSeparator(primaryGroup, "Specify parameters for target job name:", (Control)primaryGroup, (Control)targsysLabel);
        Label monDurLabel = this.createLabel(primaryGroup, "Monitor Duration", (Control)primaryGroup, (Control)title3, 16);
        this.monitorDurationField = this.createField(primaryGroup, this.profileRow.getElapsed(), (Control)monDurLabel, null, 10, 6);
        this.stepMonField = this.createCheckbox(primaryGroup, "Monitor Entire Step", this.profileRow.getStepMon(), (Control)this.monitorDurationField, null, 25);
        Label observLabel = this.createLabel(primaryGroup, "Observations Requested", (Control)primaryGroup, (Control)monDurLabel, 16);
        this.observationsField = this.createField(primaryGroup, this.profileRow.getObservations(), (Control)observLabel, null, 10, 6);
        Label llDDNLabel = this.createLabel(primaryGroup, "DDN for load modules", (Control)primaryGroup, (Control)observLabel, 16);
        this.loadlibDDNField = this.createField(primaryGroup, this.profileRow.getLoadlibDDN(), (Control)llDDNLabel, null, 10, 8);
        Composite additionalGroup = this.createGroup(false);
        Label scheduleLabel = this.createLabel(additionalGroup, "Schedule", (Control)additionalGroup, (Control)additionalGroup, 16);
        this.schedCombo = this.createCombo(additionalGroup, this.profileRow.getSchedule(), (Control)scheduleLabel, null, 12, 8);
        this.fillSchedCombo(this.schedCombo, this.profileRow.getSchedule());
        Label title5 = this.createSeparator(additionalGroup, "Additional monitoring criteria:", (Control)additionalGroup, (Control)scheduleLabel);
        Label executionsLabel = this.createLabel(additionalGroup, "Max. number of monitors per jobstep execution", (Control)additionalGroup, (Control)title5, 55);
        this.executionsField = this.createField(additionalGroup, this.profileRow.getNumberOfMonitors(), (Control)executionsLabel, null, 12, 4);
        Label repetitionsLabel = this.createLabel(additionalGroup, "Monitor this job the next x times it runs", (Control)additionalGroup, (Control)executionsLabel, 55);
        this.repetitionsField = this.createField(additionalGroup, this.profileRow.getNumberOfJobRuns(), (Control)repetitionsLabel, null, 12, 4);
        Label delayLabel = this.createLabel(additionalGroup, "Delay of monitor after step start (seconds)", (Control)additionalGroup, (Control)repetitionsLabel, 55);
        this.delayField = this.createField(additionalGroup, this.profileRow.getStartDelay(), (Control)delayLabel, null, 12, 4);
        Label gl4ExitLabel = this.createLabel(additionalGroup, "Call user written 4GL exit programs for this monitor", (Control)additionalGroup, (Control)delayLabel, 55);
        this.gl4ExitField1 = this.createField(additionalGroup, this.profileRow.get4GLExit(), (Control)gl4ExitLabel, null, 12, 8);
        this.gl4ExitField2 = this.createField(additionalGroup, this.profileRow.getIdealExit(), (Control)this.gl4ExitField1, null, 12, 8);
        Label dbExitLabel = this.createLabel(additionalGroup, "Call user written Data Base exit program for this monitor", (Control)additionalGroup, (Control)gl4ExitLabel, 55);
        this.dbExitField = this.createField(additionalGroup, this.profileRow.getDbLExit(), (Control)dbExitLabel, null, 12, 8);
        Label pmaTitle = this.createSeparator(additionalGroup, "PMA Analysis:", (Control)additionalGroup, (Control)dbExitLabel);
        Label pmaLabel = this.createLabel(additionalGroup, "Report Dataset prefix", (Control)additionalGroup, (Control)pmaTitle, 55);
        Label title6 = this.createSeparator(additionalGroup, "Task Inclusions/Exclusions:", (Control)additionalGroup, (Control)pmaLabel);
        Label includeLabel = this.createLabel(additionalGroup, "Include Tasks", (Control)additionalGroup, (Control)title6, 16);
        this.inclTaskField1 = this.createField(additionalGroup, this.profileRow.getIncludeTask1(), (Control)includeLabel, null, 12, 8);
        this.inclTaskField2 = this.createField(additionalGroup, this.profileRow.getIncludeTask2(), (Control)this.inclTaskField1, null, 12, 8);
        this.inclTaskField3 = this.createField(additionalGroup, this.profileRow.getIncludeTask3(), (Control)this.inclTaskField2, null, 12, 8);
        this.inclTaskField4 = this.createField(additionalGroup, this.profileRow.getIncludeTask4(), (Control)this.inclTaskField3, null, 12, 8);
        Label excludeLabel = this.createLabel(additionalGroup, "Exclude Tasks", (Control)additionalGroup, (Control)includeLabel, 16);
        this.exclTaskField1 = this.createField(additionalGroup, this.profileRow.getExcludeTask1(), (Control)excludeLabel, null, 12, 8);
        this.exclTaskField2 = this.createField(additionalGroup, this.profileRow.getExcludeTask2(), (Control)this.exclTaskField1, null, 12, 8);
        this.exclTaskField3 = this.createField(additionalGroup, this.profileRow.getExcludeTask3(), (Control)this.exclTaskField2, null, 12, 8);
        this.exclTaskField4 = this.createField(additionalGroup, this.profileRow.getExcludeTask4(), (Control)this.exclTaskField3, null, 12, 8);
        Composite cicsGroup = this.createGroup(false);
        Label trancodeLabel = this.createLabel(cicsGroup, "Transaction codes", (Control)cicsGroup, (Control)title6, 16);
        this.cicsTranCode1 = this.createField(cicsGroup, this.profileRow.getTranCode1(), (Control)trancodeLabel, null, 12, 8);
        this.cicsTranCode2 = this.createField(cicsGroup, this.profileRow.getTranCode2(), (Control)this.cicsTranCode1, null, 12, 8);
        this.cicsTranCode3 = this.createField(cicsGroup, this.profileRow.getTranCode3(), (Control)this.cicsTranCode2, null, 12, 8);
        this.cicsTranCode4 = this.createField(cicsGroup, this.profileRow.getTranCode4(), (Control)this.cicsTranCode3, null, 12, 8);
        Label terminalLabel = this.createLabel(cicsGroup, "Terminal IDs", (Control)cicsGroup, (Control)trancodeLabel, 16);
        this.cicsTerminalId1 = this.createField(cicsGroup, this.profileRow.getTerminalId1(), (Control)terminalLabel, null, 12, 8);
        this.cicsTerminalId2 = this.createField(cicsGroup, this.profileRow.getTerminalId2(), (Control)this.cicsTerminalId1, null, 12, 8);
        this.cicsTerminalId3 = this.createField(cicsGroup, this.profileRow.getTerminalId3(), (Control)this.cicsTerminalId2, null, 12, 8);
        this.cicsTerminalId4 = this.createField(cicsGroup, this.profileRow.getTerminalId4(), (Control)this.cicsTerminalId3, null, 12, 8);
        Label useridLabel = this.createLabel(cicsGroup, "User IDs", (Control)cicsGroup, (Control)terminalLabel, 16);
        this.cicsUserId1 = this.createField(cicsGroup, this.profileRow.getUserId1(), (Control)useridLabel, null, 12, 8);
        this.cicsUserId2 = this.createField(cicsGroup, this.profileRow.getUserId2(), (Control)this.cicsUserId1, null, 12, 8);
        this.cicsUserId3 = this.createField(cicsGroup, this.profileRow.getUserId3(), (Control)this.cicsUserId2, null, 12, 8);
        this.cicsUserId4 = this.createField(cicsGroup, this.profileRow.getUserId4(), (Control)this.cicsUserId3, null, 12, 8);
        Composite db2Group = this.createGroup(false);
        this.db2ExplainField = this.createCheckbox(db2Group, "Explain SQL", this.profileRow.getExplainSQL(), (Control)db2Group, (Control)db2Group, 35);
        this.db2SQLfromCatalogField = this.createCheckbox(db2Group, "Get SQL from Catalog", this.profileRow.getUseDB2Catalog(), (Control)this.db2ExplainField, null, 35);
        this.db2HvlocField = this.createCheckbox(db2Group, "DB2 Requestor Location", this.profileRow.getReqestorLocation(), (Control)db2Group, (Control)this.db2ExplainField, 35);
        this.db2HvcorField = this.createCheckbox(db2Group, "DB2 Correlation ID", this.profileRow.getCorrelationId(), (Control)this.db2HvlocField, null, 35);
        this.db2HviidField = this.createCheckbox(db2Group, "DB2 Operator ID", this.profileRow.getOperatorId(), (Control)db2Group, (Control)this.db2HvlocField, 35);
        this.db2HvthdField = this.createCheckbox(db2Group, "DB2 Thread Address", this.profileRow.getThreadAddress(), (Control)this.db2HviidField, null, 35);
        Composite wasGroup = this.createGroup(false);
        this.wasExpertField = this.createCheckbox(wasGroup, "Expert Mode", this.profileRow.getWasExpertMode(), (Control)wasGroup, (Control)wasGroup, 25);
        Label title7 = this.createSeparator(wasGroup, "Specify Application URL Filters:", (Control)wasGroup, (Control)this.wasExpertField);
        this.urlFilterField1 = this.createField(wasGroup, this.profileRow.getURLFilter1(), (Control)wasGroup, (Control)title7, 70, 64);
        this.urlFilterField2 = this.createField(wasGroup, this.profileRow.getURLFilter2(), (Control)wasGroup, (Control)this.urlFilterField1, 70, 64);
        this.urlFilterField3 = this.createField(wasGroup, this.profileRow.getURLFilter3(), (Control)wasGroup, (Control)this.urlFilterField2, 70, 64);
        this.urlFilterField4 = this.createField(wasGroup, this.profileRow.getURLFilter4(), (Control)wasGroup, (Control)this.urlFilterField3, 70, 64);
        Label title8 = this.createSeparator(wasGroup, "Specify System Class Filters: ", (Control)wasGroup, (Control)this.urlFilterField4);
        this.classFilterField1 = this.createField(wasGroup, this.profileRow.getSystemFilter1(), (Control)wasGroup, (Control)title8, 70, 64);
        this.classFilterField2 = this.createField(wasGroup, this.profileRow.getSystemFilter2(), (Control)wasGroup, (Control)this.classFilterField1, 70, 64);
        this.classFilterField3 = this.createField(wasGroup, this.profileRow.getSystemFilter3(), (Control)wasGroup, (Control)this.classFilterField2, 70, 64);
        Button mainButton = this.createToggleButton("Main", primaryGroup, CONTEXT_HELP_ID_GENRAL);
        mainButton.setSelection(true);
        this.createToggleButton("Additional", additionalGroup, CONTEXT_HELP_ID_ADDITIONAL);
        this.createToggleButton("CICS/IMS", cicsGroup, CONTEXT_HELP_ID_CICSIMS);
        this.createToggleButton("DB2", db2Group, CONTEXT_HELP_ID_DB2);
        this.createToggleButton("Java", wasGroup, CONTEXT_HELP_ID_WAS);
        if (!this.CONTEXT_HELP_ID.isEmpty()) {
            if (Activator.plugin.hasEclipseFragment()) {
                this.setHelpAvailable(true);
            } else {
                this.createHelpToolbar(this.detailsButtonBar);
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)superComposite, this.CONTEXT_HELP_ID);
        } else {
            this.setHelpAvailable(false);
        }
        superComposite.layout();
        return superComposite;
    }

    private void fillSchedCombo(Combo schedCombo, String initialValue) {
        if (initialValue != null && initialValue.equals(CUSTOM_SCHEDULE_NAME)) {
            schedCombo.setItems(new String[]{CUSTOM_SCHEDULE_NAME});
            schedCombo.select(0);
            schedCombo.setEnabled(false);
            return;
        }
        MATTableModel schedules = Singletons.getMonitorManager().getMonitorSchedulesTable();
        Integer size = schedules.getRows().length + 1;
        String[] items = new String[size.intValue()];
        int i = 1;
        items[0] = "";
        int selection = 0;
        MATTableRow[] mATTableRowArray = schedules.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            ScheduleRowModel schedRow = (ScheduleRowModel)row;
            items[i] = schedRow.getName();
            if (schedRow.getName() != null && schedRow.getName().equals(initialValue)) {
                selection = i;
            }
            ++i;
            ++n2;
        }
        schedCombo.setItems(items);
        schedCombo.select(selection);
    }

    private Button createToggleButton(String title, final Composite group, final String helpContextId) {
        Button toggleButton = new Button(this.detailsButtonBar, 2);
        this.groups.add(group);
        this.groupButtons.add(toggleButton);
        toggleButton.setText(title);
        toggleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!group.isVisible()) {
                    for (Composite otherGroup : DefineMonitorDialog.this.groups) {
                        DefineMonitorDialog.this.hideGroup(otherGroup);
                    }
                    for (Button otherButton : DefineMonitorDialog.this.groupButtons) {
                        if (otherButton.equals(e.getSource())) continue;
                        otherButton.setSelection(false);
                    }
                    DefineMonitorDialog.this.showGroup(group);
                    DefineMonitorDialog.this.CONTEXT_HELP_ID = helpContextId;
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, DefineMonitorDialog.this.CONTEXT_HELP_ID);
                    group.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toggleButton;
    }

    @Override
    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    protected void okPressed() {
        MonitorProfileRowModel defaultProfile = MonitorProfileRowModel.getDefaultProfile(this.getShell().getDisplay());
        if (this.monDSField.getText() == null || this.monDSField.getText().isEmpty()) {
            this.monDSField.setText(defaultProfile.getDsn());
        }
        if (this.monitorDurationField.getText() == null || this.monitorDurationField.getText().isEmpty()) {
            this.monitorDurationField.setText(defaultProfile.getElapsed());
        }
        if (this.observationsField.getText() == null || this.observationsField.getText().isEmpty()) {
            this.observationsField.setText(defaultProfile.getObservations());
        }
        if (this.executionsField.getText() == null || this.executionsField.getText().isEmpty()) {
            this.executionsField.setText(defaultProfile.getNumberOfMonitors());
        }
        if (this.repetitionsField.getText() == null || this.repetitionsField.getText().isEmpty()) {
            this.repetitionsField.setText(defaultProfile.getNumberOfJobRuns());
        }
        if (this.delayField.getText() == null || this.delayField.getText().isEmpty()) {
            this.delayField.setText(defaultProfile.getStartDelay());
        }
        HashMap<String, Object> parms = new HashMap<String, Object>();
        this.valid = true;
        this.changed = false;
        this.errorMessages.clear();
        if (this.checkPresence(this.profileField, "Profile name") && this.checkMemberName(this.profileField.getText(), "Profile name")) {
            this.appendArg(parms, this.profileField, "PROFILE", this.profileRow.getProfileName(), true);
        }
        this.appendArg(parms, this.descField, "DESCRIPTION", this.profileRow.getDescription(), false);
        if (this.checkPresence(this.jobnameField, "Job name") && this.checkJobStepName(this.jobnameField, "Job name")) {
            this.appendArg(parms, this.jobnameField, "JOBNAME", this.profileRow.getJobName(), true);
        }
        if (this.checkJobStepName(this.stepnameField, "Step name")) {
            this.appendArg(parms, this.stepnameField, "STEPNAME", this.profileRow.getStep(), true);
        }
        if (this.checkJobStepName(this.pstepnameField, "Pstep name")) {
            this.appendArg(parms, this.pstepnameField, "PROCSTEP", this.profileRow.getProcStep(), true);
        }
        if (this.checkJobStepName(this.programField, "Program")) {
            this.appendArg(parms, this.programField, "PROGRAM", this.profileRow.getProgram(), true);
        }
        this.appendArg(parms, this.multiStepField, "MSTEP", "YES", "NO", this.profileRow.getMultiStep());
        if (this.checkPresence(this.monDSField, "Monitor Dataset Name") || this.checkDSNTemplate(this.monDSField, "Monitor Dataset Name")) {
            this.appendArg(parms, this.monDSField, "MONDSN", this.profileRow.getDsn(), true);
        }
        this.appendArg(parms, this.targsysField1, "TARGSYS1", this.profileRow.getTargsys1(), true);
        this.appendArg(parms, this.targsysField2, "TARGSYS2", this.profileRow.getTargsys2(), true);
        this.appendArg(parms, this.targsysField3, "TARGSYS3", this.profileRow.getTargsys3(), true);
        this.appendArg(parms, this.targsysField4, "TARGSYS4", this.profileRow.getTargsys4(), true);
        if (this.checkDuration(this.monitorDurationField, "Monitor Duration")) {
            this.appendArg(parms, this.monitorDurationField, "ELAPSTIME", this.profileRow.getElapsed(), true);
        }
        this.appendArg(parms, this.stepMonField, "SMON", "YES", "NO", this.profileRow.getStepMon());
        if (this.checkNumber(this.observationsField, "Observations Requested", 10, 999999)) {
            this.appendArg(parms, this.observationsField, "SAMPLECNT", this.profileRow.getObservations(), true);
        }
        this.appendArg(parms, this.loadlibDDNField, "TASKLIB", this.profileRow.getLoadlibDDN(), true);
        if (this.checkSchedule(this.schedCombo)) {
            this.appendArg(parms, this.schedCombo, "SCHEDULE", this.profileRow.getSchedule(), true);
        }
        if (this.checkNumber(this.executionsField, "Monitors per job step", 1, 9999)) {
            this.appendArg(parms, this.executionsField, "SUCCNT", this.profileRow.getNumberOfMonitors(), false);
        }
        if (this.checkNumber(this.repetitionsField, "Monitor Repetitions", 1, 9999)) {
            this.appendArg(parms, this.repetitionsField, "RECCNT", this.profileRow.getNumberOfJobRuns(), false);
        }
        if (this.checkNumber(this.delayField, "Monitor start delay", 0, 9999)) {
            this.appendArg(parms, this.delayField, "SAMPDELAY", this.profileRow.getStartDelay(), false);
        }
        if (this.checkMemberName(this.gl4ExitField1.getText(), "4GL Exit 1")) {
            this.appendArg(parms, this.gl4ExitField1, "USEREXIT2", this.profileRow.get4GLExit(), true);
        }
        if (this.checkMemberName(this.gl4ExitField2.getText(), "4GL Exit 2")) {
            this.appendArg(parms, this.gl4ExitField2, "USEREXIT3", this.profileRow.getIdealExit(), true);
        }
        if (this.checkMemberName(this.dbExitField.getText(), "Database exit")) {
            this.appendArg(parms, this.dbExitField, "USEREXIT1", this.profileRow.getDbLExit(), true);
        }
        if (this.checkJobStepName(this.inclTaskField1, "Include Task 1")) {
            this.appendArg(parms, this.inclTaskField1, "INCTASK1", this.profileRow.getIncludeTask1(), true);
        }
        if (this.checkJobStepName(this.inclTaskField2, "Include Task 2")) {
            this.appendArg(parms, this.inclTaskField2, "INCTASK2", this.profileRow.getIncludeTask2(), true);
        }
        if (this.checkJobStepName(this.inclTaskField3, "Include Task 3")) {
            this.appendArg(parms, this.inclTaskField3, "INCTASK3", this.profileRow.getIncludeTask3(), true);
        }
        if (this.checkJobStepName(this.inclTaskField4, "Include Task 4")) {
            this.appendArg(parms, this.inclTaskField4, "INCTASK4", this.profileRow.getIncludeTask4(), true);
        }
        if (this.checkJobStepName(this.exclTaskField1, "Exclude Task 1")) {
            this.appendArg(parms, this.exclTaskField1, "EXCTASK1", this.profileRow.getExcludeTask1(), true);
        }
        if (this.checkJobStepName(this.exclTaskField2, "Exclude Task 2")) {
            this.appendArg(parms, this.exclTaskField2, "EXCTASK2", this.profileRow.getExcludeTask2(), true);
        }
        if (this.checkJobStepName(this.exclTaskField3, "Exclude Task 3")) {
            this.appendArg(parms, this.exclTaskField3, "EXCTASK3", this.profileRow.getExcludeTask3(), true);
        }
        if (this.checkJobStepName(this.exclTaskField4, "Exclude Task 4")) {
            this.appendArg(parms, this.exclTaskField4, "EXCTASK4", this.profileRow.getExcludeTask4(), true);
        }
        if (this.pmaRepField.getSelection() && this.checkPresence(this.reportField, "Report Dataset Prefix") && this.checkDSNTemplate(this.reportField, "Report Dataset Prefix")) {
            this.appendArg(parms, this.reportField, "REPDSN", this.profileRow.getReportPrefix(), true);
        }
        this.appendArg(parms, this.cicsTranCode1, "TRAN1", this.profileRow.getTranCode1(), false);
        this.appendArg(parms, this.cicsTranCode2, "TRAN2", this.profileRow.getTranCode2(), false);
        this.appendArg(parms, this.cicsTranCode3, "TRAN3", this.profileRow.getTranCode3(), false);
        this.appendArg(parms, this.cicsTranCode4, "TRAN4", this.profileRow.getTranCode4(), false);
        this.appendArg(parms, this.cicsTerminalId1, "TERM1", this.profileRow.getTerminalId1(), false);
        this.appendArg(parms, this.cicsTerminalId2, "TERM2", this.profileRow.getTerminalId2(), false);
        this.appendArg(parms, this.cicsTerminalId3, "TERM3", this.profileRow.getTerminalId3(), false);
        this.appendArg(parms, this.cicsTerminalId4, "TERM4", this.profileRow.getTerminalId4(), false);
        this.appendArg(parms, this.cicsUserId1, "USERID1", this.profileRow.getUserId1(), false);
        this.appendArg(parms, this.cicsUserId2, "USERID2", this.profileRow.getUserId2(), false);
        this.appendArg(parms, this.cicsUserId3, "USERID3", this.profileRow.getUserId3(), false);
        this.appendArg(parms, this.cicsUserId4, "USERID4", this.profileRow.getUserId4(), false);
        this.appendArg(parms, this.db2ExplainField, "DB2EXPL", "YES", "NO", this.profileRow.getExplainSQL());
        this.appendArg(parms, this.db2SQLfromCatalogField, "DB2CTSQL", "YES", "NO", this.profileRow.getUseDB2Catalog());
        this.appendArg(parms, this.db2HvcorField, "DB2HVLOC", "YES", "NO", this.profileRow.getReqestorLocation());
        this.appendArg(parms, this.db2HvcorField, "DB2HVCOR", "YES", "NO", this.profileRow.getCorrelationId());
        this.appendArg(parms, this.db2HviidField, "DB2HVIID", "YES", "NO", this.profileRow.getOperatorId());
        this.appendArg(parms, this.db2HvthdField, "DB2HVTHD", "YES", "NO", this.profileRow.getThreadAddress());
        this.appendArg(parms, this.batchRepField, this.pmaRepField, "BATCHREPORTS", this.profileRow.getBatch(), true);
        this.appendArg(parms, this.wasExpertField, "WASEXPRT", "Y", "N", this.profileRow.getWasExpertMode());
        this.appendArg(parms, this.urlFilterField1, "URLFILT1", this.profileRow.getURLFilter1(), false);
        this.appendArg(parms, this.urlFilterField2, "URLFILT2", this.profileRow.getURLFilter2(), false);
        this.appendArg(parms, this.urlFilterField3, "URLFILT3", this.profileRow.getURLFilter3(), false);
        this.appendArg(parms, this.urlFilterField4, "URLFILT4", this.profileRow.getURLFilter4(), false);
        this.appendArg(parms, this.classFilterField1, "SYSFILT1", this.profileRow.getSystemFilter1(), false);
        this.appendArg(parms, this.classFilterField2, "SYSFILT2", this.profileRow.getSystemFilter2(), false);
        this.appendArg(parms, this.classFilterField3, "SYSFILT3", this.profileRow.getSystemFilter3(), false);
        if (!this.valid) {
            String message = "";
            for (String line : this.errorMessages) {
                message = String.valueOf(message) + line + "\n\n";
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid input", (String)message);
            return;
        }
        if (this.changed) {
            ServerCallback callback = new ServerCallback(){

                @Override
                public void processReply(XMLRequest reply, MATServer server) {
                    RefreshHandler refresh = new RefreshHandler();
                    refresh.refreshServers(server.getDisplay());
                }

                @Override
                public void cancel(XMLRequest reply, MATServer server) {
                }

                @Override
                public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                    return false;
                }
            };
            if (this.editMode) {
                Singletons.getServerProxy(this.getShell().getDisplay()).editProfile(this.profileField.getText(), parms, true, callback);
            } else {
                Singletons.getServerProxy(this.getShell().getDisplay()).defineProfile(this.profileField.getText(), parms, true, callback);
            }
        }
        this.close();
    }

    private void showGroup(Composite group) {
        if (!group.isVisible()) {
            group.setVisible(true);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = false;
            group.setLayoutData((Object)gData);
            this.composite.layout();
            this.composite.getParent().layout();
        }
    }

    private void hideGroup(Composite group) {
        if (group.isVisible()) {
            group.setVisible(false);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = true;
            group.setLayoutData((Object)gData);
            this.composite.layout();
            this.composite.getParent().layout();
        }
    }

    private Composite createGroup(boolean visible) {
        Composite group = new Composite(this.composite, 0);
        group.setLayout((Layout)new FormLayout());
        GridData gData = new GridData(0, 0, false, false);
        gData.exclude = !visible;
        group.setLayoutData((Object)gData);
        group.setVisible(visible);
        return group;
    }

    private Label createSeparator(Composite composite, String title, Control nextTo, Control under) {
        Label label = new Label(composite, 0);
        label.setText(title);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        label.setLayoutData((Object)fData);
        return label;
    }

    private Label createLabel(Composite composite, String title, Control nextTo, Control under, int width) {
        Label label = new Label(composite, 0);
        label.setText(title);
        label.setAlignment(131072);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width) + 12;
        label.setLayoutData((Object)fData);
        return label;
    }

    private Text createField(Composite composite, String initialValue, Control nextTo, Control under, int width, int limit) {
        return this.createField(composite, initialValue, nextTo, under, width, limit, null);
    }

    private Text createField(Composite composite, String initialValue, Control nextTo, Control under, int width, int limit, Control inFrontOf) {
        Text field = new Text(composite, 2052);
        field.setTextLimit(limit);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        field.setLayoutData((Object)fData);
        if (initialValue != null) {
            field.setText(initialValue);
        }
        return field;
    }

    private Combo createCombo(Composite composite, String initialValue, Control nextTo, Control under, int width, int limit) {
        return this.createCombo(composite, initialValue, nextTo, under, width, limit, null);
    }

    private Combo createCombo(Composite composite, String initialValue, Control nextTo, Control under, int width, int limit, Control inFrontOf) {
        Combo field = new Combo(composite, 2056);
        field.setTextLimit(limit);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        field.setLayoutData((Object)fData);
        if (initialValue != null) {
            field.setText(initialValue);
        }
        return field;
    }

    private Button createCheckbox(Composite composite, String title, String initialValue, Control nextTo, Control under, int width) {
        return this.createCheckbox(composite, title, initialValue, nextTo, under, width, null);
    }

    private Button createRadioButton(Composite composite, String title, String initialValue, Control nextTo, Control under, int width) {
        return this.createReportRadioButton(composite, title, initialValue, nextTo, under, width, null);
    }

    private Button createCheckbox(Composite composite, String title, String initialValue, Control nextTo, Control under, int width, Control inFrontOf) {
        Button field = new Button(composite, 32);
        field.setText(title);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        field.setLayoutData((Object)fData);
        if (initialValue != null) {
            if (initialValue.equals("Y")) {
                field.setSelection(true);
            }
            if (initialValue.equals("N")) {
                field.setSelection(false);
            }
            if (initialValue.equals("YES")) {
                field.setSelection(true);
            }
            if (initialValue.equals("NO")) {
                field.setSelection(false);
            }
        }
        return field;
    }

    private Button createReportRadioButton(Composite composite, String title, String initialValue, Control nextTo, Control under, int width, Control inFrontOf) {
        Button field = new Button(composite, 16);
        field.setText(title);
        FormData fData = new FormData();
        fData.left = new FormAttachment(nextTo, 10);
        if (under == null) {
            fData.bottom = new FormAttachment(nextTo, 0, 1024);
        } else {
            fData.top = new FormAttachment(under, 20);
        }
        fData.width = TextUtil.calculateWidth((Control)this.parentComposite, width);
        if (inFrontOf != null) {
            fData.right = new FormAttachment(inFrontOf, 10, 131072);
        }
        field.setLayoutData((Object)fData);
        if (initialValue != null) {
            if (initialValue.equals("Y")) {
                field.setSelection(true);
            }
            if (initialValue.equals("N")) {
                field.setSelection(false);
            }
            if (initialValue.equals("YES")) {
                field.setSelection(true);
            }
            if (initialValue.equals("NO")) {
                field.setSelection(false);
            }
        }
        return field;
    }

    private void appendArg(Map<String, Object> parms, Text field, String parmname, String originalValue, boolean uppercase) {
        if (field.getText() != null) {
            if (uppercase) {
                field.setText(field.getText().toUpperCase());
            }
            if (!field.getText().equals(originalValue)) {
                this.changed = true;
            }
            if (parmname.equalsIgnoreCase("REPDSN")) {
                parms.put(parmname, String.valueOf(field.getText()) + ".&JOBN.&SYSD.&SYST");
            } else {
                parms.put(parmname, field.getText());
            }
        }
    }

    private void appendArg(Map<String, Object> parms, Button fieldBatch, Button fieldPma, String parmname, String originalValue, boolean uppercase) {
        if (fieldBatch.getSelection()) {
            if (!originalValue.equalsIgnoreCase("Y")) {
                this.changed = true;
            }
            parms.put(parmname, "Y");
        } else if (fieldPma.getSelection()) {
            if (!originalValue.equalsIgnoreCase("P")) {
                this.changed = true;
            }
            parms.put(parmname, "P");
        } else {
            if (!originalValue.equalsIgnoreCase("N")) {
                this.changed = true;
            }
            parms.put(parmname, "N");
        }
    }

    private void appendArg(Map<String, Object> parms, Combo field, String parmname, String originalValue, boolean uppercase) {
        if (field.getText() != null) {
            if (uppercase) {
                field.setText(field.getText().toUpperCase());
            }
            if (!field.getText().equals(originalValue)) {
                this.changed = true;
            }
            parms.put(parmname, field.getText());
        }
    }

    private void appendArg(Map<String, Object> parms, Button field, String parmname, String yesStr, String noStr, String originalValue) {
        if (field.getText() != null) {
            parms.put(parmname, field.getSelection() ? yesStr : noStr);
            if (!field.getSelection() && originalValue != null && originalValue.equals(yesStr)) {
                this.changed = true;
            }
            if (field.getSelection() && (originalValue == null || !originalValue.equals(yesStr))) {
                this.changed = true;
            }
        }
    }

    private boolean checkMemberName(String value, String name) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        Matcher m = memberPattern.matcher(value = value.trim().toUpperCase());
        if (!m.matches()) {
            this.valid = false;
            this.errorMessages.add("Invalid " + name + " - " + "The " + name + " must follow the rules for job/member names: from one to eight alphanumeric and/or national characters (A-Z, 0-9, #, $, @).  The first character must be alphabetic or national (A-Z, #, $, @).");
            return false;
        }
        return true;
    }

    private boolean checkSchedule(Combo schedCombo2) {
        if (schedCombo2.getText() == null || schedCombo2.getText().isEmpty()) {
            return true;
        }
        schedCombo2.setText(schedCombo2.getText().trim().toUpperCase());
        if (schedCombo2.getText().equals(CUSTOM_SCHEDULE_NAME)) {
            return true;
        }
        return this.checkMemberName(schedCombo2.getText(), "Schedule name");
    }

    private boolean checkNumber(Text field, String name, int min, int max) {
        if (field.getText() == null || field.getText().isEmpty()) {
            return true;
        }
        try {
            int i = Integer.valueOf(field.getText());
            if (i < min || i > max) {
                this.valid = false;
                this.errorMessages.add("Invalid " + name + " - " + name + " must be a number between " + min + " and " + max + ".");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
            this.errorMessages.add("Invalid " + name + " - " + name + " must be a number between " + min + " and " + max + ".");
            return false;
        }
        return true;
    }

    private boolean checkJobStepName(Text field, String name) {
        if (field.getText() == null || field.getText().isEmpty()) {
            return true;
        }
        field.setText(field.getText().trim().toUpperCase());
        Matcher m = jobPattern.matcher(field.getText());
        if (!m.matches()) {
            this.valid = false;
            this.errorMessages.add("Invalid " + name + " - " + name + " must contain up to 8 alphanumeric or pattern characters.");
            return false;
        }
        return true;
    }

    private boolean checkPresence(Text field, String name) {
        if (field.getText() == null || field.getText().isEmpty()) {
            this.valid = false;
            this.errorMessages.add(String.valueOf(name) + " must be specified" + " - " + name + " must be defined for every monitor profile");
            return false;
        }
        return true;
    }

    private boolean checkDSNTemplate(Text field, String name) {
        if (field.getText() == null || field.getText().isEmpty()) {
            return true;
        }
        field.setText(field.getText().trim().toUpperCase());
        String dsn = field.getText();
        dsn.replace("&USERID", "USERID");
        dsn.replace("&PROFILE", "PROFILE");
        dsn.replace("&SYSDATE", "SYSDATE");
        dsn.replace("&SYSTIME", "SYSTIME");
        ArrayList<String> validationErrors = VerifyDSN.isValid(dsn, name);
        if (validationErrors.size() != 0) {
            this.valid = false;
            this.errorMessages.add(String.valueOf(name) + " must be a valid z/OS dataset name" + " - " + name + " must be a valid z/OS dataset name; Following environment variables are alowed: &USERID &PROFILE &SYSDATE &SYSTIME");
            for (String error : validationErrors) {
                this.errorMessages.add(error);
            }
            return false;
        }
        return true;
    }

    private boolean checkDuration(Text field, String name) {
        field.setText(field.getText().trim().toUpperCase());
        Matcher m = durationPattern.matcher(field.getText());
        if (!m.matches()) {
            Matcher m2 = durationPattern.matcher(String.valueOf(field.getText()) + "S");
            if (m2.matches()) {
                field.setText(String.valueOf(field.getText()) + "S");
                return true;
            }
            this.valid = false;
            this.errorMessages.add("Invalid " + name + " - " + name + " must be a number > 0, followed by S (seconds) or M (minutes).");
            return false;
        }
        return true;
    }
}

