/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.managers.Singletons;
import com.ca.mat.utils.TextUtil;
import com.ca.mat.utils.VerifyAlphaNumeric;
import com.ca.mat.utils.VerifyPDS;
import com.ca.mat.xml.XMLRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class RegisterListingDialog
extends TestingToolsDialog {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String DIALOG_MEMENTO_TYPE = "dialogs.registerlisting";
    private static final String SYSTEM = "&System";
    private static final String CHOSE_ITEM = "Choose Item";
    private static final String SOURCE_DSN = "Sou&rce DSN";
    private static final String LISTING_DSN = "Listing &DSN";
    private static final String OBJECT_DSN = "O&bject DSN";
    private static final String PROGRAM = "&Program";
    private static final String IDEAL = "Ideal";
    private static final String LANGUAGE = "&Language";
    private static final String CSECT = "&Csect";
    private static final String MODULE = "&Module";
    private static final String LIBRARY = "L&ibrary";
    private static final String ROUTINE = "&Routine";
    private static final String LISTING_MANAGER = "L&isting Manager";
    private static final String OBJECT_VERSION = "&Object Version";
    private static final String SOURCE_VERSION = "So&urce Version";
    private static final String MEMBER = "&Member name";
    static final String[] langChoices = new String[]{"Choose Item", "Assembler", "Cobol", "PL/I", "Fortran", "Natural", "IBM C/C++", "SAS C/C++", "AD/Cycle", "Ideal"};
    static final Map<String, String> langChoiceMap = new HashMap<String, String>();
    static final String[] listMngrChoices;
    static final Map<String, String> listMngrChoiceMap;
    private String module;
    private String csect;
    private String system;
    private String program;
    private String lang;
    private String listMngr;
    private String dsn;
    private String objectDsn;
    private String sourceDsn;
    private String objectVersion;
    private String sourceVersion;
    private String member;
    private boolean isIdeal;
    private boolean isNatural;
    private Label moduleLabel;
    private Label csectLabel;
    private Label langLabel;
    private Label listMngrLabel;
    private Label objectLabel;
    private Label sourceLabel;
    private Label dsnLabel;
    private Label dsn2Label;
    private Label memberLabel;
    private Text moduleField;
    private Text csectField;
    private Text objectField;
    private Text sourceField;
    private Text dsnField;
    private Text dsn2Field;
    private Text memberField;
    private Combo langCombo;
    private Combo listMngrCombo;
    int index;
    Logger log;
    Level baseLevel;
    private int idealLangIX;
    private int idealMngrIX;
    private int naturalLangIX;
    private Composite composite;
    private Composite idealComposite;
    private VerifyAlphaNumeric verifyAlphaNumeric;
    private VerifyPDS verifyDSN;

    static {
        langChoiceMap.put("Assembler", "ASM");
        langChoiceMap.put("Cobol", "COB");
        langChoiceMap.put("PL/I", "PL1");
        langChoiceMap.put("Fortran", "FOR");
        langChoiceMap.put("Natural", "NAT");
        langChoiceMap.put("IBM C/C++", "IBMC");
        langChoiceMap.put("SAS C/C++", "SASC");
        langChoiceMap.put("AD/Cycle", "AD/CYC");
        langChoiceMap.put(IDEAL, "IDEAL");
        listMngrChoices = new String[]{CHOSE_ITEM, "PDS", "DDIO", "Endevor", "PROTSYM", "Panvalet", "Librarian", "Changeman", IDEAL};
        listMngrChoiceMap = new HashMap<String, String>();
        listMngrChoiceMap.put("PDS", "PDS");
        listMngrChoiceMap.put("DDIO", "DDIO");
        listMngrChoiceMap.put("Endevor", "ENDEVOR");
        listMngrChoiceMap.put("PROTSYM", "PROTSYM");
        listMngrChoiceMap.put("Panvalet", "PANVALET");
        listMngrChoiceMap.put("Librarian", "LIBRARIAN");
        listMngrChoiceMap.put("Changeman", "CHANGEMAN");
        listMngrChoiceMap.put(IDEAL, "IDEAL");
    }

    public RegisterListingDialog(Shell parent) {
        super(parent);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.registerlistingdialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.verifyAlphaNumeric = new VerifyAlphaNumeric();
        this.verifyDSN = new VerifyPDS();
        this.loadPreviousContent(parent.getDisplay());
        this.isIdeal = false;
    }

    public RegisterListingDialog(Shell parent, String module, String csect, String analysisProfile, String analysisDsn, String language) {
        super(parent);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.registerlistingdialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.verifyAlphaNumeric = new VerifyAlphaNumeric();
        this.verifyDSN = new VerifyPDS();
        this.loadPreviousContent(parent.getDisplay());
        this.module = module;
        this.csect = csect;
        this.member = csect;
        this.isIdeal = false;
        this.objectVersion = "";
        this.sourceVersion = "";
        if (language != null) {
            this.lang = language;
        }
        if (language == "Natural") {
            this.isNatural = true;
        }
    }

    public RegisterListingDialog(Shell parent, String system, String program, String objectVersion, String sourceVersion, String analysisProfile, String analysisDsn) {
        super(parent);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.registerlistingdialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.verifyAlphaNumeric = new VerifyAlphaNumeric();
        this.verifyDSN = new VerifyPDS();
        this.loadPreviousContent(parent.getDisplay());
        this.system = system;
        this.program = program;
        this.isIdeal = true;
        this.objectVersion = objectVersion;
        this.sourceVersion = sourceVersion;
    }

    public RegisterListingDialog(IShellProvider parentShell) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.registerlistingdialog";
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.baseLevel = this.log.getLevel();
        this.verifyAlphaNumeric = new VerifyAlphaNumeric();
        this.verifyDSN = new VerifyPDS();
    }

    private void loadPreviousContent(Display display) {
        IMemento memento = Singletons.getPersistenceManager(display).get(DIALOG_MEMENTO_TYPE);
        this.csect = memento.getString("CSECT");
        if (this.csect == null) {
            this.csect = "";
        }
        this.member = memento.getString("MEMBER");
        if (this.member == null) {
            this.member = "";
        }
        this.module = memento.getString("MODULE");
        if (this.module == null) {
            this.module = "";
        }
        this.program = memento.getString("PROGRAM");
        if (this.program == null) {
            this.program = "";
        }
        this.system = memento.getString("SYSTEM");
        if (this.system == null) {
            this.system = "";
        }
        this.lang = memento.getString("LANGUAGE");
        if (this.lang == null) {
            this.lang = "";
        }
        this.listMngr = memento.getString("LISTING_MANAGER");
        if (this.listMngr == null) {
            this.listMngr = "";
        }
        this.dsn = memento.getString("LISTING_DSN");
        if (this.dsn == null) {
            this.dsn = "";
        }
        this.sourceDsn = memento.getString("SOURCE_DSN");
        if (this.sourceDsn == null) {
            this.sourceDsn = "";
        }
        this.objectDsn = memento.getString("OBJECT_DSN");
        if (this.objectDsn == null) {
            this.objectDsn = "";
        }
        this.sourceVersion = memento.getString("SOURCE_VERSION");
        if (this.sourceVersion == null) {
            this.sourceVersion = "";
        }
        this.objectVersion = memento.getString("OBJECT_VERSION");
        if (this.objectVersion == null) {
            this.objectVersion = "";
        }
    }

    private void saveContent(Display display) {
        IMemento memento = Singletons.getPersistenceManager(display).get(DIALOG_MEMENTO_TYPE);
        memento.putString("PROGRAM", this.program);
        memento.putString("SYSTEM", this.system);
        memento.putString("SOURCE_DSN", this.sourceDsn);
        memento.putString("OBJECT_DSN", this.objectDsn);
        memento.putString("CSECT", this.csect);
        memento.putString("MEMBER", this.member);
        memento.putString("MODULE", this.module);
        memento.putString("LISTING_DSN", this.dsn);
        memento.putString("LANGUAGE", this.lang);
        memento.putString("LISTING_MANAGER", this.listMngr);
        Singletons.getPersistenceManager(this.getContents().getDisplay()).set(DIALOG_MEMENTO_TYPE, memento);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        this.composite = new Composite(superComposite, 4);
        this.composite.setLayout((Layout)new GridLayout(4, false));
        GridData gData = new GridData(4, 0, false, false);
        this.composite.setLayoutData((Object)gData);
        this.idealComposite = new Composite(superComposite, 4);
        this.idealComposite.setLayout((Layout)new GridLayout(4, false));
        GridData idealgData = new GridData(4, 0, false, false);
        this.idealComposite.setLayoutData((Object)idealgData);
        this.idealComposite.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.CONTEXT_HELP_ID);
        this.langLabel = new Label(this.composite, 0);
        this.langLabel.setText(LANGUAGE);
        gData = new GridData(32);
        this.langLabel.setLayoutData((Object)gData);
        this.langCombo = new Combo(this.composite, 12);
        this.langCombo.setItems(langChoices);
        if (this.lang != null) {
            for (Map.Entry<String, String> entry : langChoiceMap.entrySet()) {
                if (!this.lang.equals(entry.getValue())) continue;
                this.langCombo.select(this.langCombo.indexOf(entry.getKey()));
            }
        } else {
            this.langCombo.select(0);
        }
        this.idealLangIX = this.langCombo.indexOf(IDEAL);
        this.naturalLangIX = this.langCombo.indexOf("Natural");
        this.langCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int ix = RegisterListingDialog.this.langCombo.getSelectionIndex();
                if (RegisterListingDialog.this.isIdeal != (ix == RegisterListingDialog.this.idealLangIX)) {
                    RegisterListingDialog.this.readFieldContent();
                    RegisterListingDialog.this.isIdeal = ix == RegisterListingDialog.this.idealLangIX;
                    RegisterListingDialog.this.switchToIdeal(RegisterListingDialog.this.isIdeal);
                    RegisterListingDialog.this.restoreFieldContent();
                    RegisterListingDialog.this.langCombo.select(ix);
                    RegisterListingDialog.this.lang = langChoiceMap.get(RegisterListingDialog.this.langCombo.getText());
                }
                RegisterListingDialog.this.isNatural = (ix = RegisterListingDialog.this.langCombo.getSelectionIndex()) == RegisterListingDialog.this.naturalLangIX;
                if (!RegisterListingDialog.this.isIdeal) {
                    RegisterListingDialog.this.switchToNatural(RegisterListingDialog.this.isNatural);
                }
                RegisterListingDialog.this.lang = langChoiceMap.get(RegisterListingDialog.this.langCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.listMngrLabel = new Label(this.composite, 0);
        this.listMngrLabel.setText(LISTING_MANAGER);
        gData = new GridData(32);
        this.listMngrLabel.setLayoutData((Object)gData);
        this.listMngrCombo = new Combo(this.composite, 12);
        this.listMngrCombo.setItems(listMngrChoices);
        this.idealMngrIX = this.listMngrCombo.indexOf(IDEAL);
        if (this.listMngr != null) {
            for (Map.Entry<String, String> entry : listMngrChoiceMap.entrySet()) {
                if (!this.listMngr.equals(entry.getValue())) continue;
                this.listMngrCombo.select(this.listMngrCombo.indexOf(entry.getKey()));
            }
        } else {
            this.listMngrCombo.select(0);
        }
        this.listMngrCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int ix = RegisterListingDialog.this.listMngrCombo.getSelectionIndex();
                if (RegisterListingDialog.this.isIdeal != (ix == RegisterListingDialog.this.idealMngrIX)) {
                    RegisterListingDialog.this.readFieldContent();
                    RegisterListingDialog.this.isIdeal = ix == RegisterListingDialog.this.idealMngrIX;
                    RegisterListingDialog.this.switchToIdeal(RegisterListingDialog.this.isIdeal);
                    RegisterListingDialog.this.restoreFieldContent();
                    RegisterListingDialog.this.listMngrCombo.select(ix);
                    RegisterListingDialog.this.listMngr = listMngrChoiceMap.get(RegisterListingDialog.this.listMngrCombo.getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.dsnLabel = new Label(this.composite, 0);
        this.dsnLabel.setText(LISTING_DSN);
        gData = new GridData(32);
        this.dsnLabel.setLayoutData((Object)gData);
        this.dsnField = new Text(this.composite, 2052);
        this.dsnField.setTextLimit(54);
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.dsnField, 44);
        gData.horizontalSpan = 3;
        this.dsnField.setLayoutData((Object)gData);
        this.memberLabel = new Label(this.composite, 0);
        this.memberLabel.setText(MEMBER);
        gData = new GridData(32);
        int widthMember = Math.max(MEMBER.length(), PROGRAM.length()) - 1;
        gData.widthHint = gData.minimumWidth = TextUtil.calculateWidth((Control)this.memberLabel, widthMember);
        this.memberLabel.setLayoutData((Object)gData);
        this.memberField = new Text(this.composite, 2052);
        this.memberField.setTextLimit(8);
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.memberField, 8);
        this.memberField.setLayoutData((Object)gData);
        this.moduleLabel = new Label(this.idealComposite, 0);
        this.moduleLabel.setText(MODULE);
        gData = new GridData(32);
        this.moduleLabel.setLayoutData((Object)gData);
        this.moduleField = new Text(this.idealComposite, 2052);
        this.moduleField.setTextLimit(8);
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.moduleField, 8);
        this.moduleField.setLayoutData((Object)gData);
        this.moduleLabel.setVisible(false);
        this.moduleField.setVisible(false);
        this.csectLabel = new Label(this.idealComposite, 0);
        this.csectLabel.setText(CSECT);
        gData = new GridData(32);
        int width = Math.max(CSECT.length(), PROGRAM.length()) - 1;
        gData.widthHint = gData.minimumWidth = TextUtil.calculateWidth((Control)this.csectLabel, width);
        this.csectLabel.setLayoutData((Object)gData);
        this.csectField = new Text(this.idealComposite, 2052);
        this.csectField.setTextLimit(8);
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.csectField, 8);
        this.csectField.setLayoutData((Object)gData);
        this.csectLabel.setVisible(false);
        this.csectField.setVisible(false);
        this.dsn2Label = new Label(this.idealComposite, 0);
        this.dsn2Label.setText(SOURCE_DSN);
        gData = new GridData(3);
        this.dsn2Label.setLayoutData((Object)gData);
        this.dsn2Field = new Text(this.idealComposite, 2052);
        this.dsn2Field.setTextLimit(54);
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.dsn2Field, 44);
        gData.horizontalSpan = 3;
        this.dsn2Field.setLayoutData((Object)gData);
        this.objectLabel = new Label(this.idealComposite, 0);
        this.objectLabel.setText(OBJECT_VERSION);
        gData = new GridData(32);
        this.objectLabel.setLayoutData((Object)gData);
        this.objectField = new Text(this.idealComposite, 2052);
        this.objectField.setTextLimit(3);
        this.objectField.setToolTipText("0-999 or PRD");
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.objectField, 3);
        this.objectField.setLayoutData((Object)gData);
        this.sourceLabel = new Label(this.idealComposite, 0);
        this.sourceLabel.setText(SOURCE_VERSION);
        gData = new GridData(32);
        this.sourceLabel.setLayoutData((Object)gData);
        this.sourceField = new Text(this.idealComposite, 2052);
        this.sourceField.setTextLimit(3);
        this.sourceField.setToolTipText("0-999");
        gData = new GridData(4, 0, false, false);
        gData.minimumWidth = TextUtil.calculateWidth((Control)this.sourceField, 3);
        this.sourceField.setLayoutData((Object)gData);
        this.switchToIdeal(this.isIdeal);
        if (!this.isIdeal) {
            this.switchToNatural(this.isNatural);
        }
        this.restoreFieldContent();
        this.getShell().setDefaultButton(this.getButton(1));
        return this.composite;
    }

    public void switchToIdeal(boolean isIdeal) {
        this.csectLabel.setVisible(isIdeal);
        this.csectField.setVisible(isIdeal);
        this.sourceLabel.setVisible(isIdeal);
        this.sourceField.setVisible(isIdeal);
        this.objectLabel.setVisible(isIdeal);
        this.objectField.setVisible(isIdeal);
        this.moduleLabel.setVisible(isIdeal);
        this.moduleField.setVisible(isIdeal);
        this.idealComposite.setVisible(isIdeal);
        this.moduleLabel.setText(isIdeal ? SYSTEM : MODULE);
        this.moduleField.setTextLimit(isIdeal ? 3 : 8);
        this.csectLabel.setText(isIdeal ? PROGRAM : CSECT);
        this.dsnLabel.setText(isIdeal ? OBJECT_DSN : LISTING_DSN);
        this.dsn2Label.setVisible(isIdeal);
        this.dsn2Field.setVisible(isIdeal);
        if (isIdeal) {
            if (this.langCombo.getSelectionIndex() != this.idealLangIX) {
                this.lang = "IDEAL";
                this.langCombo.select(this.idealLangIX);
            }
            if (this.listMngrCombo.getSelectionIndex() != this.idealMngrIX) {
                this.listMngr = "IDEAL";
                this.listMngrCombo.select(this.idealMngrIX);
            }
        } else {
            if (this.langCombo.getSelectionIndex() == this.idealLangIX) {
                this.lang = null;
                this.langCombo.select(0);
            }
            if (this.listMngrCombo.getSelectionIndex() == this.idealMngrIX) {
                this.listMngr = null;
                this.listMngrCombo.select(0);
            }
        }
    }

    public void switchToNatural(boolean isNatural) {
        this.moduleLabel.setText(isNatural ? LIBRARY : MODULE);
        this.csectLabel.setText(isNatural ? ROUTINE : CSECT);
    }

    private void readFieldContent() {
        if (this.isIdeal) {
            this.program = this.csectField.getText();
            this.system = this.moduleField.getText();
            this.objectDsn = this.dsnField.getText();
            this.sourceDsn = this.dsn2Field.getText();
            this.objectVersion = this.validate(this.objectField.getText(), true);
            this.sourceVersion = this.validate(this.sourceField.getText(), false);
        } else {
            this.csect = this.csectField.getText();
            this.member = this.memberField.getText();
            this.module = this.moduleField.getText();
            this.dsn = this.dsnField.getText();
            this.lang = langChoiceMap.get(this.langCombo.getText());
            this.listMngr = listMngrChoiceMap.get(this.listMngrCombo.getText());
        }
    }

    private void restoreFieldContent() {
        if (this.isIdeal) {
            this.csectField.setText(this.program);
            this.memberField.setText(this.program);
            this.moduleField.setText(this.system);
            this.dsnField.setText(this.objectDsn);
            this.dsn2Field.setText(this.sourceDsn);
            this.objectField.setText(this.objectVersion);
            this.sourceField.setText(this.sourceVersion);
        } else {
            boolean found;
            this.csectField.setText(this.csect);
            this.memberField.setText(this.member);
            this.moduleField.setText(this.module);
            this.dsnField.setText(this.dsn);
            if (this.lang == null || this.lang.equals("IDEAL")) {
                this.langCombo.select(0);
            } else {
                found = false;
                for (Map.Entry<String, String> entry : langChoiceMap.entrySet()) {
                    if (!this.lang.equals(entry.getValue())) continue;
                    found = true;
                    this.langCombo.select(this.langCombo.indexOf(entry.getKey()));
                }
                if (!found) {
                    this.langCombo.select(0);
                }
                this.isNatural = this.langCombo.getSelectionIndex() == this.naturalLangIX;
                this.switchToNatural(this.isNatural);
            }
            if (this.listMngr == null || this.listMngr.equals("IDEAL")) {
                this.listMngrCombo.select(0);
            } else {
                found = false;
                for (Map.Entry<String, String> entry : listMngrChoiceMap.entrySet()) {
                    if (!this.listMngr.equals(entry.getValue())) continue;
                    found = true;
                    this.listMngrCombo.select(this.listMngrCombo.indexOf(entry.getKey()));
                }
                if (!found) {
                    this.listMngrCombo.select(0);
                }
            }
        }
    }

    protected void okPressed() {
        final Shell shell = this.getShell();
        this.readFieldContent();
        this.saveContent(shell.getDisplay());
        if (this.dsn.startsWith("'") || this.dsn.endsWith("'")) {
            this.dsn = this.dsn.replace("'", " ").trim();
        }
        if (Singletons.getServerProxy(this.getContents().getDisplay()).getConnectedServer() == null) {
            MessageDialog.openInformation((Shell)shell, (String)"No server connection", (String)"You need to be connected to a server to register a listing.");
            return;
        }
        if (this.lang == null || this.lang.isEmpty() || this.listMngr == null || this.listMngr.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please select language and listing manager type.");
            return;
        }
        if (this.isIdeal && (this.objectDsn.isEmpty() || this.sourceDsn.isEmpty())) {
            MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please select the object and source dataset names.");
            return;
        }
        if (this.isIdeal && !VerifyPDS.isDSN(this.objectDsn)) {
            MessageDialog.openInformation((Shell)shell, (String)"Invalid format", (String)"Specified object dataset is not a valid DSN");
            return;
        }
        if (this.isIdeal && !VerifyPDS.isDSN(this.sourceDsn)) {
            MessageDialog.openInformation((Shell)shell, (String)"Invalid format", (String)"Specified source dataset is not a valid DSN");
            return;
        }
        if (!this.isIdeal && this.dsn.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please select dataset name of the listing to be registered.");
            return;
        }
        if (!this.isIdeal && !VerifyPDS.isDSN(this.dsn) || this.dsn.contains("(") || this.dsn.contains(")")) {
            MessageDialog.openInformation((Shell)shell, (String)"Invalid format", (String)"Specified dataset is not a valid DSN");
            return;
        }
        if (this.isIdeal) {
            this.module = this.system;
            this.csect = this.program;
            this.dsn = String.valueOf(this.objectDsn) + "/" + this.sourceDsn;
            this.module = String.valueOf(this.module) + this.objectVersion + this.sourceVersion;
            if (this.objectVersion.isEmpty() || this.sourceVersion.isEmpty()) {
                MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please enter valid object and source version.");
                return;
            }
        }
        if (this.member.isEmpty() && (this.listMngr == "PDS" || this.listMngr == "DDIO" || this.listMngr == "LIBRARIAN" || this.listMngr == "PANVALET" || this.listMngr == "PROTSYM")) {
            MessageDialog.openInformation((Shell)shell, (String)"Invalid format", (String)"Please add the member name.");
            return;
        }
        this.dsn = this.dsn.concat("(" + this.member + ")");
        ServerCallback callback = new ServerCallback(){

            @Override
            public void processReply(XMLRequest reply, MATServer server) {
                if (reply.getErrorLevel() == 0) {
                    Singletons.getListingManager().clearCachedListing(RegisterListingDialog.this.csect);
                    Singletons.getListingManager().retrieveTunlists();
                    MessageDialog.openInformation((Shell)shell, (String)"Listing Registered", (String)"Registration successfully completed.");
                }
            }

            @Override
            public void cancel(XMLRequest reply, MATServer server) {
            }

            @Override
            public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                return false;
            }
        };
        Singletons.getServerProxy(this.getContents().getDisplay()).registerListing(this.module, this.csect, this.lang, this.listMngr, this.dsn, callback);
        this.close();
    }

    private String validate(String value, boolean allowPRD) {
        int version;
        block4: {
            try {
                version = Integer.parseInt(value);
                if (version >= 0 && version <= 999) break block4;
                return "";
            }
            catch (NumberFormatException numberFormatException) {
                if ("PRD".equals(value) && allowPRD) {
                    return value;
                }
                return "";
            }
        }
        return String.format("%03d", version);
    }

    @Override
    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format("Listing Registration", new Object[0]));
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    public void setLanguage(String lang) {
        if (lang != null) {
            int i = 0;
            while (i < langChoices.length) {
                if (langChoices[i].equals(lang)) {
                    this.lang = lang;
                    this.langCombo.select(i);
                }
                ++i;
            }
        }
    }
}

