/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.logging.Logging;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CallCommandContributionItem
extends ContributionItem {
    private String commandId;
    private String name;
    private MenuItem menuItem;
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public CallCommandContributionItem(String commandId, String name) {
        this.commandId = commandId;
        this.name = name;
    }

    public void fill(Menu menu, int index) {
        this.menuItem = new MenuItem(menu, 0, index);
        this.menuItem.setText(this.name);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CallCommandContributionItem.this.run();
            }
        });
        this.updateEnablement();
    }

    protected void run() {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService comm = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = comm.getCommand(this.commandId);
        try {
            if (command.isEnabled()) {
                service.executeCommand(this.commandId, null);
            }
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(PlatformUI.getWorkbench().getDisplay());
            log.log(Level.SEVERE, "Failed to execute command " + this.commandId, e);
        }
    }

    private void updateEnablement() {
        this.menuItem.setEnabled(true);
    }
}

